/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.judan;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.co.sra.judan.JudanMethodWrapper;
import jp.co.sra.judan.JudanParsedInfo;
import jp.co.sra.judan.JudanParser;
import jp.co.sra.judan.JudanSuitableParameterSection;
import jp.co.sra.judan.JudanView;
import jp.co.sra.judan.JudanViewWithJun;
import jp.co.sra.judan.ParseException;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JudanGeometryManager
extends JFrame {
    private JMenuBar menuBar;
    JPanel buttonPanel;
    JButton[] buttons;
    JList list;
    JScrollPane listPane;
    JCheckBox checkOutput;
    JCheckBox checkDisplay;
    Hashtable table;

    public JudanGeometryManager(String title) {
        this.setTitle(title);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu menuFile = this.addMenu("File");
        JMenuItem menuItemFileOpen = this.addMenuItem("Open", new OpenMenu(this));
        menuFile.add(menuItemFileOpen);
        menuFile.addSeparator();
        JMenuItem menuItemFileExit = this.addMenuItem("Exit", new ExitMenu());
        menuFile.add(menuItemFileExit);
        this.setList(new ListSelect(this));
        String[] buttonName = new String[]{"Show", "Evaluation", "Singular", "Inflexion", "Intersection", "Projection", "Offset", "Fillet", "Tabcyl", "Loft"};
        ActionListener[] listenerList = new ActionListener[]{new ShowButton(this), new EvaluationButton(this), new SingularButton(this), new InflexionButton(this), new IntersectionButton(this), new ProjectionButton(this), new OffsetButton(this), new FilletButton(this), new TabcylButton(this), new LoftButton(this)};
        this.checkOutput = new JCheckBox("ASCII", true);
        this.checkDisplay = new JCheckBox("Jun", true);
        JPanel checkPanel = new JPanel(new GridLayout(1, 2));
        checkPanel.add(this.checkOutput);
        checkPanel.add(this.checkDisplay);
        this.buttonPanel = new JPanel(new GridLayout(buttonName.length + 1, 1));
        this.buttonPanel.add(checkPanel);
        this.setButtonPanel(buttonName, listenerList);
        this.getContentPane().add((Component)this.listPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "East");
        ((Component)this).setSize(500, 300);
        ((Component)this).setVisible(true);
    }

    public void setButtonPanel(JButton[] buttons) {
        int i = 0;
        while (i < buttons.length) {
            this.buttonPanel.add(buttons[i]);
            ++i;
        }
    }

    public void setButtonPanel(String[] buttonNames, ActionListener[] listenerClasses) {
        int numberOfButtons = buttonNames.length;
        this.buttons = new JButton[numberOfButtons];
        int i = 0;
        while (i < numberOfButtons) {
            this.buttons[i] = new JButton(buttonNames[i]);
            this.buttons[i].addActionListener(listenerClasses[i]);
            this.buttons[i].setEnabled(false);
            this.buttonPanel.add(this.buttons[i]);
            ++i;
        }
    }

    public JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(name);
        button.addActionListener(listener);
        return button;
    }

    public void addName(String name) {
        ((DefaultListModel)this.list.getModel()).addElement(name);
    }

    public void setList(ListModel listModel, ListSelectionModel listSelectionModel, ListSelectionListener listener) {
        this.list = new JList(listModel);
        this.list.setSelectionModel(listSelectionModel);
        this.list.addListSelectionListener(listener);
        this.listPane = new JScrollPane(this.list);
    }

    public void setList(ListModel listModel, ListSelectionListener listener) {
        this.setList(listModel, new DefaultListSelectionModel(), listener);
    }

    public void setList(ListSelectionListener listener) {
        this.setList(new DefaultListModel(), listener);
    }

    protected JMenu addMenu(String menuName) {
        JMenu menu = new JMenu(menuName);
        this.menuBar.add(menu);
        return menu;
    }

    protected JMenuItem addMenuItem(String itemName, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem(itemName);
        menuItem.addActionListener(listener);
        return menuItem;
    }

    public static void main(String[] args) {
        JudanGeometryManager gm = new JudanGeometryManager("JGCL Geometry Manager");
    }

    class OpenMenu
    implements ActionListener {
        JudanGeometryManager gm;
        JudanParser parser;

        OpenMenu(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(".");
            int result = fileChooser.showOpenDialog(this.gm);
            File file = fileChooser.getSelectedFile();
            if (result != 0 || file == null) {
                return;
            }
            try {
                FileInputStream inputStream = new FileInputStream(file);
                if (this.parser != null) {
                    JudanParser.ReInit();
                    JudanParser.ReInit(inputStream);
                } else {
                    this.parser = new JudanParser(inputStream);
                }
                JudanParsedInfo parsedInfo = JudanParser.jgclFile();
                Vector nameList = JudanParser.getNameList();
                this.gm.list.setListData(nameList);
                this.gm.table = JudanParser.getEntityTable();
                parsedInfo.execute(JudanGeometryManager.this.checkOutput.isSelected(), false, JudanGeometryManager.this.checkDisplay.isSelected());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (ParseException parseException) {}
        }
    }

    public class ExitMenu
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }

        public ExitMenu() {
            JudanGeometryManager.this = JudanGeometryManager.this;
        }
    }

    public class ListSelect
    implements ListSelectionListener {
        JudanGeometryManager gm;

        ListSelect(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void valueChanged(ListSelectionEvent e) {
            JList list = (JList)e.getSource();
            if (list.getSelectedValues().length < 1) {
                this.gm.buttons[0].setEnabled(false);
                this.gm.buttons[1].setEnabled(false);
                this.gm.buttons[2].setEnabled(false);
                this.gm.buttons[3].setEnabled(false);
                this.gm.buttons[4].setEnabled(false);
                this.gm.buttons[5].setEnabled(false);
                this.gm.buttons[6].setEnabled(false);
                this.gm.buttons[7].setEnabled(false);
                this.gm.buttons[8].setEnabled(false);
                this.gm.buttons[9].setEnabled(false);
            } else if (list.getSelectedValues().length == 1) {
                this.gm.buttons[0].setEnabled(true);
                this.gm.buttons[1].setEnabled(true);
                this.gm.buttons[2].setEnabled(true);
                this.gm.buttons[3].setEnabled(true);
                this.gm.buttons[4].setEnabled(false);
                this.gm.buttons[5].setEnabled(false);
                this.gm.buttons[6].setEnabled(true);
                this.gm.buttons[7].setEnabled(false);
                this.gm.buttons[8].setEnabled(true);
                this.gm.buttons[9].setEnabled(true);
            } else if (list.getSelectedValues().length == 2) {
                this.gm.buttons[0].setEnabled(true);
                this.gm.buttons[1].setEnabled(false);
                this.gm.buttons[2].setEnabled(false);
                this.gm.buttons[3].setEnabled(false);
                this.gm.buttons[4].setEnabled(true);
                this.gm.buttons[5].setEnabled(true);
                this.gm.buttons[6].setEnabled(false);
                this.gm.buttons[7].setEnabled(true);
                this.gm.buttons[8].setEnabled(false);
                this.gm.buttons[9].setEnabled(false);
            } else {
                this.gm.buttons[0].setEnabled(true);
                this.gm.buttons[1].setEnabled(false);
                this.gm.buttons[2].setEnabled(false);
                this.gm.buttons[3].setEnabled(false);
                this.gm.buttons[4].setEnabled(false);
                this.gm.buttons[5].setEnabled(false);
                this.gm.buttons[6].setEnabled(false);
                this.gm.buttons[7].setEnabled(false);
                this.gm.buttons[8].setEnabled(false);
                this.gm.buttons[9].setEnabled(false);
            }
        }
    }

    public class ShowButton
    implements ActionListener {
        JudanGeometryManager gm;
        JList list;
        Hashtable table;
        JgclGeometry[] geometries;
        JudanView view;

        ShowButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            int numberOfElement = this.gm.list.getSelectedValues().length;
            this.geometries = new JgclGeometry[numberOfElement];
            int i = 0;
            while (i < numberOfElement) {
                this.geometries[i] = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[i]);
                ++i;
            }
            if (JudanGeometryManager.this.checkOutput.isSelected()) {
                int i2 = 0;
                while (i2 < this.geometries.length) {
                    this.geometries[i2].output((OutputStream)System.out);
                    ++i2;
                }
            }
            if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                this.view = new JudanView(new JudanViewWithJun());
                this.view.display(this.geometries);
            }
        }
    }

    public class EvaluationButton
    implements ActionListener {
        JudanGeometryManager gm;

        EvaluationButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JgclGeometry geometry = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[0]);
                Object[] textObj = null;
                Class[] argClasses = null;
                Object[] argEntities = null;
                if (geometry instanceof JgclParametricCurve2D || geometry instanceof JgclParametricCurve3D) {
                    JTextField text = new JTextField();
                    text.setBorder(new TitledBorder("Parameter"));
                    textObj = new Object[]{text};
                    int ans = JOptionPane.showConfirmDialog(this.gm, textObj, "Coordinate", 2);
                    if (ans != 0) {
                        return;
                    }
                    argClasses = new Class[]{Class.forName("java.lang.Double")};
                    argEntities = new Double[]{Double.valueOf(text.getText())};
                } else if (geometry instanceof JgclParametricSurface3D) {
                    JTextField text1 = new JTextField();
                    text1.setBorder(new TitledBorder("uParameter"));
                    JTextField text2 = new JTextField();
                    text2.setBorder(new TitledBorder("vParameter"));
                    textObj = new Object[]{text1, text2};
                    int ans = JOptionPane.showConfirmDialog(this.gm, textObj, "Coordinate", 2);
                    if (ans != 0) {
                        return;
                    }
                    argClasses = new Class[]{Class.forName("java.lang.Double"), Class.forName("java.lang.Double")};
                    argEntities = new Double[]{Double.valueOf(text1.getText()), Double.valueOf(text2.getText())};
                } else {
                    System.out.println("not a suitable selection");
                    return;
                }
                JudanMethodWrapper method = new JudanMethodWrapper(geometry, "coordinates", argClasses, argEntities);
                method.invoke();
                if (JudanGeometryManager.this.checkOutput.isSelected()) {
                    method.output();
                }
                if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                    method.view();
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Number Format Exception!!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class Not Found Exception!!");
            }
        }
    }

    public class SingularButton
    implements ActionListener {
        JudanGeometryManager gm;

        SingularButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry geometry = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[0]);
            Class[] argClasses = null;
            Object[] argEntities = null;
            if (!(geometry instanceof JgclParametricCurve)) {
                System.out.println("not a suitable selection");
                return;
            }
            argClasses = new Class[]{};
            argEntities = new Double[]{};
            JudanMethodWrapper method = new JudanMethodWrapper(geometry, "singular", argClasses, argEntities);
            method.invoke();
            if (JudanGeometryManager.this.checkOutput.isSelected()) {
                method.output();
            }
            if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                method.view();
            }
        }
    }

    public class InflexionButton
    implements ActionListener {
        JudanGeometryManager gm;

        InflexionButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry geometry = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[0]);
            Class[] argClasses = null;
            Object[] argEntities = null;
            if (!(geometry instanceof JgclParametricCurve)) {
                System.out.println("not a suitable selection");
                return;
            }
            argClasses = new Class[]{};
            argEntities = new Double[]{};
            JudanMethodWrapper method = new JudanMethodWrapper(geometry, "inflexion", argClasses, argEntities);
            method.invoke();
            if (JudanGeometryManager.this.checkOutput.isSelected()) {
                method.output();
            }
            if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                method.view();
            }
        }
    }

    public class IntersectionButton
    implements ActionListener {
        JudanGeometryManager gm;

        IntersectionButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];
            int i = 0;
            while (i < 2) {
                geometries[i] = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[i]);
                ++i;
            }
            Class[] argClasses = new Class[1];
            Object[] argEntities = new Object[1];
            try {
                if (geometries[0] instanceof JgclParametricCurve2D) {
                    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve2D");
                    argEntities[0] = (JgclParametricCurve2D)geometries[1];
                } else if (geometries[0] instanceof JgclParametricCurve3D) {
                    if (geometries[1] instanceof JgclParametricCurve3D) {
                        argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve3D");
                        argEntities[0] = (JgclParametricCurve3D)geometries[1];
                    } else if (geometries[1] instanceof JgclParametricSurface3D) {
                        argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D");
                        argEntities[0] = (JgclParametricSurface3D)geometries[1];
                    } else {
                        System.out.println("not a suitable selection");
                    }
                } else if (geometries[0] instanceof JgclParametricSurface3D) {
                    if (geometries[1] instanceof JgclParametricCurve3D) {
                        argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve3D");
                        argEntities[0] = (JgclParametricCurve3D)geometries[1];
                    } else if (geometries[1] instanceof JgclParametricSurface3D) {
                        argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D");
                        argEntities[0] = (JgclParametricSurface3D)geometries[1];
                    } else {
                        System.out.println("not a suitable selection");
                    }
                } else {
                    System.out.println("not a suitable selection");
                }
                JudanMethodWrapper method = new JudanMethodWrapper(geometries[0], "intersect", argClasses, argEntities);
                method.invoke();
                if (JudanGeometryManager.this.checkOutput.isSelected()) {
                    method.output();
                }
                if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                    method.view();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class Not Found Exception!!");
            }
        }
    }

    public class ProjectionButton
    implements ActionListener {
        JudanGeometryManager gm;

        ProjectionButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];
            int i = 0;
            while (i < 2) {
                geometries[i] = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[i]);
                ++i;
            }
            Class[] argClasses = new Class[1];
            Object[] argEntities = new Object[1];
            JudanMethodWrapper method = null;
            try {
                if (geometries[0] instanceof JgclParametricCurve2D && geometries[1] instanceof JgclPoint2D || geometries[1] instanceof JgclParametricCurve2D && geometries[0] instanceof JgclPoint2D) {
                    JgclPoint2D point;
                    JgclParametricCurve2D curve;
                    if (geometries[0] instanceof JgclParametricCurve2D) {
                        curve = (JgclParametricCurve2D)geometries[0];
                        point = (JgclPoint2D)geometries[1];
                    } else {
                        curve = (JgclParametricCurve2D)geometries[1];
                        point = (JgclPoint2D)geometries[0];
                    }
                    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclPoint2D");
                    argEntities[0] = point;
                    method = new JudanMethodWrapper((JgclGeometry)curve, "projectFrom", argClasses, argEntities);
                } else if (geometries[0] instanceof JgclParametricCurve3D && geometries[1] instanceof JgclPoint3D || geometries[1] instanceof JgclParametricCurve3D && geometries[0] instanceof JgclPoint3D) {
                    JgclPoint3D point;
                    JgclParametricCurve3D curve;
                    if (geometries[0] instanceof JgclParametricCurve3D) {
                        curve = (JgclParametricCurve3D)geometries[0];
                        point = (JgclPoint3D)geometries[1];
                    } else {
                        curve = (JgclParametricCurve3D)geometries[1];
                        point = (JgclPoint3D)geometries[0];
                    }
                    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclPoint3D");
                    argEntities[0] = point;
                    method = new JudanMethodWrapper((JgclGeometry)curve, "projectFrom", argClasses, argEntities);
                } else if (geometries[0] instanceof JgclParametricSurface3D && geometries[1] instanceof JgclPoint3D || geometries[1] instanceof JgclParametricSurface3D && geometries[0] instanceof JgclPoint3D) {
                    JgclPoint3D point;
                    JgclParametricSurface3D surface;
                    if (geometries[0] instanceof JgclParametricSurface3D) {
                        surface = (JgclParametricSurface3D)geometries[0];
                        point = (JgclPoint3D)geometries[1];
                    } else {
                        surface = (JgclParametricSurface3D)geometries[1];
                        point = (JgclPoint3D)geometries[0];
                    }
                    argClasses[0] = Class.forName("jp.go.ipa.jgcl.JgclPoint3D");
                    argEntities[0] = point;
                    method = new JudanMethodWrapper((JgclGeometry)surface, "projectFrom", argClasses, argEntities);
                } else {
                    System.out.println("not a suitable selection");
                }
                method.invoke();
                if (JudanGeometryManager.this.checkOutput.isSelected()) {
                    method.output();
                }
                if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                    method.view();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class Not Found Exception!!");
            }
        }
    }

    public class FilletButton
    implements ActionListener {
        JudanGeometryManager gm;

        FilletButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];
            int i = 0;
            while (i < 2) {
                geometries[i] = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[i]);
                ++i;
            }
            try {
                JTextField text;
                Object[] textObj = null;
                Class[] argClasses = null;
                Object[] argEntities = null;
                if (geometries[0] instanceof JgclParametricCurve2D && geometries[1] instanceof JgclParametricCurve2D) {
                    text = new JTextField();
                    JRadioButton rb1 = new JRadioButton("Left", true);
                    JRadioButton rb2 = new JRadioButton("Right");
                    ButtonGroup bg1 = new ButtonGroup();
                    JRadioButton rb3 = new JRadioButton("Left", true);
                    JRadioButton rb4 = new JRadioButton("Right");
                    ButtonGroup bg2 = new ButtonGroup();
                    JPanel bp = new JPanel(new GridLayout(2, 2));
                    bg1.add(rb1);
                    bg1.add(rb2);
                    bg2.add(rb3);
                    bg2.add(rb4);
                    bp.add(rb1);
                    bp.add(rb3);
                    bp.add(rb2);
                    bp.add(rb4);
                    text.setBorder(new TitledBorder("Radius"));
                    textObj = new Object[]{text, bp};
                    int ans = JOptionPane.showConfirmDialog(this.gm, textObj, "Fillet", 2);
                    if (ans != 0) {
                        return;
                    }
                    argClasses = new Class[]{Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Integer.TYPE, Class.forName("jp.go.ipa.jgcl.JgclParametricCurve2D"), Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Integer.TYPE, Double.TYPE};
                    argEntities = new Object[]{JudanSuitableParameterSection.asCurve(geometries[0]), rb1.isSelected() ? new Integer(2) : new Integer(1), geometries[1], JudanSuitableParameterSection.asCurve(geometries[1]), rb3.isSelected() ? new Integer(2) : new Integer(1), Double.valueOf(text.getText())};
                } else if (geometries[0] instanceof JgclParametricSurface3D) {
                    text = new JTextField();
                    JRadioButton rb1 = new JRadioButton("Front", true);
                    JRadioButton rb2 = new JRadioButton("Back");
                    ButtonGroup bg1 = new ButtonGroup();
                    JRadioButton rb3 = new JRadioButton("Front", true);
                    JRadioButton rb4 = new JRadioButton("Back");
                    ButtonGroup bg2 = new ButtonGroup();
                    JPanel bp = new JPanel(new GridLayout(2, 2));
                    bg1.add(rb1);
                    bg1.add(rb2);
                    bg2.add(rb3);
                    bg2.add(rb4);
                    bp.add(rb1);
                    bp.add(rb3);
                    bp.add(rb2);
                    bp.add(rb4);
                    text.setBorder(new TitledBorder("Radius"));
                    textObj = new Object[]{text, bp};
                    int ans = JOptionPane.showConfirmDialog(this.gm, textObj, "Fillet", 2);
                    if (ans != 0) {
                        return;
                    }
                    argClasses = new Class[]{Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Integer.TYPE, Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D"), Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Integer.TYPE, Double.TYPE};
                    argEntities = new Object[8];
                    JgclParameterSection[] secs = JudanSuitableParameterSection.asSurface(geometries[0]);
                    argEntities[0] = secs[0];
                    argEntities[1] = secs[1];
                    argEntities[2] = rb1.isSelected() ? new Integer(3) : new Integer(4);
                    argEntities[3] = geometries[1];
                    secs = JudanSuitableParameterSection.asSurface(geometries[1]);
                    argEntities[4] = secs[0];
                    argEntities[5] = secs[1];
                    argEntities[6] = rb1.isSelected() ? new Integer(3) : new Integer(4);
                    argEntities[7] = Double.valueOf(text.getText());
                } else {
                    System.out.println("not a suitable selection");
                    return;
                }
                JudanMethodWrapper method = new JudanMethodWrapper(geometries[0], "fillet", argClasses, argEntities);
                method.invoke();
                if (JudanGeometryManager.this.checkOutput.isSelected()) {
                    method.output();
                }
                if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                    method.view();
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Number Format Exception!!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class Not Found Exception!!");
            }
        }
    }

    public class OffsetButton
    implements ActionListener {
        JudanGeometryManager gm;

        OffsetButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry geometry = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[0]);
            try {
                String functionName;
                JTextField text;
                Object[] textObj = null;
                Class[] argClasses = null;
                Object[] argEntities = null;
                if (geometry instanceof JgclParametricCurve2D) {
                    text = new JTextField();
                    JRadioButton rb1 = new JRadioButton("Left", true);
                    JRadioButton rb2 = new JRadioButton("Right");
                    ButtonGroup bg = new ButtonGroup();
                    bg.add(rb1);
                    bg.add(rb2);
                    text.setBorder(new TitledBorder("Magni"));
                    textObj = new Object[]{text, rb1, rb2};
                    int ans = JOptionPane.showConfirmDialog(this.gm, textObj, "offset", 2);
                    functionName = "offsetByBsplineCurve";
                    if (ans != 0) {
                        return;
                    }
                    argClasses = new Class[]{Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Double.TYPE, Integer.TYPE, Class.forName("jp.go.ipa.jgcl.JgclToleranceForDistance")};
                    argEntities = new Object[4];
                    JgclParameterSection pint = JudanSuitableParameterSection.asCurve(geometry);
                    argEntities[0] = pint;
                    argEntities[1] = Double.valueOf(text.getText());
                    argEntities[2] = rb1.isSelected() ? new Integer(2) : new Integer(1);
                    argEntities[3] = new JgclToleranceForDistance(0.01);
                } else if (geometry instanceof JgclParametricSurface3D) {
                    text = new JTextField();
                    JRadioButton rb1 = new JRadioButton("Front", true);
                    JRadioButton rb2 = new JRadioButton("Back");
                    ButtonGroup bg = new ButtonGroup();
                    bg.add(rb1);
                    bg.add(rb2);
                    text.setBorder(new TitledBorder("Magni"));
                    textObj = new Object[]{text, rb1, rb2};
                    int ans = JOptionPane.showConfirmDialog(this.gm, textObj, "Offset", 2);
                    functionName = "offsetByBsplineSurface";
                    if (ans != 0) {
                        return;
                    }
                    argClasses = new Class[]{Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Class.forName("jp.go.ipa.jgcl.JgclParameterSection"), Double.TYPE, Integer.TYPE, Class.forName("jp.go.ipa.jgcl.JgclToleranceForDistance")};
                    argEntities = new Object[5];
                    JgclParameterSection[] secs = JudanSuitableParameterSection.asSurface(geometry);
                    argEntities[0] = secs[0];
                    argEntities[1] = secs[1];
                    argEntities[2] = Double.valueOf(text.getText());
                    argEntities[3] = rb1.isSelected() ? new Integer(3) : new Integer(4);
                    argEntities[4] = new JgclToleranceForDistance(0.01);
                } else {
                    System.out.println("not a suitable selection");
                    return;
                }
                JudanMethodWrapper method = new JudanMethodWrapper(geometry, functionName, argClasses, argEntities);
                method.invoke();
                if (JudanGeometryManager.this.checkOutput.isSelected()) {
                    method.output();
                }
                if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                    method.view();
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Number Format Exception!!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class Not Found Exception!!");
            }
        }
    }

    public class TabcylButton
    implements ActionListener {
        JudanGeometryManager gm;

        TabcylButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];
            int i = 0;
            while (i < 2) {
                geometries[i] = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[i]);
                ++i;
            }
            Class[] argClasses = new Class[1];
            Object[] argEntities = new Object[1];
            try {
                if (!(geometries[0] instanceof JgclBsplineSurface3D) || !(geometries[1] instanceof JgclBsplineSurface3D)) {
                    System.out.println("not a suitable selection");
                    return;
                }
                argClasses = new Class[]{Class.forName("jp.go.ipa.jgcl.JgclBsplineCurve3D")};
                argEntities[0] = (JgclBsplineCurve3D)geometries[1];
                JudanMethodWrapper method = new JudanMethodWrapper(geometries[0], "tabcylSurface", argClasses, argEntities);
                method.invoke();
                if (JudanGeometryManager.this.checkOutput.isSelected()) {
                    method.output();
                }
                if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                    method.view();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class Not Found Exception!!");
            }
        }
    }

    public class LoftButton
    implements ActionListener {
        JudanGeometryManager gm;

        LoftButton(JudanGeometryManager gm) {
            JudanGeometryManager.this = JudanGeometryManager.this;
            this.gm = gm;
        }

        public void actionPerformed(ActionEvent e) {
            JgclGeometry[] geometries = new JgclGeometry[2];
            int i = 0;
            while (i < 2) {
                geometries[i] = (JgclGeometry)this.gm.table.get((String)this.gm.list.getSelectedValues()[i]);
                ++i;
            }
            try {
                Object[] textObj = null;
                Class[] argClasses = null;
                Object[] argEntities = null;
                JgclBsplineCurve3D curve = null;
                JgclVector3D vector = null;
                if (geometries[0] instanceof JgclBsplineCurve3D && geometries[1] instanceof JgclVector3D) {
                    curve = (JgclBsplineCurve3D)geometries[0];
                    vector = (JgclVector3D)geometries[1];
                } else if (geometries[1] instanceof JgclBsplineCurve3D && geometries[0] instanceof JgclVector3D) {
                    curve = (JgclBsplineCurve3D)geometries[1];
                    vector = (JgclVector3D)geometries[0];
                } else {
                    System.out.println("not a suitable selection");
                    return;
                }
                JTextField text1 = new JTextField();
                text1.setBorder(new TitledBorder("parameter"));
                textObj = new Object[]{text1};
                int ans = JOptionPane.showConfirmDialog(this.gm, textObj, "Loft", 2);
                if (ans != 0) {
                    return;
                }
                argClasses = new Class[]{Class.forName("jp.go.ipa.jgcl.JgclVector3D"), Class.forName("java.lang.Double")};
                argEntities = new Object[]{vector, Double.valueOf(text1.getText())};
                JudanMethodWrapper method = new JudanMethodWrapper((JgclGeometry)curve, "loftSurface", argClasses, argEntities);
                method.invoke();
                if (JudanGeometryManager.this.checkOutput.isSelected()) {
                    method.output();
                }
                if (JudanGeometryManager.this.checkDisplay.isSelected()) {
                    method.view();
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Number Format Exception!!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class Not Found Exception!!");
            }
        }
    }
}

