/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.judan;

import java.io.FileNotFoundException;
import java.io.FileReader;
import jp.co.sra.judan.JudanParsedInfo;
import jp.co.sra.judan.JudanParser;
import jp.co.sra.judan.ParseException;

public class Judan {
    private static final boolean debugFlag = false;
    private boolean isOutputCharacter = false;
    private boolean isOutputLispSExpression = false;
    private boolean isOutputVisual = false;
    private boolean isInputFromFile = false;
    private String fileName;

    private void usage() {
        System.out.println("Usage: java Judan [-[c|l]v[f filename]]");
        System.exit(0);
    }

    private void processArgument(String arg) {
        int i = 1;
        while (i < arg.length()) {
            switch (arg.charAt(i)) {
                case 'h': {
                    this.usage();
                    break;
                }
                case 'c': {
                    if (this.isOutputLispSExpression) {
                        this.usage();
                        break;
                    }
                    if (!this.isOutputCharacter) {
                        this.isOutputCharacter = true;
                        break;
                    }
                    this.usage();
                    break;
                }
                case 'l': {
                    if (this.isOutputCharacter) {
                        this.usage();
                        break;
                    }
                    if (!this.isOutputLispSExpression) {
                        this.isOutputLispSExpression = true;
                        break;
                    }
                    this.usage();
                    break;
                }
                case 'v': {
                    if (!this.isOutputVisual) {
                        this.isOutputVisual = true;
                        break;
                    }
                    this.usage();
                    break;
                }
                case 'f': {
                    if (!this.isInputFromFile) {
                        this.isInputFromFile = true;
                        break;
                    }
                    this.usage();
                    break;
                }
                default: {
                    this.usage();
                }
            }
            ++i;
        }
    }

    private void processArguments(String[] args) {
        int nArg = args.length;
        int i = 0;
        while (i < nArg) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                this.processArgument(arg);
            } else if (!this.isInputFromFile) {
                this.usage();
            } else {
                this.fileName = arg;
            }
            ++i;
        }
    }

    public boolean isOutputCharacter() {
        return this.isOutputCharacter;
    }

    public boolean isOutputLispSExpression() {
        return this.isOutputLispSExpression;
    }

    public boolean isOutputVisual() {
        return this.isOutputVisual;
    }

    public boolean isInputFromFile() {
        return this.isInputFromFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static void main(String[] args) {
        Judan judan = new Judan();
        judan.processArguments(args);
        JudanParser parser = null;
        String fileName = null;
        try {
            if (!judan.isInputFromFile()) {
                parser = new JudanParser(System.in);
            } else {
                fileName = judan.getFileName();
                if (fileName != null) {
                    parser = new JudanParser(new FileReader(fileName));
                } else {
                    System.out.println("Filename is needed.");
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException();
        }
        JudanParsedInfo parsedInfo = null;
        try {
            parsedInfo = JudanParser.jgclFile();
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.out.println("Failure Parse!!");
            throw new RuntimeException();
        }
        parsedInfo.execute(judan.isOutputCharacter(), judan.isOutputLispSExpression(), judan.isOutputVisual());
    }
}

