/* Mycb.java	Java html parser wrapper
 * Copyright (C) 2018,2019 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.text.html.HTMLEditorKit.ParserCallback;

import java.io.StringReader;
import java.util.ArrayList;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Collections;
import javax.swing.text.MutableAttributeSet;
import java.util.LinkedHashMap;

import javax.swing.text.html.HTML;
import javax.swing.text.html.HTML.Tag;
import javax.swing.text.html.HTML.Attribute;

//https://www.mkyong.com/java/how-to-send-http-request-getpost-in-java/
// 翻訳機のデフォがjavax.swing.text.html.parser.ParserDelegatorに入ってるから
// そいつをパクって書き換える。のが定石らしい。よく分からんが動きゃいいんだよ。

public class Mycb extends ParserCallback {
	private StringBuffer plain;
	private int max_KB;

	private MapM<String, String> m_tag;	//src, http://... : img, http://....
	private MapM<String, String> m_prp;

	public Mycb() {
		super();	//親クラス丸投げ。
		//System.out.println("呼ばれた");
		this.plain = new StringBuffer();	//プリミティブ以外はnewしないとだめってさ
		this.max_KB = 0;	//0は無制限 1024 * (1000*10);	//10MB
		this.m_tag = new MapM<String, String>();	// キーはstring, dataもsring.
		this.m_prp = new MapM<String, String>();
	}

	public Mycb(int bufsize_KB) {
		super();
		//System.out.println("呼ばれた");
		this.plain = new StringBuffer();
		this.max_KB = 1024 * bufsize_KB;

		this.m_tag = new MapM<String, String>();
		this.m_prp = new MapM<String, String>();
	}

	public String getplain() {
		return this.plain.toString();
	}
	public ArrayList<String> get_tag(String key) {
		return this.m_tag.get_l(key.toUpperCase() );
	}
	public ArrayList<String> get_prp(String key) {
		return this.m_prp.get_l(key.toUpperCase());
	}
	public ArrayList<String> get_tags() {
		return this.m_tag.get_kl();
	}
	public ArrayList<String> get_prps() {
		return this.m_prp.get_kl();
	}


	public String toString() {
		String rtn =  "bufsize:" +
		              this.max_KB/1024 +
		              " KB\nholding text:\n" +
		              this.plain.toString() +
		              " \ntags:\n" +
		              m_tag.toString() +
		              " \nprps:\n" +
		              m_prp.toString();
		return rtn;
	}

	@Override
	public void handleText(char[] data, int pos) {	//ふつーの文章っぽいのを見つけたらここにくる。
		//System.out.println(new String(data));
		//System.err.println("goo");
		//でかい。
		if(data.length > this.max_KB && this.max_KB != 0) {
			this.plain.setLength(0);
			this.plain.append("err\n" + "rtn text is too bigsize:" + this.max_KB + " KB\n");
			return;
		}
		this.plain.append(data);
		this.plain.append("\n");
	}

	//jvmが閉じタグを見つけるたびにここに飛んでくる。
	public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
		storefunc(t,a);
	}
	//こっちは開きタグ。細かい解析するなら分けたいだろうけど、単純解析なので同じ。
	public void handleStartTag(Tag t, MutableAttributeSet a, int pos) {
		storefunc(t,a);
	}

	//本体。どうやって料理するのか。
	private void storefunc(Tag t, MutableAttributeSet a) {
		Enumeration<?> e = a.getAttributeNames();	//namesはenumを返す。enumは古い。
		ArrayList<?> l = Collections.list(e);	//collectはメソッドのみのクラス。詰め直し。
		//リスト操作嫌い。for用のインスタンス作成とか頭湧いてる。
		//aはタグに付随するprop情報が入ってる。t=Aタグ Attr= src & http:...みたいなlist系？

		// HTMLには記述必須のタグがあるんだけど、無い場合は自動補完する。IMPLIをつける。
		// 保管したよってときは、元ネタに書いてないんだから、スキップが妥当。
		if ( a.getAttribute(IMPLIED) == Boolean.TRUE ) {
//			System.err.println(t.toString() + "detect invalid line" + a.toString() );
			return;
		}

		//tagをとりあえず文字に。分かりやすいし。
		String tstr = t.toString().toUpperCase();
		m_tag.put(tstr, a.toString() );
		
		//prpをチェックと保存 attrに属性とデータの両方が入ってる
		for(int i=0; i<l.size(); i++) {
			// attrはAttr型とString型の二つを返却する可能性があるのでObjで受ける。
			// 型によって要素取り出しメソッドがポリモフするので。
			Object p_key = l.get(i); //.toUpperCase();	// SRC etc
			m_prp.put(p_key.toString().toUpperCase(), (String)a.getAttribute(p_key) );

//			System.err.println(p_key.toString().toUpperCase() + " puro "+ (String)a.getAttribute(p_key) );
		}

//		//	propの仕様チェック。変なpropは弾く。 >> チェックせんでもそのまま吐き出せばいいか。
//		HTML.Attribute Verify_prp(String s) {
//			Class cls = javax.swing.text.html.HTML.Attribute.class;
//			Field[] f = cls.getDeclaredFields();	//javaがサポートしてるプロパティ一覧。
//			HTML.Attribute atb=null;
//			//StringBuilder alw = new StringBuilder();
//
//	//		System.err.println(s + " @@@@@@@@@@@@@@@@");
//
//			for (int i = 0; i < f.length; i++) {
//
////				System.err.println("@@" + f[i].getName());
//
//				//alw.append(f[i].getName() + " ");
//				//System.out.println(alw.toString() );
//				if( f[i].getName().equals(s) ) {
//					try {
//						//atb=null;	...キャストできるみたい。
//						atb = (HTML.Attribute)f[i].get(cls);	//fieldからnameでobjをゲット。キャスト。
//					} catch (Exception e) {
//						if ( atb == null) {
//							System.err.println(s + " -1 warn(stderr):java_NoSupportProp(html5?)");
//			// ここで問題prop要素を返したいとこだけど、HTML_Attはインスタンスが作れないのでnull。向こうでなんとかして。
//						} else {
//							e.printStackTrace();
//						}
//					}
//					break;	// 判別したら抜けていいでしょ。無駄だし。
//				}
//			}
////			System.err.println("@@--@@");
//
//
//			//if ( atb == null ) {
//			//System.err.println(s + "java.html未サポートプロパティ");
//			//	System.err.println(alw);
//			//}
//			return atb;
//		}
//
//
//		// 同じ。変なタグ名を弾く。
//		HTML.Tag Verify_Tg(String s) {	//tagObj作成。stringからjavaのstaticObjを探す。
//
//			Class cls = javax.swing.text.html.HTML.Tag.class;
//			Field[] f = cls.getDeclaredFields();
//			HTML.Tag tg=null;
//
//			for (int i = 0; i < f.length; i++) {
//		//		System.err.println("@@" + f[i].getName());
//
//				if( f[i].getName().equals(s) ) {
//					try {
//						tg = (HTML.Tag)f[i].get(cls);
//					} catch (Exception e) {
//						e.printStackTrace();
//					}
//					break;
//				}
//			}
//		//	System.err.println("@@--@@");
//
//
//			//if ( tg == null ) {
//			//	System.err.println(s + "未サポートタグ指定。");
//			//	System.err.println(alw);
//			//}
//			return tg;
	}



//https://qiita.com/episteme/items/8aa416ce3fd63829f3bb
//*sample
//class Mycb_sample {		//	javaはmain系ファイル名=クラス名の縛りがあるんで、お試しはsampleを削除。
	public static void main(String[] args) throws Exception {
		System.out.println( "---Mycb.java sample, see src---" );

		String s = "<html><body>" +
		           "  <a href=\"http://qiita.com/episteme\">επιστημη</a>" +
		           "  <IMG src=\"https://pbs.twimg.com/profile_images/54608127/epi_normal.jpg\"/>" +
		           "	<source src=\"https://weblio.hs.llnwd.net/e7/img/dict/kenej/audio/S-A03C176_E-A03EB48.mp3\" type=\"audio/mpeg\">"+
		           "</body></html>";
		StringReader rdstr = new StringReader(s);

		//翻訳マシンを買ってきて(実際はdtd解析機がdelegaterの中に入ってる。)
		ParserDelegator pd = new ParserDelegator();
		//（英語翻訳（デフォ）で）breadという単語がでたらstdoutするルール(callback)
		//みたいなルール一覧を作る
		Mycb cb = new Mycb(100);	//バッファ100KB. 自動拡張なんで(0),()でもいいっすよ。

		System.out.println("---ck_before_parse\n" + cb.toString());
		System.out.println("--ck_inputstrings\n" + s);
		//ルール一覧cbをセットして、文字列を流し込むrdstrとcbに従って動作する。
		pd.parse(rdstr, cb, true);
		rdstr.close();

//		cb.toString();	//保持データ吐き出し
//		cb.getplain();	//textのみ
//		ArrayList<String> buf = cb.get_tag("A");	//tagが持っているデータ。nullで全タグ、"a"とか指定で指定タグ
//		cb.get_prp("src");	//attributeが持っているデータ。nullで全タグ、"src"とか指定で指定タグ
//		LinkedHashMap<String, ArrayList<String> >  buf = cb.get_tag();
//		LinkedHashMap<String, ArrayList<String> > buf = cb.get_prp();
//		Set<K> st = buf.keySet();
//		String[] mkeys = st.toArray(new String[0]);		//if keyType is 'string'

//
//		List<String> tagmeta = new ArrayList<String>();
//		tagmeta[1] = "unkokko"; 	...
//
//		List<Map<String, String>> prpmeta = new ArrayList();	//多次元配列が持てない。java
//		prpmeta[1].put("src", "http:// ...");
//		prpmeta[1].get("src");

		//System.out.println("head__ " + hd_s.toString() );
		System.out.println("\n--parsed.Alldata--unko\n" + cb.toString());
		System.out.println("---all_tags\n" + cb.get_tags() );
		System.out.println("---all_prps\n" + cb.get_prps() );
	}
}
//*/
