/* MapM.java	Map, List wrapper
 * Copyright (C) 2018,2019 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

//同じキーで値を突っ込むと、上書きぜず、どんどんList追加保存されてく変なマップ。マップまるち。
// ... sample run, see fileEnd.
// javac MapM.java
// java MapM_sample
//参考 https://qiita.com/yoshi389111/items/7ea0f9b9483b0138ecdf
//apacheに10年前から作成されてたみたい。車輪。

public class MapM<K,V> {
	//	--quick Howto
	//	MapM<String, Integer> mp = new MapM<String, Integer>();
	//	mp.put("unko", 123);	mp.put("unko", 0);	mp.put("src", 4444);	...
	//	ArrayList<?>  buf = mp.get_l("unko");	getの戻りはList型。
	//	ArrayList<?>  buf = mp.get_kl();	全キー返す。List型。
	//	LinkedHashMap<?, ?> buff = mp.get_m();	全データを返す。
	//	System.out.println(buff.toString() );
	//	mp.remove("unko");
	//	mp.clear();

	private LinkedHashMap<K, ArrayList<V> > m;

	public  MapM() {
		//スレッドセーフにするシンクロラップしようとした。>>総称型には使えない。
		//コンパイル時に型サイズを最低限決める必要があるから。extend指定があれば可能。
		//<K extends Array,...>	とか?
		// 追加。初期サイズは0固定。コストがかかるけど、要素数取得を考えると0がいい。
		m = new LinkedHashMap<K, ArrayList<V> >(0);
	}

	//put, Mapに値を突っ込む
	public V put(K key, V value) {
		try {

			if( m.containsKey(key) ) {	//登録済キーです
				m.get(key).add(value);	// list.add(value);

			} else {	//未登録
				ArrayList<V> l = new ArrayList<V>(0);
				l.add(value);
				m.put(key, l);
				//毎回newとかしてるけど、mapは参照型だから。lが消えても
				//大本へのポインタがmに保存されているから問題ない。多分。
			}
			return value;
		} catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	//値を詰め込んだlistを返す。keyがappleだったら 1,34,0,22 みたいなリストを返す。FiLO.
	public ArrayList<V> get_l(K key) {
		return m.get(key);
		//return alst.toArray();
	}

	//全Keyをlistで返す。どんなキーを突っ込んだっけ？っていう忘れっぽい人用。
	public ArrayList<K> get_kl() {
		//LinkedHashMap<String, ArrayList<String> > buf = m.get_prp();
		Set<K> st = m.keySet();
		//<T> T[] toArray(T[] a)
		ArrayList<K> mkeys = new ArrayList<K>(st);		//listはcollectionを引数に取れる。
		return mkeys;
	}

	//生Mapを渡す LinkedHashMap
	public LinkedHashMap<K, ArrayList<V> > get_m() {
		return m;
	}

	//キーとそのarrayを削除する
	public void remove(K key) {
		if ( m.remove(key) == null) {
			System.err.println("remove_key failed. " + key);
			//入力key型が違うとエラーを吐くので握りつぶす。
		}
	}

	//初期化する
	public void clear() {
		m.clear();
	}

	//中身を表示する
	public String toString() {
		return m.toString();
	}
//end


//*	MapM.java sample
//~$ java MapM
	public static void main(String[] args) {
		System.out.println( "---MapM.java sample, see src---" );

		//キーと値の型を決める。Stringが多いだろうけど、別にMyObjでもいい。
		//キーがバラバラの型とか、値がバラバラの型とかは未対応。
		MapM<String, Integer> mp = new MapM<String, Integer>();

		//ぶち込む。unkoの重複は消えないでlistで追記保存される.
		mp.put("unko", 123);	//>>	unko:123
		mp.put("src", 3);		//>>	unko:123	src:3
		mp.put("unko", 0);		//>>	unko:123,0	src:3
		mp.put("shoyu", 44);	//>>	unko:123,0	src:3	shoyu:44

		//とりあえずどんな感じか確認
		String allunko = mp.toString();
		System.out.println( "special--unko--" );
		System.out.println(allunko);

		//キーで取り出す。get_lで戻りはList型。<?>ってのは戻り型を自動判別ってこと。ここではInt。
		ArrayList<?> buf = mp.get_l("unko");	//>>	unko:123,0。
		System.out.println( buf.toString() );

		//特定キーの保持情報を削除。取り除く。delete.
		mp.remove("src");		//>>	unko:123,0	"削除"	shoyu:44
		System.out.println( mp.get_m().toString() );
		System.out.println( mp.get_kl().toString() );

		//生Mapを取り出す。LinkedHash形式。書き方はどっちでも。省略が楽か。全書きは分かりやすい。
		//LinkedHashMap<String, ArrayList<Integer>> buff = mp.get_m();
		LinkedHashMap<?, ?> buff = mp.get_m();
		System.out.println( buff.toString() );	//全体。 unko:123,0	src:3	shoyu:44

		//初期化。多分ガベージで勝手に整理される。いらなきゃclear()後で放っとけばいつか消える。
		mp.clear();		//	unko:123,0	shoyu:44	>> "全削除"
		System.out.println( mp.get_m().toString() );	//メモリクリア
	}
}
//*/
