#!/bin/busybox sh
#
# Copyright (C) 2013 fakesh. http://sourceforge.jp/users/fakesh/
# MIT/X Consortium License
#

if [ -d "$1" ] ; then
  # $1 is root dir
  path2mount=${1%/}/bin/mount
  path2umount=${1%/}/bin/umount
  path2dosfsck=${1%/}/bin/dosfsck
  wrapd=${path2dosfsck%/*}/.wrapped
  if [ -z "$2" ] ; then # WRAP
    # wrap mount
    if [ -L $path2mount -a $(readlink $path2mount) = busybox ] ; then
      rm -f $path2mount
      cat > $path2mount <<- 'EoMOUNTWRAP'
	#!/bin/busybox sh
	# a part of fakesh-kobo
	# change only if '-t vfat' and dev is not vfat
	ext4opt='-o noatime,nodiratime'
	fstype=''; opt=''; dev=''; mtpt=''
	lastarg=''
	for i do
	  case "$lastarg" in
	  -t) fstype="$i" ;;
	  -o) opt=",$i," ;;
	  -O) ;;
	  *) case "$i" in
	    -r) ext4opt="-r $ext4opt" ;;
	    -*) ;;
	    *)
	      [ -b "$i" ] && dev="$i"
	      [ -d "$i" ] && mtpt="$i"
	    ;;
	    esac
	  ;;
	  esac
	  lastarg="$i"
	done
	[ "$fstype" = vfat ] || exec busybox mount "$@"
	rgex="^${dev}:.* (UUID=\"....-....\"|LABEL=\"rootfs\")"
	blkid | grep -Eq "$rgex" >/dev/null 2>&1 && exec busybox mount "$@"
	case "$opt" in *,remount,*) ext4opt="$ext4opt,remount" ;; esac
	case "$opt" in *,ro,*) ext4opt="$ext4opt,ro" ;; esac
	case "$opt" in *,rw,*) ext4opt="$ext4opt,rw" ;; esac
	exec busybox mount -t ext4 $ext4opt "$dev" "$mtpt"
	EoMOUNTWRAP
      chmod 755 $path2mount
    fi
    # wrap umount
    if [ -L $path2umount -a $(readlink $path2umount) = busybox ] ; then
      rm -f $path2umount
      cat > $path2umount <<- 'EoUMOUNTWRAP'
	#!/bin/busybox sh
	# a part of fakesh-kobo
	for i do
	  case "${i%/}" in
	  /mnt/root) wrapping-mount-dosfsck.sh $i ; sync ;;
	  /mnt/user) chmod 1777 $i ; sync ;;
	  /mnt/onboard)
	    find $i -xdev -type d -not -perm 777 -not -path $i \
	      -not -path ${i%/}/lost+found -print0 |
	      xargs -r -0 chmod 777
	    sync; sync
	  ;;
	  esac
	done >/dev/null 2>&1
	exec busybox umount "$@"
	EoUMOUNTWRAP
      chmod 755 $path2umount
    fi
    # wrap dosfsck
    if [ -x $path2dosfsck -a ! -L $path2dosfsck ] ; then
      [ -d $wrapd ] || mkdir -p -m 755 $wrapd
      if [ ! -x $wrapd/dosfsck ] ; then
        mv $path2dosfsck $wrapd/dosfsck
        cat > $path2dosfsck <<- 'EoDOSFSCK'
	#!/bin/busybox sh
	# a part of fakesh-kobo
	dev=''
	lastarg=''
	for i do
	  case "$lastarg" in
	  -d | -u ) ;;
	  *) case "$i" in
	    -*) ;;
	    *) dev="$i" ;;
	    esac
	  ;;
	  esac
	  lastarg="$i"
	done
	rgex="^${dev}:.* (UUID=\"....-....\"|LABEL=\"rootfs\")"
	blkid | grep -Eq "$rgex" >/dev/null 2>&1 || exit 0
	exec ${0%/*}/.wrapped/dosfsck "$@"
	EoDOSFSCK
        chmod 755 $path2dosfsck
        if [ -f ${1%/}/fs.md5sum ] ; then
          md5x="$(md5sum $path2dosfsck | sed 's@ .*@  bin/dosfsck@')"
          sed -i "s@^[^ ]*  bin/dosfsck\$@$md5x@" ${1%/}/fs.md5sum
        fi
      fi
    fi
    exit 0
  else # RESTORE if [ -n "$2" ]
    # restore mount
    if [ ! -L $path2mount -a -f $path2mount ] &&
         grep -q '# a part of fakesh-kobo' $path2mount ; then
      rm -f $path2mount
      ln -s busybox $path2mount
    fi
    # restore umount
    if [ ! -L $path2umount -a -f $path2umount ] &&
         grep -q '# a part of fakesh-kobo' $path2umount ; then
      rm -f $path2umount
      ln -s busybox $path2umount
    fi
    # restore dosfsck
    if [ -f $wrapd/dosfsck -a -f $path2dosfsck -a ! -L $path2dosfsck ] &&
         grep -q '# a part of fakesh-kobo' $path2dosfsck ; then
      rm -f $path2dosfsck
      mv $wrapd/dosfsck $path2dosfsck
      rmdir --ignore-fail-on-non-empty $wrapd
      if [ -f ${1%/}/fs.md5sum ] ; then
        md5x="$(md5sum $path2dosfsck | sed 's@ .*@  bin/dosfsck@')"
        sed -i "s@^[^ ]*  bin/dosfsck\$@$md5x@" ${1%/}/fs.md5sum
      fi
    fi
    exit 0
  fi >/dev/null 2>&1
fi

#### test code (if ! [ -d "$1" ])

# preparation
tstdir=$(mktemp -d /tmp/wrapTest_XXXXXX)
echo "TestDir: $tstdir"
me=$(readlink -f "$0")
cd $tstdir
mkdir bin
ln -s busybox bin/mount
ln -s busybox bin/umount
cp "$me" bin/dosfsck
echo 'hoge-hoge  bin/dosfsck' > fs.md5sum

# test

printf '\n==== before invocations ====\n'
md5sum bin/dosfsck
ls -l $(find * ! -type d )

"$me" $tstdir
printf '\n==== after 1st invocation ====\n'
ls -l $(find * ! -type d )

"$me" $tstdir
printf '\n==== after 2nd invocation ====\n'
ls -l $(find * ! -type d )
cat fs.md5sum

printf  \\n
for x in bin/mount bin/umount bin/dosfsck ; do
  if busybox sh -n $x ; then
    echo "### NO_SYNTAX_ERROR: $x"
  else
    busybox sh -nv $x
    echo "*** SYNTAX_ERROR: $x"
    exit 1
  fi
done

"$me" $tstdir restore
printf '\n==== after restore ====\n'
ls -l $(find * ! -type d )
cat fs.md5sum

"$me" $tstdir
printf '\n==== after 3rd invocation ====\n'
ls -l $(find * ! -type d )
cat fs.md5sum

printf  \\n
for x in bin/mount bin/umount bin/dosfsck ; do
  if busybox sh -n $x ; then
    echo "### NO_SYNTAX_ERROR: $x"
  else
    busybox sh -nv $x
    echo "*** SYNTAX_ERROR: $x"
    exit 1
  fi
done
echo "TestDir: $tstdir"

exit 0
