/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileSystemView;
import org.omegat.plugin.foldermenu.ShellLinkMenu;
import org.omegat.plugin.foldermenu.ShellLinkMenuItem;

public class MenuHelper {
    private static final FileSystemView fs = FileSystemView.getFileSystemView();
    private static final FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.getName().startsWith(".") && !file.isHidden();
        }
    };
    private static final ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuHelper.$(e).open();
        }
    };
    private static final MenuKeyListener mkl = new MenuKeyListener(){

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            JMenu menu;
            MenuSelectionManager manager;
            MenuElement[] selectedPath;
            MenuElement selection;
            if (e.getKeyCode() == 10 && (selection = (selectedPath = (manager = e.getMenuSelectionManager()).getSelectedPath())[selectedPath.length - 1]) instanceof JMenu && (menu = (JMenu)selection).isEnabled()) {
                manager.clearSelectedPath();
                MenuHelper.$(menu).open();
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }
    };
    private static final MouseListener mol = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
            MenuHelper.$(e).open();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    };
    private static final MenuListener mel = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent e) {
            MenuHelper.$(e).createChildren();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    };
    private static final MenuListener melRoot = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            for (Component c : menu.getMenuComponents()) {
                JMenu m;
                if (!(c instanceof JMenu) || !(m = (JMenu)c).isEnabled()) continue;
                m.removeAll();
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    };
    private static final Comparator<File> comp = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            if (f1.isFile() == f2.isFile()) {
                return f1.getName().compareToIgnoreCase(f2.getName());
            }
            return f1.isFile() ? 1 : -1;
        }
    };

    private MenuHelper() {
    }

    public static Icon getIcon(File file) {
        return fs.getSystemIcon(file);
    }

    public static File[] getFilteredListFiles(File folder) {
        return folder.listFiles(ff);
    }

    public static ActionListener getActionListener() {
        return al;
    }

    public static MenuKeyListener getMenuKeyListener() {
        return mkl;
    }

    public static MouseListener getMouseListener() {
        return mol;
    }

    public static MenuListener getMenuListener() {
        return mel;
    }

    public static MenuListener getRootMenuListener() {
        return melRoot;
    }

    public static Comparator<File> getComparator() {
        return comp;
    }

    private static ShellLinkMenuItem $(JMenuItem mi) {
        return new ShellLinkMenuItem(mi);
    }

    private static ShellLinkMenu $(JMenu m) {
        return new ShellLinkMenu(m);
    }

    private static ShellLinkMenuItem $(ActionEvent e) {
        return new ShellLinkMenuItem((JMenuItem)e.getSource());
    }

    private static ShellLinkMenu $(MouseEvent e) {
        return new ShellLinkMenu((JMenu)e.getSource());
    }

    private static ShellLinkMenu $(MenuEvent e) {
        return new ShellLinkMenu((JMenu)e.getSource());
    }
}

