/*static char sccsid[]="%Z% %M% %I% %E% %U%";*/
/************************************************************************/
/*																		*/
/*		akxlib.h														*/
/*																		*/
/*			Coded by Akito Kobayashi	2010.5.28						*/
/*																		*/
/************************************************************************/
#ifndef _AKXLIB_H
#define _AKXLIB_H

typedef struct SSP_S {
	int  sp;
	char *wd;
	uchar attr[4];
} SSP_S;

typedef struct _SSPL_S {
	int  sp;
	char *wd;
	uchar attr[4];
	short wdmax;
	uchar code;
	uchar resv;
} SSPL_S;

extern int akxtgwsp();
extern int akxtgwns();
extern int akxtgwse();
extern int akxafxdmp();
extern int akxaxdump();

/*****************************************
	nbVǗ
*****************************************/
#define AKX_HASX_OPT_NO_USE_ALL	1
#define AKX_HASX_OPT_NO_NEXT	2
#define AKX_HASX_OPT_CASE_KEY	4
#define AKX_HASX_ID_NO_USE_ALL	'U'
#define AKX_HASX_ID_NO_NEXT		'N'
#define AKX_HASX_MULTIPLIER1	31
#define AKX_HASX_MULTIPLIER2	37

typedef struct {
	char	ha_id[2];
	short	ha_keylen;
	int 	ha_maxreg;
	int 	ha_prereg;
	char	*ha_reg;
	int 	*ha_next;
	char	*ha_key;
	int 	ha_aux;
	int 	ha_hix;
} HASHB;

HASHB *akxs_hasx_new2();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/
HASHB *akxs_hasx_new();	/* (short xha_keylen,long xha_maxreg,long xha_prereg);	*/
int akxs_hasx_free();	/* (HASHB *tph);	*/
int akxs_hasx_pre_reg();	/* (long xha_maxreg);	*/

HASHB *akxs_seqs_new();	/* (sKeyLen,lMaxReg)	*/

typedef struct {
	long hc_flag;
	long hc_hkey;
	long hc_next;
	int  *hc_datp;
} tdtHaslCell;

typedef struct {
	long hc_flag;
	long hc_hkey;
	long hc_next;
	int  *hc_datp;
	ulong hc_akey[4];
} tdtHaslCell4;

HASHB *akxs_hasl_new();	/* (short xha_keylen,long xha_maxreg,long xha_prereg);	*/
int  akxs_hasl_free();	/* (HASHB *tph);	*/

HASHB *akxs_hasl2_new();	/* (short xha_keylen,long xha_maxreg,long xha_prereg);	*/
int  akxs_hasl2_free();	/* (HASHB *tph);	*/

HASHB *akxs_hasl_new2();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/
HASHB *akxs_hasl2_new2();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/

/*****************************************
	gnbVǗ
*****************************************/
typedef struct XHASHB {
	char	xha_id[2];
	short	xha_keylen;
	int 	xha_maxreg;
	int 	xha_prereg;
	int 	xha_xhix;
	HASHB	*xha_hashb;
	struct XHASHB *xha_xhnext;
	int		xha_datlen;
	char	*xha_datreg;
} XHASHB;

extern XHASHB *akxs_xhash_new();	/* (xha_keylen,xha_maxreg,xha_prereg) */
extern XHASHB *akxs_xhash_init();	/* (xha_keylen,xha_maxreg,xha_prereg) */
extern int     akxs_xhash();		/* (tp_xhashb,cCmd,cpKey) */
extern XHASHB *akxs_xhash_new2();	/* (xha_keylen,xha_maxreg,xha_prereg,xha_datlen) */
extern int     akxs_xhash2();		/* (tp_xhashb,cCmd,cpKey,cpDat) */

extern XHASHB *akxs_xseqs_new();	/* (sKeyLen,lMaxReg)	*/
extern XHASHB *akxs_xseqs_new2();	/* (sKeyLen,lMaxReg,lDatLen)	*/

/*****************************************
	GAgA
*****************************************/
typedef struct {
	char   mc_id[2];
	ushort mc_extlen;
	ushort mc_maxcnt;
	ushort mc_extcnt;
	int    mc_alclen;
	char  *mc_bufp;
	int    mc_ipos;
} MCAT;

/*****************************************
	Oobt@Ǘ
*****************************************/
typedef struct tdtRbChain {
	struct tdtRbChain *rbc_next;
	char *rbc_buf;
} tdtRbChain;

typedef struct {
	int rb_bfsz;
	int rb_max;
	int rb_num;
	int rb_used;
	tdtRbChain *rb_raddr;
	tdtRbChain *rb_waddr;
	tdtRbChain *rb_wpriv;
	int rb_pos;
	tdtRbChain *rb_cur;
} tdtRbCtl;

extern tdtRbCtl *akxs_rb_new();
extern char *akxs_rb_get();
extern char *akxs_rb_get_n();
extern char *akxs_rb_set_n();
extern char *akxs_rb_read(/*tdtRbCtl *,int*/);

extern tdtRbChain *akxs_xhasl_new();	/* (short sKeyLen,long lMaxReg,long lPreReg,int iOpt);	*/
extern tdtRbChain *akxs_xhasl2_new();	/* (short sKeyLen,long lMaxReg,long lPreReg,int iOpt);	*/

/*****************************************
	L[Ǘ
*****************************************/
#define QUE_PUT_TOP 	10	/* TOPɒǉ */
#define QUE_PUT_BOT 	11	/* BOTTOMɒǉ */
#define QUE_PUT_CUR		12	/* CURRENTɒǉ */
#define QUE_GET_TOP 	20	/* TOPo */
#define QUE_GET_BOT 	21	/* BOTTOMo */
#define QUE_GET_CUR 	22	/* CURRENTo */
#define QUE_PEEK_TOP 	30	/* TOP𒲂ׂ */
#define QUE_PEEK_BOT 	31	/* BOTTOM𒲂ׂ */
#define QUE_PEEK_CUR 	32	/* CURRENT𒲂ׂ */
#define QUE_PEEK_NEXT	33	/* CURRENT𒲂ׁACURRENTɈړ */
#define QUE_PEEK_PREV	34	/* CURRENT𒲂ׁACURRENTOɈړ */
#define QUE_MOVE_PEEK_NEXT	35	/* CURRENTɈړACURRENT𒲂ׂ */
#define QUE_MOVE_PEEK_PREV	36	/* CURRENTOɈړACURRENT𒲂ׂ */
#define QUE_MOVE_TOP	40	/* TOPCURRENTړ */
#define QUE_MOVE_BOT	41	/* BOTTOMCURRENTړ */
#define QUE_MOVE_NEXT	43	/* CURRENTړ */
#define QUE_MOVE_PREV	44	/* OCURRENTړ */
#define QUE_MOVE_TOPP	45	/* TOP̑OCURRENTړ */
#define QUE_MOVE_BOTN	46	/* BOTTOM̎CURRENTړ */
#define QUE_GET 	QUE_GET_TOP
#define QUE_PUT 	QUE_PUT_BOT
#define QUE_PEEK	QUE_PEEK_TOP
#define QUE_MOVE	QUE_MOVE_NEXT

#define QUE_DFLT	99	/*  */
#define QUE_TOP 	100	/* TOP𑀍삷 */
#define QUE_BOT 	101	/* BOTTOM𑀍삷 */
#define QUE_CUR		102	/* CURRENT𑀍삷 */
#define QUE_AFT_NEXT	103	/* CURRENT𑀍삵ACURRENTɈړ */
#define QUE_AFT_PREV	104	/* CURRENT𑀍삵ACURRENTOɈړ */
#define QUE_NEXT	105	/* CURRENTɈړACURRENT */
#define QUE_PREV	106	/* CURRENTOɈړACURRENT */
#define QUE_TOP_PREV	107	/* TOP̑OCURRENTړ */
#define QUE_BOT_NEXT	108	/* BOTTOM̎CURRENTړ */
#if 1
typedef struct tdtQueChain {
	struct tdtQueChain *qc_next;
	struct tdtQueChain *qc_prev;
	char *qc_buf;
} tdtQueChain;

typedef struct {
	int qct_bfsz;
	int qct_max;
	int qct_num;
	int qct_used;
	tdtQueChain *qct_top;
	tdtQueChain *qct_bot;
	tdtQueChain *qct_cur;
	tdtQueChain *qct_fre;
} tdtQueCtl;
extern tdtQueCtl *akxs_que_init();
extern tdtQueCtl *akxs_que_new();
#else
typedef struct tdtQueChain {
	struct tdtQueChain *qc_next;
	struct tdtQueChain *qc_prev;
	char *qc_buf;
} tdtQueChain;

typedef struct {
	int qct_bfsz;
	int qct_max;
	int qct_num;
	int qct_used;	/* add 2000.6.10 Koba */
	tdtQueChain *qct_top;
	tdtQueChain *qct_bot;
	tdtQueChain *qct_cur;
	tdtQueChain *qct_fre;
} tdtQueCtl;
extern tdtQueCtl *akxs_que_init();
extern tdtQueCtl *akxs_que_new();
#endif
extern int akxs_que_get();
extern int akxs_que_put();
extern int akxs_que_free();

/*****************************************
	LbVǗ
*****************************************/
#define AKX_CACHE_EXTENT	10
#define AKX_CACHE_FIXEDKEYL	0x01
#define AKX_CACHE_MEMCMP	0x02
#define AKX_CACHE_DATASAVE	0x04
#define AKX_CACHE_IGNCHKERR	0x08
#define AKX_CACHE_NOAUTOEXT	0x10
#define CACHE_EXTENT		AKX_CACHE_EXTENT
#if 1
typedef struct tdtCacheCtl {
	char *ca_key;
	char *ca_cmp1;
	char *ca_cmp2;
	char *ca_data;
	int   ca_cmpnext;
	int   ca_chktime;	/* Check time */
	struct timeval ca_tval;
	int   ca_locktime;	/* Lock to time */
} tdtCacheCtl;
#else
typedef struct tdtCacheCtl {
	char *ca_key;
	char *ca_cmp1;
	char *ca_cmp2;
	char *ca_data;
	int   ca_cmpnext;
	int   ca_chktime;	/* Check time */
	struct timeval ca_tval;
	int   ca_locktime;	/* Lock to time */
} tdtCacheCtl;
#endif
#if 1
typedef struct tdtListChain {
	struct tdtListChain *lc_next;
	struct tdtListChain *lc_prev;
	tdtCacheCtl *lc_cactl;
	int lc_count;
} tdtListChain;
#else
typedef struct tdtListChain {
	struct tdtListChain *lc_next;
	struct tdtListChain *lc_prev;
	tdtCacheCtl *lc_cactl;
	int lc_count;
} tdtListChain;
#endif
#if 1
typedef struct {
	ushort        ch_imax;
	ushort        ch_smax;
	uchar         ch_opt;
	uchar         ch_kind;
	short         ch_keylen;
	int           ch_cmplen;
	int           ch_cshlen;
	short         ch_interval;
	ushort        ch_entry;
	tdtCacheCtl  *ch_pentry;
	tdtCacheCtl  *ch_prls;
#ifdef CACHE_QUE
	tdtQueCtl    *ch_pque;
#else
#ifdef CACHE_XHAS
	XHASHB        *ch_pxhas;
    int           *ch_pchktime;
#else
#ifdef CACHE_LIST
	tdtListChain *ch_pltop;
	tdtListChain *ch_plbot;
	tdtListChain *ch_plprev;
#else
	tdtCacheCtl  **ch_ppcache;
	struct timeval ch_tctval;
#endif
#endif
#endif
} tdtCacheCtlHead;
#else
typedef struct {
	ushort        ch_imax;
	ushort        ch_smax;
	unsigned char ch_opt;
	unsigned char ch_kind;
	short         ch_keylen;
	int           ch_cmplen;
	int           ch_cshlen;
	short         ch_interval;
	ushort        ch_entry;
	tdtCacheCtl     *ch_pentry;
	tdtCacheCtl     *ch_prls;
#ifdef CACHE_QUE
	tdtQueCtl       *ch_pque;
#else
#ifdef CACHE_XHAS
	XHASHB        *ch_pxhas;
    int           *ch_pchktime;
#else
#ifdef CACHE_LIST
	tdtListChain    *ch_pltop;
	tdtListChain    *ch_plbot;
	tdtListChain    *ch_plprev;
#else
	tdtCacheCtl     **ch_ppcache;
	struct timeval ch_tctval;
#endif
#endif
#endif
} tdtCacheCtlHead;
#endif
#ifdef SUNOS
extern tdtCacheCtlHead *akxs_cache_new();	/*	(int);	*/
extern int akxs_cache_set();	/*	(tdtCacheCtlHead *,tdtCacheCtl *);	*/
extern int akxs_cache_chk();	/*	(tdtCacheCtlHead *,char *,tdtCacheCtl *);	*/
extern int akxs_cache_del();	/*	(tdtCacheCtlHead *,char *);	*/
extern int akxs_cache_free();	/*	(tdtCacheCtlHead *);	*/
#else
extern tdtCacheCtlHead *akxs_cache_new(int);
extern int akxs_cache_set(tdtCacheCtlHead *,tdtCacheCtl *);
extern int akxs_cache_chk(tdtCacheCtlHead *,char *,tdtCacheCtl *);
extern int akxs_cache_del(tdtCacheCtlHead *,char *);
extern int akxs_cache_free(tdtCacheCtlHead *);
#endif

extern tdtCacheCtlHead *akxs_cache_newList();	/*	(int);	*/
extern tdtCacheCtlHead *akxs_cache_newQue();	/*	(int);	*/
extern tdtCacheCtlHead *akxs_cache_newXHas();	/*	(int);	*/

/*****************************************
	^C}[Ǘ
*****************************************/
#define AKX_TIMER_UNUSED	0
#define AKX_TIMER_START		1
#define AKX_TIMER_STOP		2
#if 1
typedef struct tdtTimerCtl {
	uchar  tc_status;	/* 0/1/2=unused/start/stop */
	uchar  tc_resv2;
	uchar  tc_resv3;
	uchar  tc_resv4;
	int  (*tc_pfunc)();
	int    tc_tmrid;
	char  *tc_tmrname;
	int    tc_watime;
	char  *tc_parm;
	struct timeval tc_timeout;
	struct tdtTimerCtl *tc_tmrnext;
	int    tc_event;
} tdtTimerCtl;

typedef struct tdtTimerCtlHead {
	struct timeval th_tmbase;
	int            th_minwait;
	tdtTimerCtl   *th_ptimer;
	int            th_mwtext;
	struct timeval th_latest;
} tdtTimerCtlHead;
#else
typedef struct tdtTimerCtl {
	uchar  tc_status;	/* 0/1/2=unused/start/stop */
	uchar  tc_resv2;
	uchar  tc_resv3;
	uchar  tc_resv4;
	int    (*tc_pfunc)();
	int    tc_tmrid;
	char   *tc_tmrname;
	int    tc_watime;
	char   *tc_parm;
	struct timeval tc_timeout;
	struct tdtTimerCtl *tc_tmrnext;
	int    tc_event;
} tdtTimerCtl;

typedef struct tdtTimerCtlHead {
	struct timeval th_tmbase;
	int th_minwait;
	tdtTimerCtl *th_ptimer;
	int th_minwaitExt;
	struct timeval th_latest;
} tdtTimerCtlHead;
#endif
/************************
	OǗ
*************************/
#define D_LOG_FLG_CHECK		-1
#define D_LOG_FLG_NONE		0
#define D_LOG_FLG_STDOUT	0x01
#define D_LOG_FLG_FILE		0x02
#define D_LOG_FLG_STDERR	0x04
#if 1	/* V6 */
#define D_LOG_FLG_SYSLOG	0x08
#define D_LOG_FLG_NO_SRC	0x10
#define D_LOG_FLG_NO_PROC	0x20
#define D_LOG_FLG_NO_TIME	0x40
#define D_LOG_FLG_PRIORITY	0x80
#else	/* V5 */
#define D_LOG_FLG_NO_SRC    0x08
#define D_LOG_FLG_NO_PROC   0x10
#define D_LOG_FLG_NO_TIME   0x20
#endif
#define D_LOG_FLG_LOG_CLEAR	0x0100
#define D_LOG_FLG_OUT_INFO	0x0200
#define D_LOG_FLG_CHK_PRI	0x0400
#define D_LOG_FLG_NOT_LF	0x1000
#define D_LOG_FLG_PUT_CR	0x2000
#define D_LOG_FLG_CNV_LF	0x4000	/* o̓bZ[WLFϊΏۂƂ */
#define D_LOG_FLG_STACK		0x8000
#define D_LOG_LEVEL_CHECK	-1

#define D_LOG_ROT_ROT_FILE	0x01
#define D_LOG_ROT_NO_HEAD	0x02
#define D_LOG_ROT_SIZE_LINE	0x04
#define D_LOG_ROT_NO_LINCR	0x08

#define AKX_LOG_EMERG		250
#define AKX_LOG_ALERT		210
#define AKX_LOG_CRIT		180
#define AKX_LOG_ERR			150
#define AKX_LOG_WARNING		120
#define AKX_LOG_NOTICE		90
#define AKX_LOG_INFO		60
#define AKX_LOG_DEBUG		30

#define AKX_NEWLINE_NOT_LF	0x01
#define AKX_NEWLINE_PUT_CR	0x02
#define AKX_NEWLINE_CNV_LF	0x04	/* o̓bZ[WLFϊΏۂƂ */

#define AKX_LOG_MAX_BITS	32

typedef struct {
	int  lgi_level;
	int  lgi_line;
	int  lgi_pri;
	char *lgi_file;
	char *lgi_format;
	char *lgi_a1;
	char *lgi_a2;
	char *lgi_a3;
	char *lgi_a4;
	char *lgi_a5;
} tdtLogInfo;

typedef struct tdtRotateCtl {
	int   rot_size_max;
	int   rot_size;
	int   rot_file_max;
	int   rot_file_no;
	int   rot_option;
	int   rot_check_point;
	int   rot_count;
} tdtRotateCtl;

typedef struct tdtLogFileLine {
	short  lfl_ope;
	ushort lfl_no;
	int    lfl_line[2];
	char   lfl_file_name[1];
} tdtLogFileLine;

typedef struct tdtLogCtl {
	int   log_flg;
	int   log_level;
	int   log_grp_mask;
	char *log_file;
	tdtRbCtl *rb_file;
	tdtRbCtl *rb_srch;
	tdtRotateCtl log_rot;
	char *log_file_path;
	XHASHB *log_info;
	int   log_priority;
	MCAT  *mcat_file;
	MCAT  *mcat_out;
	uchar log_lvll[AKX_LOG_MAX_BITS];
} tdtLogCtl;

typedef struct tdtLogCtlHead {
	int log_max;
	char *cur_dir;
	char *log_dir;
	char *proc_name;
	tdtLogCtl *log_ctl;
	tdtRbCtl *rb_ct_w;
	char *log_ecnv;
	int log_max_resv;
} tdtLogCtlHead;

extern int   akx_get_log_time(/* buf,len,format */);
extern char *akx_log_time();
extern tdtLogCtlHead *akxa_log_new(/* iMax */);
extern tdtLogCtl *akxa_log_get_ctl(/* tlh,i */);
extern int   akxa_log_out_level_main(/* tlh,log_no,level,file,line,format,a1,a2,a3,a4,a5 */);
extern int   akxa_log_flg(/* tlh,i,f */);
extern int   akxa_log_set_proc_name(/* tlh,cpName */);
extern char *akxa_log_get_proc_name(/* tlh */);
extern char *akxa_log_set_file_name(/* tlh, i, cpFile */);
extern char *akxa_log_set_dir(/* tlh,cpDir */);
extern int   akxa_log_level(/* tlh, i,level */);
extern char *akxa_rotate(/* tdtRotateCtl *rot,char *fname */);
extern char *akxa_log_file_path(/* tlh,log_no,opt */);

/*****************************************
	Data Code Type
*****************************************/
#define CD_TYPE_SYSTEM	0
#define CD_TYPE_EUC		1
#define CD_TYPE_SJIS	2
#define CD_TYPE_JIS		3
#define CD_TYPE_EBCDIC	4
#define CD_TYPE_UTF8	5
#define CD_TYPE_UNICODE	6
#define CD_TYPE_EBCDIK	8

/*****************************************
	Data Code Replace
*****************************************/
typedef struct {
	uint rr_scmp;
	uint rr_ecmp;
	uint rr_srep;
	int  rr_intval;
} tdtRepRange;

typedef struct {
	int rs_ext;
	XHASHB *rs_xh;
	int rs_max;
	char **rs_pprep;
	int rs_range_ext;
	int rs_range_max;
	int rs_range_used;
	tdtRepRange *rs_range;
	XHASHB *rs_rs_xh2;
	int rs_max2;
	char **rs_pprep2;
} tdtRepStr;

extern tdtRepStr *akxc_rep_str_new(/* char *tfile, int iExt */);

/*****************************************
	Compile and Execute
*****************************************/
typedef struct {
	int ns_maxcolm;
	int ns_maxobj;
	int ns_maxda;
	int ns_maxstack;
	int ns_nobj;
	int *ns_obj;
	char **ns_da;
	int  *ns_dstk;
	int  *ns_stack;
} tdtStplSql;

extern tdtStplSql *akxs_stpl_sql_new(/* nparm,iParm */);

/*********************************
		f[^
*********************************/
#define AKX_ZOK_CHAR	1		/* E			*/
#define AKX_ZOK_BINA	2		/* EQi			*/
#define AKX_ZOK_LONG	2		/* EQi			*/
#define AKX_ZOK_FLOA	3		/* E		*/
#define AKX_ZOK_DECI	4		/* EPOi		*/
#define AKX_ZOK_BULK	5		/* EBULK^			*/
#define AKX_ZOK_POIN	6		/* E|C^^		*/
#define AKX_ZOK_VARI	7		/* EoAg^	*/
#define AKX_ZOK_KANS	8		/* EԐ			*/
#define AKX_ZOK_DATA	0x80	/* E			*/

#define AKX_DATA_MALLOC		0x80	/* malloc data		*/
#define AKX_DATA_LPOSDATA	0x40	/* data to lResv	*/

/*****************************************
	ėpf[^\
*****************************************/
typedef struct  {
	uchar   gd_id;		/* f[^hc */
	uchar   gd_attr;	/*        */
	uchar   gd_scale;	/* x       */
	uchar   gd_code;	/* R[h */
	int     gd_dlen;	/* f[^   */
	char   *gd_data;	/* f[^     */
	int     gd_resv;
} tdtGeneralData;

/*****************************************
	message
*****************************************/
typedef struct {
	int   mm_msgno;
	char *mm_msg[3];
} tdtMessages;

typedef struct {
	short cmh_try;
	short cmh_langmax;
	int   cmh_no_max;
	tdtMessages *cmh_messages;
	tdtMessages **cmh_index;
	tdtRbChain *cmh_xhp;
} tdtConvMsgHead;

tdtConvMsgHead *akxc_conv_msg_new(/* tdtMessages *mesg */);

/*******************************
	read_line
********************************/
#define AKX_RECORD_BUFSIZE	256

/*****************************************
	getargv
*****************************************/
#define AKX_ARGV_TERM_IGE			0x01	/* '#'ȍ~𖳎 */
#define AKX_ARGV_IGNR_EQU			0x02	/* Q[hڂA'='̂Ƃ͖ */
#define AKX_ARGV_DELM_COM			0x04	/* ','؂Ƃ */
#define AKX_ARGV_DELM_CLN1			0x08
#define AKX_ARGV_DELM_CLN			0x10
#define AKX_ARGV_QUAT_IPV6			0x20
#define AKX_ARGV_DELM_EQU			0x40
#define AKX_ARGV_COM_NOT_IGNR_EQU	0x80
#define AKX_GSFOPEN_CACHE_INVALID	0x0100
#define AKX_GSFOPEN_NO_CACHE		0x0200
#define AKX_GSSTPLX_CACHE_INVALID	0x0400
#define AKX_ARGV_NOT_CUT_QUAT		0x010000
#define AKX_ARGV_USE_ATTR2_SEP		0x020000
#define AKX_ARGV_FOR_CSV			0x040000
#define AKX_ARGV_USE_ICMP			0x100000
#define AKX_ARGV_USE_AKXICMP		0x200000
#define AKX_ARGV_NO_CASE_CMP		0x400000

/*****************************************
	Virtual Area Access
*****************************************/
typedef struct _VAA_S {
	int     opt;
	FILE   *fp;
	SSP_S  *ssp;
	char   *buf;
	size_t  fsize;
} VAA_S;

/*****************************************
	Like
*****************************************/
typedef struct {
	uchar stp;
	uchar len;
	uchar mpn;
	uchar und;
} tdtLikeMask;

typedef struct {
	short lmc_nptn;
	short lmc_slptn;
	ushort *lmc_pat;
	tdtLikeMask *lmc_mask;
} tdtLikeMaskCtl;

typedef struct {
	short lk_max_pat;
	uchar lk_escape;
	char  lk_pad;
	int   lk_option;
	ushort *lk_usap;
	int   lk_alen;
	int   lk_la;
	tdtLikeMaskCtl *lk_maskctl;
	short lk_nlike;
	short lk_next_like;
	int   *lk_pos;
} tdtLike;

extern tdtLike *akxs_xlike_new(/* int max_pat,option */);

/*****************************************
	Free & Used Chain List
*****************************************/
typedef struct {
	int uc_entry_size;
	int uc_used_top;
	int uc_used_bot;
	int *uc_uchain;
} tdtUChain;

/*****************************************
	GetSectionStruct
*****************************************/
typedef struct keyInfo {
	int   argc;
	char **argv;
	int  *arglen;
	int   resv;
} tdtKeyInfo;

typedef struct {
	int          maxkey;
	int          nkey;
	tdtKeyInfo **pkeyinfo;
} tdtKeyInfos;

/*****************************************
	MPA
*****************************************/
#if 1
/*
		NMPA1 = NMPA + 1
		NMPA2 = NMPA1 * 2
		NMPA_INT = (NMPA1+12)/4
*/
#define		NMPA		51
#define		NMPA1		52
#define		NMPA2		104
#define		NMPA_INT	16
#else
/*
		NMPA1 = NMPA + 1
		NMPA2 = NMPA1 * 2
		MMPA  = NMPA1 * log10(RADIX) / 4
		NMPA_INT = (NMPA1+5+3)/4
*/
#define		NMPA		42
#define		NMPA1		43
#define		NMPA2		86
#define		NMPA_INT	12
#endif
#define		MMPA		11
#define		RADIXBITS	15
#define		RADIX		10
#define		RADIX_2		5		/* = RADIX / 2 */
#define		RADIX2		100		/* = RADIX ^ 2 */
#define		MAXEXP		32700
#define		MINEXP		-32701
#define		MAX_LONG	0x7FFFFFFFL
#define		MIN_LONG	0x80000000L
#define		MAXDOUBLE	1.7976931348623157e+308 /* IEEE double */
#define		MINDOUBLE	-1.7976931348623157e+308
#define		MAX_K		180				/* < (sqrt(4 * RADIX + 1) - 1) * 0.5 */

#define     MPA_ERR_NULL_ADDR	-1
#define     MPA_ERR_ZERODIVIDE	-10
#define     MPA_ERR_OVERFLOW	 11
#define     MPA_ERR_UNDERFLOW	-12
#define     MPA_ERR_A_LT_B		-13
#define     MPA_ERR_SIZE_OVER	-14
#define     MPA_ERR_INVALID		-15
#define     MPA_ERR_OVERFLOW_I	-16

#if 1
typedef struct {
	char   id[2];	/* MP */
	short  opt;
	ushort alen;
	ushort len;
	short exp;
	char sign;
	char zero;
	char num[NMPA1];
} MPA;	/* int[NMPA_INT] */
#else
typedef struct {
	short exp;
	char sign;
	char zero;
	char len;
	char num[NMPA1];
} MPA;	/* int[NMPA_INT] */
#endif

int m_set_a(MPA *a, char *s);
int m_set_an(MPA *a, char *s, int len);
MPA *m_pset_a(MPA *a, char *s);
MPA *m_pset_an(MPA *a, char *s, int len);
int m_normalize(MPA *a);
int m_add(MPA *c, MPA *a, MPA *b);
int m_sub(MPA *c, MPA *a, MPA *b);
int m_add_a(MPA *ans, MPA *a, MPA *b);
int m_sub_a(MPA *ans, MPA *a, MPA *b);
int m_add1(MPA *a, MPA *b);
int m_sub1(MPA *a, MPA *b);
int m_add1_a(MPA *a, MPA *b);
int m_sub1_a(MPA *a, MPA *b);
int m_mul(MPA *ans, MPA *a, MPA *b);
int m_dev(MPA *ans, MPA *aa, MPA *b);
int m_mul1(MPA *a, MPA *b);
int m_div1(MPA *a, MPA *b);
int m_cmp(MPA *a, MPA *b);
int m_cmp_a(MPA *aa, MPA *bb);
void m_print(char *s, MPA *a, int _short);
MPA *m_get_i(int i);
MPA *m_get__mmax();
/*
int m_pack(MPAC *a, MPA *b);
int m_unpack(MPA *a, MPAC *b);
*/
int m_mpa2i(MPA *a, int *val);
int m_mpa2d(MPA *a, double *dval);
int m_dset(double *dval, MPA *a);
int m_mpa2an(MPA *a, char *s, int len_s, int opt);
int m_i2mpa(int val, MPA *a);
int m_d2mpa(double a, MPA *m);
int m_scale(MPA *mpa,int precision,int scale,int opt);
MPA *m_cpy(MPA *d,MPA *s,int iCPY);

/*****************************************
	lϊ
*****************************************/
#define  AKX_CNVN_OPT_NOT_NUM	0x0001			/*   */
#define  AKX_CNVN_OPT_COMMA		0x0002			/*   */
#define  AKX_CNVN_OPT_DIGIT		0x4000			/*   */
#define  AKX_CNVN_OPT_DOUBLE	0x8000			/*   */

/*****************************************
	Etc
*****************************************/
#define AKX_NULL_PRINT	"(null)"

/* These function names are used on Windows and perhaps other systems.  */
#ifndef SUNOS
#ifndef strcmpi
#define strcmpi strcasecmp
#endif
#ifndef stricmp
#define stricmp strcasecmp
#endif
#ifndef strncmpi
#define strncmpi strncasecmp
#endif
#ifndef strnicmp
#define strnicmp strncasecmp
#endif
#endif

/***************************
	prot type
************************/
char akxcupper(/* char ci */);
char *akxt_get_last_name(/* char *delm, char *path */);
tdtTimerCtlHead *akxe_timer_new();
char *akxt_add_dir2(/* char *cpDir, char *cpFile, char **cppPath */);
char *strerror(/* int err */);
char *strnzcpy(/* char *d, char *s, int n */);
FILE *akxa_gs_fopen(/* char *file,char *section,char **argv,int maxargc,
                  char *parm,int len,int opt,int pret[] */);
char *stristr(/* char *target,char *str */);
char *strmem(/* char *s,int len */);
char *memaddv0(/*argc,argv,argl,pp0*/);
char *memaddv(/*argc,argv,argl*/);
char *memadd0(/* a,alen,b,blen,pp0 */);
char *memadd(/* a,alen,b,blen */);
char *straddv(/*argc,argv */);
char *stradd(/* a,b */);
char *stradd5(/* a,b,c,d,e */);

tdtRbCtl *akxs_list_new();

char *akxc_conv_msg(/* tdtMessages message[],int no,int kind */);

char *itoa(/* int n */);
UINT4 akxcmb2ul();

/***************************
	macro
************************/
#define X_MAX(a,b) ((a)>(b)?(a):(b))
#define X_MIN(a,b) ((a)<(b)?(a):(b))
#define X_DIFF(a,b) ((a)>(b)?(a)-(b):(b)-(a))
#define X_ABS(a) ((a)>=0?(a):-(a))
#define X_OFFSET(struc, field)	((int)&(((struc *)0)->field))
#define X_HTONL(x) ((x<<24)&0xff000000 | (x<<8)&0x00ff0000 |\
                    (x>>8)&0x0000ff00 | (x>>24)&0x000000ff)
#define X_HTONS(x) ((x<<8)&0xff00 | (x>>8)&0x00ff)
#define X_NTOHL(x) X_HTONL(x)
#define X_NTOHS(x) X_HTONS(x)

/***********************
	error
************************/
#define XA_ERR		-1000
#define XC_ERR		-1600
#define XE_ERR		-2200
#define XG_ERR		-2800
#define XJ_ERR		-3700
#define XM_ERR		-4600
#define XQ_ERR		-5800
#define XS_ERR		-6400
#define XT_ERR		-6700
#define XX_ERR		-7900

#endif	/* _AKXLIB_H */
