/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import java.util.Calendar;
import org.routine_work.simple_battery_logger.util.PreferenceUtils;
import org.routine_work.utils.Log;

/**
 *
 * @author sawai
 */
public class ServiceUtils
{

	private static final String LOG_TAG = "simple-battery-logger";

	public static void initializeLoggingService(Context context)
	{
		Log.v(LOG_TAG, "Hello");

		boolean loggingServiceEnabled = PreferenceUtils.isLoggingServiceEnabled(context);
		Log.d(LOG_TAG, "loggingServiceEnabled => " + loggingServiceEnabled);

		Intent loggingServiceIntent = new Intent(context, BatteryLoggingService.class);
		if (loggingServiceEnabled)
		{
			context.startService(loggingServiceIntent);
		}
		else
		{
			context.stopService(loggingServiceIntent);
		}

		Log.v(LOG_TAG, "Bye");
	}

	public static void initializeDeleteOldDataTask(Context context)
	{
		Log.v(LOG_TAG, "Hello");

		Intent deleteOldDataIntent = new Intent(context, DeleteOldDataService.class);
		PendingIntent deleteOldDataPI = PendingIntent.getService(context, 0, deleteOldDataIntent, 0);

		// cancel old alarm if exists
		AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
		alarmManager.cancel(deleteOldDataPI);

		// read preference
		int dataKeepingPeriod = PreferenceUtils.getDataKeepingPeriod(context);
		Log.d(LOG_TAG, "dataKeepingPeriod => " + dataKeepingPeriod);

		if (dataKeepingPeriod != 0)
		{
			Calendar cal = Calendar.getInstance();
			cal.set(Calendar.HOUR_OF_DAY, 0);
			cal.set(Calendar.MINUTE, 10);
			cal.set(Calendar.SECOND, 0);
			cal.set(Calendar.MILLISECOND, 0);
			cal.add(Calendar.DAY_OF_MONTH, 1);
			Log.d(LOG_TAG, "Set Delete Old Data Task to AlarmManager " + cal.getTime());
			long startTime = cal.getTimeInMillis();

			// setup new alarm
			alarmManager.setInexactRepeating(AlarmManager.RTC_WAKEUP,
				startTime, AlarmManager.INTERVAL_DAY, deleteOldDataPI);
		}

		Log.v(LOG_TAG, "Bye");
	}

	public static void initializeExportCsvFileTask(Context context)
	{
		Log.v(LOG_TAG, "Hello");

		Intent exportCsvFileIntent = new Intent(context, ExportAllDataCsvFileService.class);
		PendingIntent exportCSVFilePi = PendingIntent.getService(context, 0, exportCsvFileIntent, 0);

		// cancel old alarm if exists
		AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
		alarmManager.cancel(exportCSVFilePi);

		// read preference 
		boolean csvAutoExportEnabled = PreferenceUtils.isCsvAutoExportEnabled(context);
		Log.d(LOG_TAG, "csvAutoExportEnabled => " + csvAutoExportEnabled);

		if (csvAutoExportEnabled)
		{
			Calendar cal = Calendar.getInstance();
			cal.set(Calendar.HOUR_OF_DAY, 0);
			cal.set(Calendar.MINUTE, 20);
			cal.set(Calendar.SECOND, 0);
			cal.set(Calendar.MILLISECOND, 0);
			cal.add(Calendar.DAY_OF_MONTH, 1);
			Log.d(LOG_TAG, "Set Export All Data CSV File Task to AlarmManager " + cal.getTime());
			long startTime = cal.getTimeInMillis();

			// setup new alarm
			alarmManager.setInexactRepeating(AlarmManager.RTC_WAKEUP,
				startTime, AlarmManager.INTERVAL_DAY, exportCSVFilePi);
		}

		Log.v(LOG_TAG, "Bye");
	}
}
