<?xml version="1.0" encoding="Shift_JIS" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" > 
<xsl:output method="xml" encoding="Shift_JIS" omit-xml-declaration="no" />
  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template> 

  <xsl:template match="/storyboard">
    <opml version="1.0">
    <head>
    <title><xsl:value-of select="title" /></title>
    </head>
    <body>
    <xsl:apply-templates select="bookmarks"/>
    <xsl:apply-templates select="table"/>
    </body>
    </opml>
  </xsl:template> 

  <xsl:template match="bookmarks">
    <outline  text="擪" isBreakpoint="true"/>
    <xsl:apply-templates select="mark"/>
  </xsl:template> 

  <xsl:template match="mark">
    <outline isBreakpoint="true">
      <xsl:attribute name="text">
      <xsl:value-of select="name"/>
    </xsl:attribute>
    </outline>
  </xsl:template> 

  <xsl:template match="table">
    <xsl:apply-templates select="tr"/>
  </xsl:template> 

  <xsl:template match="tr">
    <outline>
      <outline type="key">
        <xsl:attribute name="text">
          <xsl:value-of select="key"/>
        </xsl:attribute>
      </outline>
      <outline type="cut">
        <xsl:attribute name="text">
          <xsl:value-of select="cut"/>
        </xsl:attribute>
      </outline>
      <outline type="img">
        <xsl:attribute name="text">
          <xsl:value-of select="img"/>
        </xsl:attribute>
      </outline>
      <outline type="desc">
        <xsl:attribute name="text">
          <xsl:value-of select="desc"/>
        </xsl:attribute>
      </outline>
      <outline type="words">
        <xsl:attribute name="text">
          <xsl:value-of select="words"/>
        </xsl:attribute>
      </outline>
      <outline type="sec">
        <xsl:attribute name="text">
          <xsl:value-of select="sec"/>
        </xsl:attribute>
      </outline>
      <outline type="total">
        <xsl:attribute name="text">
          <xsl:value-of select="total"/>
        </xsl:attribute>
      </outline>
    </outline>
  </xsl:template> 

</xsl:stylesheet>