/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.imageio.ImageIO;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class sbeditAccelerator {
    private static Logger logger;
    private static String execPath;
    private static String cashImgPath;

    sbeditAccelerator() {
    }

    public static void main(String[] argv) {
        FileHandler fileHandler;
        if (argv == null || argv.length < 2) {
            return;
        }
        String filename = argv[0];
        execPath = argv[1];
        logger = Logger.getLogger("sbeditAccelerator");
        try {
            FileInputStream inputStream = new FileInputStream(String.valueOf(execPath) + File.separator + "Alog.properties");
            LogManager.getLogManager().readConfiguration(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException ex) {
            try {
                fileHandler = new FileHandler("sbeditA%g.log", 100000, 4);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            try {
                fileHandler = new FileHandler("sbeditA%g.log", 100000, 4);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        logger.info("XML\u30d5\u30a1\u30a4\u30eb\uff1d" + filename + " \u30c7\u30a3\u30ec\u30af\u30c8\u30ea=" + execPath);
        MakeFileList mfl = new MakeFileList();
        try {
            File xmlfile = new File(filename);
            cashImgPath = String.valueOf(xmlfile.getCanonicalFile().getParent()) + File.separatorChar + "img" + File.separatorChar;
            logger.info("cashImgPath=" + cashImgPath);
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            parser.parse(xmlfile, (DefaultHandler)mfl);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warning("\u30ea\u30b9\u30c8\u4f5c\u6210\u5931\u6557" + e.getMessage());
            return;
        }
        List<File> imgFileList = mfl.getImgFileList();
        char[] cashType = mfl.getCashType();
        boolean widemode = mfl.getWideMode();
        logger.info("\u30ea\u30b9\u30c8\u4f5c\u6210\u5b8c\u4e86\uff1alist=" + imgFileList + " cashType=" + cashType.toString() + " widemode=" + widemode);
        int maxsize = imgFileList.size();
        logger.info("\u51e6\u7406\u30ab\u30c3\u30c8\u6570\uff1d" + maxsize);
        char[] cArray = cashType;
        int n = cashType.length;
        int n2 = 0;
        while (n2 < n) {
            char t = cArray[n2];
            StringBuilder cashDirName = null;
            try {
                File cashImgDir = new File(cashImgPath).getCanonicalFile();
                cashDirName = new StringBuilder(cashImgDir.getCanonicalPath()).append(File.separator).append(t);
                File cdir = new File(cashDirName.toString());
                cdir.mkdirs();
            }
            catch (IOException ioe) {
                logger.warning("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u5931\u6557\u3002\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\uff1d" + cashDirName.toString() + " \u30a8\u30e9\u30fc\uff1d" + ioe.getLocalizedMessage());
            }
            ++n2;
        }
        int i = 0;
        for (File f : imgFileList) {
            sbeditAccelerator.makeCash(f, cashType, widemode);
            logger.info(String.valueOf(++i) + "/" + maxsize + " \u5b8c\u4e86");
            System.gc();
        }
        logger.info("\u51e6\u7406\u5168\u90e8\u7d42\u4e86");
    }

    private static void makeCash(File readImgFile, char[] cashType, boolean widemode) {
        logger.info("File=" + readImgFile.toString() + " widemode=" + widemode);
        Image readImage = null;
        Image bimgL = null;
        Graphics gL = null;
        Image bimgM = null;
        Graphics gM = null;
        Image bimgS = null;
        Graphics gS = null;
        Image scimgS = null;
        try {
            StringBuilder cashFileName;
            if (!readImgFile.getCanonicalFile().exists()) {
                logger.warning("\u5143\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306a\u3057\uff1d" + readImgFile);
                return;
            }
            File cashImgDir = new File(cashImgPath).getCanonicalFile();
            String tmpname = readImgFile.getName();
            StringBuilder readImgFileName = new StringBuilder(tmpname.substring(0, tmpname.lastIndexOf(46) + 1)).append("png");
            boolean makeflg = false;
            HashMap<String, Boolean> flgs = new HashMap<String, Boolean>(3);
            char[] cArray = cashType;
            int n = cashType.length;
            int n2 = 0;
            while (n2 < n) {
                char t = cArray[n2];
                cashFileName = new StringBuilder(cashImgDir.getCanonicalPath()).append(File.separator).append(t).append(File.separator).append((CharSequence)readImgFileName);
                logger.info("ReadFile=" + tmpname + " \u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb\uff1d" + cashFileName);
                File cashFile = new File(cashFileName.toString());
                if (!readImgFile.getCanonicalFile().exists() || cashFile.getCanonicalFile().lastModified() <= 0L) {
                    logger.info("\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u306a\u3044");
                    makeflg = true;
                    flgs.put(String.valueOf(t), new Boolean(true));
                } else if (readImgFile.getCanonicalFile().lastModified() > cashFile.getCanonicalFile().lastModified()) {
                    logger.info("\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3059\u308b\u304c\u53e4\u3044 \u30aa\u30ea\u30b8\u30ca\u30eb\uff1d" + readImgFile.getCanonicalFile().lastModified() + " \u30ad\u30e3\u30c3\u30b7\u30e5\uff1d" + cashFile.getCanonicalFile().lastModified());
                    makeflg = true;
                    flgs.put(String.valueOf(t), new Boolean(true));
                }
                ++n2;
            }
            if (!makeflg) {
                logger.info("\u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb\u306f\u5168\u3066\u65e2\u306b\u3042\u308b\u306e\u3067\u4f5c\u6210\u3057\u306a\u3044\u3002\u5143\u753b\u50cf:" + readImgFile.getCanonicalFile().lastModified());
                return;
            }
            try {
                int x;
                MyObserver obRead = new MyObserver(logger);
                readImage = Toolkit.getDefaultToolkit().getImage(readImgFile.getCanonicalPath());
                MyObserver obS = new MyObserver(logger);
                Boolean b = (Boolean)flgs.get("S");
                if (b != null && b.booleanValue()) {
                    logger.info("S\u4f5c\u6210:\u7e2e\u5c0f\u958b\u59cb");
                    x = 160;
                    int y = widemode ? 90 : 120;
                    bimgS = new BufferedImage(x, y, 5);
                    gS = ((BufferedImage)bimgS).createGraphics();
                    scimgS = readImage.getScaledInstance(x, y, 4);
                }
                MyObserver obL = new MyObserver(logger);
                b = (Boolean)flgs.get("L");
                if (b != null && b.booleanValue()) {
                    logger.info("L\u4f5c\u6210:\u7e2e\u5c0f\u958b\u59cb");
                    x = 640;
                    int y = widemode ? 360 : 480;
                    int h = readImage.getHeight(obRead);
                    obRead.waitforcomplete();
                    int w = readImage.getWidth(obRead);
                    obRead.waitforcomplete();
                    h = readImage.getHeight(obRead);
                    obRead.waitforcomplete();
                    logger.info("x,y=(" + x + ", " + y + ") w,h=(" + w + ", " + h + ")");
                    if (x == w && y == h) {
                        logger.info("\u5927\u304d\u3055\u304c\u5168\u304f\u540c\u3058\u306a\u306e\u3067\u30b3\u30d4\u30fc\u3067\u6e08\u307e\u3059");
                        cashFileName = new StringBuilder(cashImgDir.getCanonicalPath()).append(File.separator).append('L').append(File.separator).append((CharSequence)readImgFileName);
                        try {
                            FileCopy.copy(readImgFile.getCanonicalPath(), cashFileName.toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.warning("copy\u5931\u6557\uff1a" + e.toString());
                        }
                        flgs.remove("L");
                    } else {
                        logger.info("\uff2c\u672c\u5f53\u306b\u7e2e\u5c0f\u3059\u308b");
                        bimgL = new BufferedImage(x, y, 5);
                        gL = ((BufferedImage)bimgL).createGraphics();
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                        ((Graphics2D)gL).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                        gL.drawImage(readImage, 0, 0, x, y, obL);
                    }
                }
                MyObserver obM = new MyObserver(logger);
                b = (Boolean)flgs.get("M");
                if (b != null && b.booleanValue()) {
                    logger.info("M\u4f5c\u6210:\u7e2e\u5c0f\u958b\u59cb");
                    x = 320;
                    int y = widemode ? 180 : 240;
                    bimgM = new BufferedImage(x, y, 5);
                    gM = ((BufferedImage)bimgM).createGraphics();
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    readImage.getWidth(obRead);
                    obRead.waitforcomplete();
                    gM.drawImage(readImage, 0, 0, x, y, obM);
                }
                if ((b = (Boolean)flgs.get("M")) != null && b.booleanValue()) {
                    cashFileName = new StringBuilder(cashImgDir.getCanonicalPath()).append(File.separator).append('M').append(File.separator).append((CharSequence)readImgFileName);
                    logger.info("ReadFile=" + tmpname + " \u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb\uff1d" + cashFileName);
                    File cashFile = new File(cashFileName.toString());
                    cashFile.getCanonicalFile().delete();
                    ImageIO.write((RenderedImage)((Object)bimgM), "png", cashFile.getCanonicalFile());
                    bimgM.flush();
                    bimgM = null;
                    gM.dispose();
                    gM = null;
                    logger.info("\u4f5c\u6210\u3057\u305f\uff1areadImgFile=" + readImgFile.getCanonicalPath() + " cashFile=" + cashFile.getCanonicalPath());
                }
                if ((b = (Boolean)flgs.get("L")) != null && b.booleanValue()) {
                    cashFileName = new StringBuilder(cashImgDir.getCanonicalPath()).append(File.separator).append('L').append(File.separator).append((CharSequence)readImgFileName);
                    logger.info("ReadFile=" + tmpname + " \u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb\uff1d" + cashFileName);
                    File cashFile = new File(cashFileName.toString());
                    cashFile.getCanonicalFile().delete();
                    ImageIO.write((RenderedImage)((Object)bimgL), "png", cashFile.getCanonicalFile());
                    bimgL.flush();
                    bimgL = null;
                    gL.dispose();
                    gL = null;
                    logger.info("\u4f5c\u6210\u3057\u305f\uff1areadImgFile=" + readImgFile.getCanonicalPath() + " cashFile=" + cashFile.getCanonicalPath());
                }
                if ((b = (Boolean)flgs.get("S")) != null && b.booleanValue()) {
                    scimgS.getWidth(obS);
                    cashFileName = new StringBuilder(cashImgDir.getCanonicalPath()).append(File.separator).append('S').append(File.separator).append((CharSequence)readImgFileName);
                    logger.info("ReadFile=" + tmpname + " \u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb\uff1d" + cashFileName);
                    File cashFile = new File(cashFileName.toString());
                    cashFile.getCanonicalFile().delete();
                    obS.waitforcomplete();
                    gS.drawImage(scimgS, 0, 0, obS);
                    obS.waitforcomplete();
                    ImageIO.write((RenderedImage)((Object)bimgS), "png", cashFile.getCanonicalFile());
                    scimgS.flush();
                    scimgS = null;
                    bimgS.flush();
                    bimgS = null;
                    gS.dispose();
                    gS = null;
                    logger.info("\u4f5c\u6210\u3057\u305f\uff1areadImgFile=" + readImgFile.getCanonicalPath() + " cashFile=" + cashFile.getCanonicalPath());
                }
                readImage.flush();
                readImage = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                logger.warning(ioe.toString());
            }
        }
        finally {
            if (readImage != null) {
                readImage.flush();
            }
            if (gL != null) {
                gL.dispose();
            }
            if (bimgL != null) {
                bimgL.flush();
            }
            if (gM != null) {
                gM.dispose();
            }
            if (bimgM != null) {
                bimgM.flush();
            }
            if (gS != null) {
                gS.dispose();
            }
            if (bimgS != null) {
                bimgS.flush();
            }
            if (scimgS != null) {
                scimgS.flush();
            }
        }
    }
}

