/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.jp2k;

import com.sun.medialib.codec.jp2k.Box;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Constants;
import com.sun.medialib.codec.jp2k.Params;
import com.sun.medialib.codec.jp2k.Size;
import com.sun.medialib.mlib.mediaLibImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public final class Encoder
implements Constants {
    private CompParams compparams = null;
    private Params params = null;
    private int mode = 0;
    private int encoder = 0;

    public Encoder(ImageOutputStream imageOutputStream) {
        this.encoder = this.encode_init(imageOutputStream);
    }

    public final void encode(mediaLibImage[] mediaLibImageArray, int n) throws IOException {
        int n2 = this.encode(this.encoder, mediaLibImageArray, n);
    }

    public final void setEncodeCodeStreamOnly() throws IOException {
        Box box = new Box(0x7FFFFFFE, null);
        Box box2 = new Box(Integer.MAX_VALUE, null);
        this.encodeBox(box);
        this.encodeBox(box2);
    }

    public final void encodeBox(Box box) throws IOException {
        int n = this.encode_box(this.encoder, box);
    }

    public final Box createSuperBox(int n, Box[] boxArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n2 = 0;
        while (n2 < boxArray.length) {
            dataOutputStream.writeInt(boxArray[n2].data.length + 8);
            dataOutputStream.writeInt(boxArray[n2].type);
            dataOutputStream.write(boxArray[n2].data);
            ++n2;
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        Box box = new Box();
        box.type = n;
        box.data = byteArrayOutputStream.toByteArray();
        return box;
    }

    public final void setMode(int n) {
        this.mode = n;
        this.encode_set_mode(this.encoder, this.mode);
    }

    public final void setRate(double d, int n) {
        int n2 = this.encode_rate(this.encoder, d, n);
    }

    public final Params getParams(Params params) {
        if (params == null) {
            this.params = new Params();
            int n = this.encode_get_nilrates(this.encoder, this.params);
            this.params.ilrates = new double[n];
        } else {
            this.params = params;
        }
        int n = this.encode_get_params(this.encoder, this.params);
        if (n == 0) {
            return this.params;
        }
        return null;
    }

    public final void setParams(Params params) {
        int n = this.encode_params(this.encoder, params);
    }

    public final CompParams getCompParams(CompParams compParams, int n) {
        this.compparams = compParams == null ? new CompParams() : compParams;
        int n2 = this.encode_get_comp_params(this.encoder, this.compparams, n);
        if (n2 == 0) {
            return this.compparams;
        }
        return null;
    }

    public final void setCompParams(CompParams compParams, int n) {
        int n2 = this.encode_comp_params(this.encoder, compParams, n);
    }

    public final void setSize(Size size) {
        int n = this.encode_size(this.encoder, size);
    }

    protected void finalize() throws Throwable {
        this.encode_free(this.encoder);
        this.encoder = 0;
    }

    public static final String getVersion() {
        return Encoder.encode_get_version();
    }

    private static native String encode_get_version();

    private native int encode_init(ImageOutputStream var1);

    private native void encode_free(int var1);

    private native void encode_set_mode(int var1, int var2);

    private native int encode_get_nilrates(int var1, Params var2);

    private native int encode_get_params(int var1, Params var2);

    private native int encode_rate(int var1, double var2, int var4);

    private native int encode_params(int var1, Params var2);

    private native int encode_get_comp_params(int var1, CompParams var2, int var3);

    private native int encode_comp_params(int var1, CompParams var2, int var3);

    private native int encode_size(int var1, Size var2);

    private native int encode(int var1, mediaLibImage[] var2, int var3);

    private native int encode_box(int var1, Box var2);

    static {
        System.loadLibrary("clib_jiio");
    }
}

