/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActions;
import java.io.IOException;
import java.io.PrintWriter;

public class ActionTextWriter
implements SWFActions,
SWFActionCodes {
    protected PrintWriter printer;
    protected String indent = "";

    public ActionTextWriter(PrintWriter printer) {
        this.printer = printer;
    }

    protected void print(String mnemonic, String[] args) {
        this.printer.print(String.valueOf(this.indent) + "    ");
        this.writePaddedString(String.valueOf(mnemonic) + " ", 15);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    this.printer.print(", ");
                }
                this.printer.print(args[i]);
                ++i;
            }
        }
        this.printer.println();
    }

    protected void writePaddedString(String s, int length) {
        int pad = length - s.length();
        this.printer.print(s);
        while (pad > 0) {
            this.printer.print(" ");
            --pad;
        }
    }

    @Override
    public void start(int conditions) throws IOException {
        this.print("conditions", new String[]{Integer.toBinaryString(conditions)});
        this.printer.flush();
    }

    @Override
    public void end() throws IOException {
        this.print("end", null);
        this.printer.println();
    }

    @Override
    public void done() throws IOException {
        this.printer.flush();
    }

    @Override
    public void blob(byte[] blob) throws IOException {
        this.print("(blob)", null);
        this.printer.println();
    }

    @Override
    public void unknown(int code, byte[] data) throws IOException {
        this.print("unknown code =", new String[]{Integer.toString(code)});
    }

    @Override
    public void initArray() throws IOException {
        this.print("initArray", null);
    }

    @Override
    public void jumpLabel(String label) throws IOException {
        this.printer.println(String.valueOf(this.indent) + label + ":");
    }

    @Override
    public void gotoFrame(int frameNumber) throws IOException {
        this.print("gotoFrame", new String[]{Integer.toString(frameNumber)});
    }

    @Override
    public void gotoFrame(String label) throws IOException {
        this.print("gotoFrame", new String[]{"\"" + label + "\""});
    }

    @Override
    public void getURL(String url, String target) throws IOException {
        this.print("getURL", new String[]{"\"" + url + "\"", "\"" + target + "\""});
    }

    @Override
    public void nextFrame() throws IOException {
        this.print("nextFrame", null);
    }

    @Override
    public void prevFrame() throws IOException {
        this.print("previousFrame", null);
    }

    @Override
    public void play() throws IOException {
        this.print("play", null);
    }

    @Override
    public void stop() throws IOException {
        this.print("stop", null);
    }

    @Override
    public void toggleQuality() throws IOException {
        this.print("toggleQuality", null);
    }

    @Override
    public void stopSounds() throws IOException {
        this.print("stopSounds", null);
    }

    @Override
    public void setTarget(String target) throws IOException {
        this.print("setTarget", new String[]{"\"" + target + "\""});
    }

    @Override
    public void jump(String jumpLabel) throws IOException {
        this.print("jump", new String[]{"\"" + jumpLabel + "\""});
    }

    @Override
    public void ifJump(String jumpLabel) throws IOException {
        this.print("ifJump", new String[]{"\"" + jumpLabel + "\""});
    }

    @Override
    public void waitForFrame(int frameNumber, String jumpLabel) throws IOException {
        this.print("waitForFrame", new String[]{Integer.toString(frameNumber), "\"" + jumpLabel + "\""});
    }

    @Override
    public void waitForFrame(String jumpLabel) throws IOException {
        this.print("waitForFrame", new String[]{"\"" + jumpLabel + "\""});
    }

    @Override
    public void pop() throws IOException {
        this.print("pop", null);
    }

    @Override
    public void push(String value) throws IOException {
        this.print("push", new String[]{"\"" + value + "\""});
    }

    @Override
    public void push(float value) throws IOException {
        this.print("push", new String[]{"float " + value});
    }

    @Override
    public void push(double value) throws IOException {
        this.print("push", new String[]{"double " + value});
    }

    @Override
    public void pushNull() throws IOException {
        this.print("push", new String[]{"null"});
    }

    @Override
    public void pushRegister(int registerNumber) throws IOException {
        this.print("push", new String[]{"register( " + registerNumber + " )"});
    }

    @Override
    public void push(boolean value) throws IOException {
        this.print("push", new String[]{value ? "true" : "false"});
    }

    @Override
    public void push(int value) throws IOException {
        this.print("push", new String[]{"" + value});
    }

    @Override
    public void lookup(int dictionaryIndex) throws IOException {
        this.print("push", new String[]{"lookup( " + dictionaryIndex + " )"});
    }

    @Override
    public void add() throws IOException {
        this.print("add", null);
    }

    @Override
    public void substract() throws IOException {
        this.print("substract", null);
    }

    @Override
    public void multiply() throws IOException {
        this.print("multiply", null);
    }

    @Override
    public void divide() throws IOException {
        this.print("divide", null);
    }

    @Override
    public void equals() throws IOException {
        this.print("equals", null);
    }

    @Override
    public void lessThan() throws IOException {
        this.print("lessThan", null);
    }

    @Override
    public void and() throws IOException {
        this.print("and", null);
    }

    @Override
    public void or() throws IOException {
        this.print("or", null);
    }

    @Override
    public void not() throws IOException {
        this.print("not", null);
    }

    @Override
    public void stringEquals() throws IOException {
        this.print("stringEquals", null);
    }

    @Override
    public void stringLength() throws IOException {
        this.print("stringLength", null);
    }

    @Override
    public void concat() throws IOException {
        this.print("concat", null);
    }

    @Override
    public void substring() throws IOException {
        this.print("substring", null);
    }

    @Override
    public void stringLessThan() throws IOException {
        this.print("stringLessThan", null);
    }

    @Override
    public void stringLengthMB() throws IOException {
        this.print("stringLengthMB", null);
    }

    @Override
    public void substringMB() throws IOException {
        this.print("substringMB", null);
    }

    @Override
    public void toInteger() throws IOException {
        this.print("toInteger", null);
    }

    @Override
    public void charToAscii() throws IOException {
        this.print("charToAscii", null);
    }

    @Override
    public void asciiToChar() throws IOException {
        this.print("asciiToChar", null);
    }

    @Override
    public void charMBToAscii() throws IOException {
        this.print("charMBToAscii", null);
    }

    @Override
    public void asciiToCharMB() throws IOException {
        this.print("asciiToCharMB", null);
    }

    @Override
    public void call() throws IOException {
        this.print("call", null);
    }

    @Override
    public void getVariable() throws IOException {
        this.print("getVariable", null);
    }

    @Override
    public void setVariable() throws IOException {
        this.print("setVariable", null);
    }

    @Override
    public void getURL(int sendVars, int loadMode) throws IOException {
        String sendVars_ = null;
        switch (sendVars) {
            case 1: {
                sendVars_ = "send vars via GET";
                break;
            }
            case 2: {
                sendVars_ = "send vars via POST";
                break;
            }
            default: {
                sendVars_ = "no send";
            }
        }
        String mode = null;
        switch (loadMode) {
            case 0: {
                mode = "load movie into level";
                break;
            }
            case 1: {
                mode = "load movie into sprite";
                break;
            }
            case 3: {
                mode = "load vars into level";
                break;
            }
            case 4: {
                mode = "load vars into sprite";
                break;
            }
            default: {
                mode = "???";
            }
        }
        this.print("getURL", new String[]{sendVars_, mode});
    }

    @Override
    public void gotoFrame(boolean play) throws IOException {
        this.print("gotoFrame", new String[]{play ? "and play" : "and stop"});
    }

    @Override
    public void setTarget() throws IOException {
        this.print("setTarget", null);
    }

    @Override
    public void getProperty() throws IOException {
        this.print("getProperty", null);
    }

    @Override
    public void setProperty() throws IOException {
        this.print("setProperty", null);
    }

    @Override
    public void cloneSprite() throws IOException {
        this.print("cloneSprite", null);
    }

    @Override
    public void removeSprite() throws IOException {
        this.print("removeSprite", null);
    }

    @Override
    public void startDrag() throws IOException {
        this.print("startDrag", null);
    }

    @Override
    public void endDrag() throws IOException {
        this.print("endDrag", null);
    }

    @Override
    public void trace() throws IOException {
        this.print("trace", null);
    }

    @Override
    public void getTime() throws IOException {
        this.print("getTime", null);
    }

    @Override
    public void randomNumber() throws IOException {
        this.print("randomNumber", null);
    }

    @Override
    public void lookupTable(String[] values) throws IOException {
        this.print("lookupTable", null);
        int i = 0;
        while (i < values.length) {
            this.printer.print(String.valueOf(this.indent) + "        ");
            this.writePaddedString(String.valueOf(Integer.toString(i)) + ":", 5);
            this.printer.println("\"" + values[i] + "\"");
            ++i;
        }
    }

    @Override
    public void callFunction() throws IOException {
        this.print("callFunction", null);
    }

    @Override
    public void callMethod() throws IOException {
        this.print("callMethod", null);
    }

    @Override
    public void startFunction(String name, String[] paramNames) throws IOException {
        String args = String.valueOf(name) + "(";
        if (paramNames != null) {
            int i = 0;
            while (i < paramNames.length) {
                if (i > 0) {
                    args = String.valueOf(args) + ",";
                }
                args = String.valueOf(args) + " " + paramNames[i];
                ++i;
            }
            if (paramNames.length > 0) {
                args = String.valueOf(args) + " ";
            }
        }
        args = String.valueOf(args) + ")";
        this.printer.println();
        this.print("defineFunction", new String[]{args});
        this.print("{", null);
        this.indent = String.valueOf(this.indent) + "    ";
    }

    @Override
    public void endBlock() throws IOException {
        if (this.indent.length() <= 4) {
            this.indent = "";
        } else if (this.indent.length() >= 4) {
            this.indent = this.indent.substring(4);
        }
        this.print("}", null);
        this.printer.println();
    }

    @Override
    public void comment(String comment) throws IOException {
        this.printer.println(String.valueOf(this.indent) + "    // " + comment);
    }

    @Override
    public void defineLocalValue() throws IOException {
        this.print("defineLocalValue", null);
    }

    @Override
    public void defineLocal() throws IOException {
        this.print("defineLocal", null);
    }

    @Override
    public void deleteProperty() throws IOException {
        this.print("deleteProperty", null);
    }

    @Override
    public void deleteThreadVars() throws IOException {
        this.print("deleteThreadVars", null);
    }

    @Override
    public void enumerate() throws IOException {
        this.print("enumerate", null);
    }

    @Override
    public void typedEquals() throws IOException {
        this.print("typedEquals", null);
    }

    @Override
    public void getMember() throws IOException {
        this.print("getMember", null);
    }

    @Override
    public void initObject() throws IOException {
        this.print("initObject", null);
    }

    @Override
    public void newMethod() throws IOException {
        this.print("newMethod", null);
    }

    @Override
    public void newObject() throws IOException {
        this.print("newObject", null);
    }

    @Override
    public void setMember() throws IOException {
        this.print("setMember", null);
    }

    @Override
    public void getTargetPath() throws IOException {
        this.print("getTargetPath", null);
    }

    @Override
    public void startWith() throws IOException {
        this.printer.println();
        this.print("with", null);
        this.print("{", null);
        this.indent = String.valueOf(this.indent) + "    ";
    }

    @Override
    public void duplicate() throws IOException {
        this.print("duplicate", null);
    }

    @Override
    public void returnValue() throws IOException {
        this.print("return", null);
    }

    @Override
    public void swap() throws IOException {
        this.print("swap", null);
    }

    @Override
    public void storeInRegister(int registerNumber) throws IOException {
        this.print("register", new String[]{Integer.toString(registerNumber)});
    }

    @Override
    public void convertToNumber() throws IOException {
        this.print("convertToNumber", null);
    }

    @Override
    public void convertToString() throws IOException {
        this.print("convertToString", null);
    }

    @Override
    public void typeOf() throws IOException {
        this.print("typeOf", null);
    }

    @Override
    public void typedAdd() throws IOException {
        this.print("typedAdd", null);
    }

    @Override
    public void typedLessThan() throws IOException {
        this.print("typedLessThan", null);
    }

    @Override
    public void modulo() throws IOException {
        this.print("modulo", null);
    }

    @Override
    public void bitAnd() throws IOException {
        this.print("bitAnd", null);
    }

    @Override
    public void bitOr() throws IOException {
        this.print("bitOr", null);
    }

    @Override
    public void bitXor() throws IOException {
        this.print("bitXor", null);
    }

    @Override
    public void shiftLeft() throws IOException {
        this.print("shiftLeft", null);
    }

    @Override
    public void shiftRight() throws IOException {
        this.print("shiftRight", null);
    }

    @Override
    public void shiftRightUnsigned() throws IOException {
        this.print("shiftRightUnsigned", null);
    }

    @Override
    public void decrement() throws IOException {
        this.print("decrement", null);
    }

    @Override
    public void increment() throws IOException {
        this.print("increment", null);
    }

    @Override
    public void enumerateObject() throws IOException {
        this.print("enumerateObject", null);
    }

    @Override
    public void greaterThan() throws IOException {
        this.print("greaterThan", null);
    }

    @Override
    public void instanceOf() throws IOException {
        this.print("instanceOf", null);
    }

    @Override
    public void strictEquals() throws IOException {
        this.print("strictEquals", null);
    }

    @Override
    public void stringGreaterThan() throws IOException {
        this.print("greaterThan", null);
    }
}

