/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Sound;
import com.anotherbigidea.flash.sound.MP3Frame;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MP3Helper {
    public static Sound getSoundDefinition(InputStream mp3) throws IOException {
        MP3Frame frame = MP3Frame.readFrame(mp3);
        int samplesPerFrame = frame.getSamplesPerFrame();
        int sampleRate = frame.getSampleRate();
        boolean isStereo = frame.isStereo();
        int rate = 0;
        if (sampleRate >= 44000) {
            rate = 3;
        } else if (sampleRate >= 22000) {
            rate = 2;
        } else if (sampleRate >= 11000) {
            rate = 1;
        }
        int sampleCount = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while (frame != null) {
            bout.write(0);
            bout.write(0);
            while (frame != null) {
                sampleCount += frame.getSamplesPerFrame();
                frame.write(bout);
                frame = MP3Frame.readFrame(mp3);
            }
            bout.flush();
        }
        mp3.close();
        byte[] data = bout.toByteArray();
        return new Sound(2, rate, true, isStereo, sampleCount, data);
    }

    public static SoundStreamHead streamingBlocks(InputStream mp3, int framesPerSecond, ArrayList blocks) throws IOException {
        MP3Frame frame = MP3Frame.readFrame(mp3);
        int samplesPerFrame = frame.getSamplesPerFrame();
        int sampleRate = frame.getSampleRate();
        int totalSamples = 0;
        int samplesPerSWFFrame = sampleRate / framesPerSecond;
        boolean isStereo = frame.isStereo();
        int rate = 0;
        if (sampleRate >= 44000) {
            rate = 3;
        } else if (sampleRate >= 22000) {
            rate = 2;
        } else if (sampleRate >= 11000) {
            rate = 1;
        }
        SoundStreamHead head = new SoundStreamHead(rate, true, isStereo, 2, rate, true, isStereo, samplesPerSWFFrame);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while (frame != null) {
            bout.write(0);
            bout.write(0);
            bout.write(0);
            bout.write(0);
            int sampleCount = 0;
            int targetSampleCount = samplesPerSWFFrame * (blocks.size() + 1);
            while (frame != null && totalSamples + sampleCount < targetSampleCount) {
                sampleCount += frame.getSamplesPerFrame();
                frame.write(bout);
                frame = MP3Frame.readFrame(mp3);
            }
            bout.flush();
            byte[] bytes = bout.toByteArray();
            bytes[0] = (byte)(sampleCount & 0xFF);
            bytes[1] = (byte)(sampleCount >> 8);
            totalSamples += sampleCount;
            blocks.add(bytes);
            bout.reset();
        }
        mp3.close();
        double soundLength = (double)totalSamples / (double)sampleRate;
        int requiredFrames = (int)(soundLength * (double)framesPerSecond);
        System.out.println("Required=" + requiredFrames + " actual=" + blocks.size());
        while (blocks.size() < requiredFrames) {
            blocks.add(null);
        }
        return head;
    }

    public static void main(String[] args) throws IOException {
        FileInputStream mp3 = new FileInputStream(args[0]);
        ArrayList blocks = new ArrayList();
        SoundStreamHead head = MP3Helper.streamingBlocks(mp3, 30, blocks);
        Movie movie = new Movie();
        movie.setFrameRate(30);
        Frame f = movie.appendFrame();
        f.setSoundHeader(head);
        for (byte[] data : blocks) {
            f.setSoundData(data);
            f = movie.appendFrame();
        }
        movie.write(args[1]);
    }
}

