/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.TimeLine;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;

public class MovieClip
extends Symbol
implements TimeLine {
    protected SortedMap frames = new TreeMap();
    protected int frameCount = 0;
    protected int depth = 1;

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public Frame getFrame(int frameNumber) {
        if (frameNumber < 1) {
            return null;
        }
        Integer num = new Integer(frameNumber);
        Frame frame = (Frame)this.frames.get(num);
        if (frame == null) {
            frame = new Frame(frameNumber, this);
            this.frames.put(num, frame);
            if (frameNumber > this.frameCount) {
                this.frameCount = frameNumber;
            }
        }
        return frame;
    }

    @Override
    public Frame appendFrame() {
        ++this.frameCount;
        Frame frame = new Frame(this.frameCount, this);
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    public Frame appendFrame(Frame frame) {
        ++this.frameCount;
        frame.timeline = this;
        frame.frameNumber = this.frameCount;
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    @Override
    public int getAvailableDepth() {
        return this.depth;
    }

    @Override
    public void setAvailableDepth(int depth) {
        if (depth < 1) {
            return;
        }
        this.depth = depth;
    }

    @Override
    protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        for (Frame frame : this.frames.values()) {
            frame.flushDefinitions(movie, timelineWriter, definitionWriter);
        }
        int id = this.getNextId(movie);
        SWFTagTypes spriteWriter = definitionWriter.tagDefineSprite(id);
        int lastFrame = 0;
        for (Frame frame : this.frames.values()) {
            int number = frame.getFrameNumber();
            while (number > lastFrame + 1) {
                spriteWriter.tagShowFrame();
                ++lastFrame;
            }
            frame.write(movie, definitionWriter, spriteWriter);
            lastFrame = number;
        }
        spriteWriter.tagEnd();
        return id;
    }
}

