/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

class SBDTable
extends JTable
implements DropTargetListener {
    private static final long serialVersionUID = 1L;
    private SBDTableModel model;
    private JLabel statusBar;
    private Logger logger;
    private Locale lang;
    private String formatStr;

    SBDTable(SBDTableModel m, JLabel s, Locale lng, Logger l) {
        super(m);
        new DropTarget(this, this);
        this.model = m;
        this.statusBar = s;
        this.lang = lng;
        this.logger = l;
        this.formatStr = this.lang == Locale.JAPANESE ? "%d\u884c\u76ee\u2026\u5927\u4f53%d/%d\u30da\u30fc\u30b8\u76ee" : "Line:%d About %d/%d page";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        try {
            int line = this.getSelectedRow();
            double pgf = (double)(line / this.model.getLinesParPage()) + 0.5;
            long pg = Math.round(pgf);
            int max = this.getRowCount() / this.model.getLinesParPage();
            String sts = String.format(this.lang, this.formatStr, line + 1, pg, max);
            this.statusBar.setText(sts);
        }
        catch (Exception ex) {
            this.logger.warning("\u30b9\u30c6\u30fc\u30bf\u30b9\u30d0\u30fc\u63cf\u753b\u5931\u6557 " + ex.toString());
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List myList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                if (myList.size() >= 1) {
                    File myFile = (File)myList.get(0);
                    Point p = dtde.getLocation();
                    int row = this.rowAtPoint(p);
                    this.model.setValueAt(myFile.getCanonicalPath(), row, 1);
                    if (myList.size() > 1) {
                        ArrayList<String> al = new ArrayList<String>();
                        int cnt = 0;
                        int i = 1;
                        while (i < myList.size()) {
                            myFile = (File)myList.get(i);
                            if (row + i >= this.model.getRowCount()) break;
                            al.add(myFile.getCanonicalPath());
                            ++i;
                        }
                        Object[] tmplist = al.toArray();
                        this.logger.info("Len=" + tmplist.length);
                        Arrays.sort(tmplist);
                        cnt = 0;
                        int i2 = 1;
                        while (i2 < myList.size()) {
                            if (row + i2 >= this.model.getRowCount()) break;
                            this.model.setValueAt((String)tmplist[cnt], row + i2, 1);
                            this.logger.info("2nd tmplist[" + cnt + "]=" + (String)tmplist[cnt]);
                            ++cnt;
                            ++i2;
                        }
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    this.logger.info("Invalid size.");
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                this.logger.info("Unsupported.");
                dtde.rejectDrop();
            }
        }
        catch (IOException ioe) {
            this.logger.info("I/O exception.");
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            this.logger.info("Unsupported");
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(1);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

