/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.LinkedList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PrintProgress
implements Printable {
    sbedit parent;
    LinkedList model;
    LinkedList column = null;
    Font m_font = null;
    String m_title;
    double gWidth;
    double gHeight;
    double topLine;
    double bottomLine;
    double headLine;
    double[] hlinesY;
    double cutRX;
    double halfX;
    double wakuh;
    int Koma;
    int row = 0;
    HashMap pageMap = null;

    PrintProgress(sbedit pp) {
        this.parent = pp;
    }

    public void selectFont() {
    }

    public void exec(LinkedList p, String p_title) {
        PrintService defaultService;
        PrintService[] services;
        PrintService service;
        this.pageMap = new HashMap(p.size());
        this.model = p;
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        this.m_title = p_title;
        aset.add(new JobName(this.m_title, null));
        if (this.column == null) {
            System.out.println("progress.xml\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u3092\u4f7f\u7528");
            this.column = new LinkedList();
            this.column.addLast(new columnData("\u30ec\u30a4\u30a2\u30a6\u30c8", 5.1));
            this.column.addLast(new columnData("\u4f5c\u753b", 20.91));
            this.column.addLast(new columnData("\u30c8\u30ec\u30b9", 36.73));
            this.column.addLast(new columnData("\u4ed5\u4e0a\u3052", 52.55));
            this.column.addLast(new columnData("\u80cc\u666f", 68.37));
            this.column.addLast(new columnData("\u64ae\u5f71", 84.183));
            double add = 15.816666666666668;
            this.halfX = add / 2.0;
        }
        if ((service = ServiceUI.printDialog(null, 200, 200, services = PrintServiceLookup.lookupPrintServices(flavor, aset), defaultService = PrintServiceLookup.lookupDefaultPrintService(), flavor, aset)) != null) {
            DocPrintJob pj = service.createPrintJob();
            try {
                SimpleDoc doc = new SimpleDoc(this, flavor, null);
                PrintJobAdapter listener = new PrintJobAdapter(){

                    @Override
                    public void printDataTransferCompleted(PrintJobEvent e) {
                        System.out.println("\u5370\u5237\u5b8c\u4e86");
                    }
                };
                pj.addPrintJobListener(listener);
                pj.print(doc, aset);
            }
            catch (PrintException e) {
                System.err.println(e);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            g2d.setColor(Color.black);
            if (this.m_font != null) {
                g2d.setFont(this.m_font);
            }
            this.gWidth = pf.getImageableWidth();
            this.gHeight = pf.getImageableHeight();
            FontMetrics fm = g2d.getFontMetrics();
            int h = fm.getHeight();
            this.wakuh = h * 2;
            int bun = (int)(this.gHeight / this.wakuh);
            this.hlinesY = new double[bun];
            this.bottomLine = this.wakuh * (double)bun;
            this.topLine = (this.gHeight - this.bottomLine) / 2.0;
            if (this.topLine < (double)h) {
                this.topLine = h;
            }
            this.headLine = this.topLine + (double)h;
            int i = 0;
            while (i < bun) {
                this.hlinesY[i] = (double)(i + 1) * this.wakuh + this.headLine;
                ++i;
            }
            this.Koma = bun;
            this.bottomLine += this.headLine;
            this.cutRX = this.gWidth * 0.051;
            this.row = 0;
            this.printPage(g2d, pageIndex);
            this.printFrame(g2d, pageIndex);
            return 0;
        }
        if (this.Koma * pageIndex <= this.model.size()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            g2d.setColor(Color.black);
            if (this.m_font != null) {
                g2d.setFont(this.m_font);
            }
            this.printPage(g2d, pageIndex);
            this.printFrame(g2d, pageIndex);
            return 0;
        }
        return 1;
    }

    private void printFrame(Graphics2D g2d, int pageIndex) {
        g2d.setColor(Color.black);
        FontMetrics fm = g2d.getFontMetrics();
        int h = fm.getHeight();
        int fontLine = (int)(this.headLine - (double)(fm.getDescent() + fm.getLeading()));
        g2d.drawString("\u300c" + this.m_title + "\u300d\u3000" + (pageIndex + 1) + "\u30da\u30fc\u30b8", 0, h);
        g2d.drawLine(0, (int)this.topLine, 0, (int)this.bottomLine);
        g2d.drawLine((int)this.gWidth, (int)this.topLine, (int)this.gWidth, (int)this.bottomLine);
        g2d.drawString(" C.", 1, fontLine);
        int i = 0;
        while (i < this.column.size()) {
            columnData dat = (columnData)this.column.get(i);
            int x = (int)(this.gWidth * dat.len / 100.0);
            g2d.drawLine(x, (int)this.topLine, x, (int)this.bottomLine);
            g2d.drawString(dat.name, x + 1, fontLine);
            ++i;
        }
        g2d.drawLine(0, (int)this.topLine, (int)this.gWidth, (int)this.topLine);
        g2d.drawLine(0, (int)this.headLine, (int)this.gWidth, (int)this.headLine);
        i = 0;
        while (i < this.hlinesY.length) {
            g2d.drawLine(0, (int)this.hlinesY[i], (int)this.gWidth, (int)this.hlinesY[i]);
            ++i;
        }
        g2d.drawLine(0, (int)this.bottomLine - 1, (int)this.gWidth, (int)this.bottomLine - 1);
        Stroke saves = g2d.getStroke();
        float[] dash = new float[]{2.0f, 1.0f};
        BasicStroke dashed = new BasicStroke(0.5f, 0, 0, 10.0f, dash, 0.0f);
        g2d.setStroke(dashed);
        int i2 = 0;
        while (i2 < this.column.size()) {
            columnData dat = (columnData)this.column.get(i2);
            int x = (int)(this.gWidth * (dat.len + this.halfX) / 100.0);
            g2d.drawLine(x, (int)this.headLine, x, (int)this.bottomLine);
            ++i2;
        }
        g2d.setStroke(saves);
    }

    private void printPage(Graphics2D g2d, int pageIndex) {
        Integer ipageIndex = pageIndex;
        Integer irow = (Integer)this.pageMap.get(ipageIndex);
        if (irow == null) {
            irow = new Integer(this.row);
            this.pageMap.put(ipageIndex, irow);
        } else {
            this.row = irow;
        }
        FontMetrics fm = g2d.getFontMetrics();
        double halfheight = this.wakuh / 2.0 - (double)fm.getHeight();
        if (halfheight < 0.0) {
            halfheight = 0.0;
        }
        if (this.row >= this.model.size()) {
            return;
        }
        String text = (String)this.model.get(this.row);
        this.printTextArea(g2d, (int)(this.headLine + halfheight), 0, (int)this.cutRX, (int)(this.wakuh - halfheight), text);
        ++this.row;
        int i = 0;
        while (i < this.Koma - 1) {
            if (this.row >= this.model.size()) break;
            text = (String)this.model.get(this.row);
            this.printTextArea(g2d, (int)(this.hlinesY[i] + halfheight), 0, (int)this.cutRX, (int)(this.wakuh - halfheight), text);
            ++i;
            ++this.row;
        }
    }

    private void printTextArea(Graphics2D g2d, int py, int px, int width, int hight, String text) {
        if (text == null) {
            return;
        }
        int len = text.length();
        if (len <= 0) {
            return;
        }
        FontRenderContext fcontext = g2d.getFontRenderContext();
        AttributedCharacterIterator iter = new AttributedString(text).getIterator();
        LineBreakMeasurer lbreak = new LineBreakMeasurer(iter, fcontext);
        g2d.setColor(Color.black);
        float x = px;
        float y = py;
        if (lbreak != null) {
            lbreak.setPosition(0);
            while (lbreak.getPosition() < len) {
                TextLayout layout = lbreak.nextLayout(width);
                if (layout == null) break;
                layout.draw(g2d, x, y += layout.getAscent() + layout.getDescent());
            }
        }
    }

    public void setDocument(Document pdoc) throws Exception {
        Element tbltag;
        NodeList list;
        if (pdoc == null) {
            return;
        }
        Element root = pdoc.getDocumentElement();
        try {
            list = root.getElementsByTagName("table");
            tbltag = (Element)list.item(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        list = tbltag.getElementsByTagName("tr");
        int lis = list.getLength();
        double add = 94.9 / (double)lis;
        this.column = new LinkedList();
        int i = 0;
        while (i < lis) {
            Element element = (Element)list.item(i);
            String value = element.getFirstChild().getNodeValue();
            double len = 5.1 + add * (double)i;
            this.column.addLast(new columnData(value, len));
            ++i;
        }
        this.halfX = add / 2.0;
    }

    class columnData {
        String name;
        double len;

        public columnData(String p1, double p2) {
            this.name = p1;
            this.len = p2;
        }
    }
}

