/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.DefaultListModel;
import org.apache.commons.lang.StringUtils;

public class Nazoh {
    private SBDTableModel tbl;

    public Nazoh(SBDTableModel p_tbl, DefaultListModel p_bookmarks) {
        this.tbl = p_tbl;
    }

    public void read(String filename) throws Exception {
        String line;
        BufferedReader bf = new BufferedReader(new FileReader(filename));
        boolean cutnum = true;
        while ((line = bf.readLine()) != null) {
            NAZ_LINE naz_line;
            if (line.length() <= 0 || (naz_line = this.splitLine(line)) == null) continue;
            System.out.println("NAZLINE=" + naz_line);
            switch (naz_line.type) {
                // Empty switch
            }
        }
    }

    NAZ_LINE splitLine(String line) {
        String[] kv = StringUtils.split((String)line, (char)'\t');
        System.out.println(line);
        if (kv.length <= 0) {
            return null;
        }
        NAZ_LINE ret = new NAZ_LINE();
        if (kv.length >= 1) {
            ret.key = kv[0];
        }
        if (kv.length >= 2) {
            ret.value = kv[1];
        }
        System.out.println(String.valueOf(ret.key) + ":" + ret.value);
        return ret;
    }

    private void addRow(int row, StringBuilder sb_desc, StringBuilder sb_words, String bmk) {
        if (sb_desc == null && sb_words == null) {
            return;
        }
        Object[] rec = new Object[7];
        rec[0] = new Float(row);
        rec[1] = "";
        rec[2] = sb_desc != null ? sb_desc.toString() : "";
        rec[3] = sb_words != null ? sb_words.toString() : "";
        rec[4] = "";
        rec[6] = sbedit.makeKeyUID();
        this.tbl.addRow(rec);
    }

    public void write(String filename) throws Exception {
        StringBuilder sb = new StringBuilder();
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        int i = this.tbl.getRowCount() - 1;
        while (i >= 0) {
            String desc = this.tbl.getValueAt(i, 2).toString();
            String words = this.tbl.getValueAt(i, 3).toString();
            sb.insert(0, "\r\n");
            sb.insert(0, words);
            sb.insert(0, "\r\n");
            sb.insert(0, desc);
            --i;
        }
        try {
            try {
                writer.write(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            writer.flush();
            writer.close();
            sb = null;
        }
    }

    class NAZ_LINE {
        NZ_TYPE type = NZ_TYPE.OTHER;
        String key = "";
        String value = "";
    }

    static enum NZ_TYPE {
        PARAMS,
        PARAMSEND,
        DATA,
        KOMAINFO,
        KOMAINFOEND,
        END,
        KEYVALUE,
        OTHER;

    }
}

