/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class FontChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected Font resultFont;
    protected String resultName;
    protected int resultSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected String displayText = "ABC \u3044\u308d\u306f\u65e5\u672c\u8a9e 123";
    protected String[] fontList;
    protected List fNameChoice;
    protected List fSizeChoice;
    Checkbox bold;
    Checkbox italic;
    protected String[] fontSizes = new String[]{"8", "10", "11", "12", "14", "16", "18", "20", "24", "30", "36", "40", "48", "60", "72"};
    protected static final int DEFAULT_SIZE = 4;
    protected JLabel previewArea;

    public FontChooser(Frame f) {
        super(f, "Font Chooser", true);
        Container cp = this.getContentPane();
        Panel top = new Panel();
        top.setLayout(new FlowLayout());
        this.fNameChoice = new List(8);
        top.add(this.fNameChoice);
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < this.fontList.length) {
            this.fNameChoice.add(this.fontList[i]);
            ++i;
        }
        this.fNameChoice.select(0);
        this.fSizeChoice = new List(8);
        top.add(this.fSizeChoice);
        i = 0;
        while (i < this.fontSizes.length) {
            this.fSizeChoice.add(this.fontSizes[i]);
            ++i;
        }
        this.fSizeChoice.select(4);
        cp.add("North", top);
        Panel attrs = new Panel();
        top.add(attrs);
        attrs.setLayout(new GridLayout(0, 1));
        this.bold = new Checkbox("Bold", false);
        attrs.add(this.bold);
        this.italic = new Checkbox("Italic", false);
        attrs.add(this.italic);
        this.previewArea = new JLabel(this.displayText, 0);
        this.previewArea.setSize(200, 50);
        cp.add("Center", this.previewArea);
        Panel bot = new Panel();
        JButton okButton = new JButton("OK");
        bot.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.previewFont();
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        JButton pvButton = new JButton("Preview");
        bot.add(pvButton);
        pvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.previewFont();
            }
        });
        JButton canButton = new JButton("Cancel");
        bot.add(canButton);
        canButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.resultFont = null;
                FontChooser.this.resultName = null;
                FontChooser.this.resultSize = 0;
                FontChooser.this.isBold = false;
                FontChooser.this.isItalic = false;
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        cp.add("South", bot);
        this.previewFont();
        this.pack();
        this.setLocation(100, 100);
    }

    protected void previewFont() {
        this.resultName = this.fNameChoice.getSelectedItem();
        String resultSizeName = this.fSizeChoice.getSelectedItem();
        int resultSize = Integer.parseInt(resultSizeName);
        this.isBold = this.bold.getState();
        this.isItalic = this.italic.getState();
        int attrs = 0;
        if (this.isBold) {
            attrs = 1;
        }
        if (this.isItalic) {
            attrs |= 2;
        }
        this.resultFont = new Font(this.resultName, attrs, resultSize);
        this.previewArea.setFont(this.resultFont);
        this.pack();
    }

    public String getSelectedName() {
        return this.resultName;
    }

    public int getSelectedSize() {
        return this.resultSize;
    }

    public Font getSelectedFont() {
        return this.resultFont;
    }
}

