/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class AlphaColor
extends Color {
    protected int alpha;

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public AlphaColor(int red, int green, int blue, int alpha) {
        super(red, green, blue);
        this.alpha = alpha;
    }

    public AlphaColor(Color color, int alpha) {
        this(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public AlphaColor(InStream in) throws IOException {
        super(in);
        this.alpha = in.readUI8();
    }

    @Override
    public void write(OutStream out) throws IOException {
        this.writeRGB(out);
        out.writeUI8(this.alpha);
    }

    @Override
    public void writeWithAlpha(OutStream out) throws IOException {
        this.write(out);
    }

    public boolean equals(AlphaColor color) {
        return super.equals(color) && this.alpha == color.getAlpha();
    }

    @Override
    public String toString() {
        return "RGBA(" + this.red + "," + this.green + "," + this.blue + "," + this.alpha + ")";
    }
}

