/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Actions;
import com.anotherbigidea.flash.movie.Instance;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Placement;
import com.anotherbigidea.flash.movie.Sound;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.TimeLine;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.SoundInfo;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Frame {
    protected int frameNumber;
    protected String label;
    protected Vector placements = new Vector();
    protected boolean stop;
    protected TimeLine timeline;
    protected Actions actions;
    protected SoundStreamHead soundHeader;
    protected byte[] soundData;
    protected Sound soundToStart;
    protected int customTag = -1;
    protected byte[] customTagData;
    protected boolean mAnchor;

    protected Frame(int number, TimeLine timeline) {
        this.frameNumber = number;
        this.timeline = timeline;
    }

    public SoundStreamHead getSoundHeader() {
        return this.soundHeader;
    }

    public void setSoundHeader(SoundStreamHead header) {
        this.soundHeader = header;
    }

    public byte[] getSoundData() {
        return this.soundData;
    }

    public void setSoundData(byte[] data) {
        this.soundData = data;
    }

    public boolean isAnchor() {
        return this.mAnchor;
    }

    public void setAnchor(boolean isAnchor) {
        this.mAnchor = isAnchor;
    }

    public void setCustomTag(int tagId, byte[] tagData) {
        this.customTag = tagId;
        this.customTagData = tagData;
    }

    public int startSound(Sound soundToStart, int framesPerSec) {
        this.soundToStart = soundToStart;
        int freq = soundToStart.getFrequency();
        switch (freq) {
            case 0: {
                freq = 5500;
                break;
            }
            case 1: {
                freq = 11000;
                break;
            }
            case 2: {
                freq = 22000;
                break;
            }
            case 3: {
                freq = 44000;
                break;
            }
            default: {
                freq = 22000;
            }
        }
        int samples = soundToStart.getSampleCount();
        int length = samples / freq;
        return length * framesPerSec;
    }

    public Actions getActions() {
        return this.actions;
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    public Actions actions(int flashVersion) {
        this.actions = new Actions(0, flashVersion);
        return this.actions;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public Placement[] getPlacements() {
        Object[] p = new Placement[this.placements.size()];
        this.placements.copyInto(p);
        return p;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void stop() {
        this.stop = true;
    }

    public Instance placeSymbol(Symbol symbol, int x, int y) {
        return this.placeSymbol(symbol, new Transform(x, y), null, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform matrix, AlphaTransform cxform) {
        return this.placeSymbol(symbol, matrix, cxform, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform matrix, AlphaTransform cxform, int ratio, int clipDepth) {
        int depth = this.timeline.getAvailableDepth();
        Instance inst = new Instance(symbol, depth);
        this.timeline.setAvailableDepth(depth + 1);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, null, ratio, clipDepth, this.frameNumber, false, false, null);
        this.placements.add(placement);
        return inst;
    }

    public Instance replaceSymbol(Symbol symbol, int depth, Transform matrix, AlphaTransform cxform, int ratio, int clipDepth) {
        Instance inst = new Instance(symbol, depth);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, null, ratio, clipDepth, this.frameNumber, false, true, null);
        this.placements.add(placement);
        return inst;
    }

    public void undefineSymbol(Symbol symbol) {
        this.placements.add(new Placement(symbol));
    }

    public Instance placeMovieClip(Symbol symbol, Transform matrix, AlphaTransform cxform, String name, Actions[] clipActions) {
        int depth = this.timeline.getAvailableDepth();
        Instance inst = new Instance(symbol, depth);
        this.timeline.setAvailableDepth(depth + 1);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, name, -1, -1, this.frameNumber, false, false, clipActions);
        this.placements.add(placement);
        return inst;
    }

    public Instance replaceMovieClip(Symbol symbol, int depth, Transform matrix, AlphaTransform cxform, String name, Actions[] clipActions) {
        Instance inst = new Instance(symbol, depth);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, name, -1, -1, this.frameNumber, false, true, clipActions);
        this.placements.add(placement);
        return inst;
    }

    public void remove(Instance instance) {
        this.placements.add(new Placement(instance, this.frameNumber));
    }

    public void alter(Instance instance, int x, int y) {
        this.alter(instance, new Transform(x, y), null, -1);
    }

    public void alter(Instance instance, Transform matrix, AlphaTransform cxform) {
        this.alter(instance, matrix, cxform, -1);
    }

    public void alter(Instance instance, Transform matrix, AlphaTransform cxform, int ratio) {
        Placement placement = new Placement(instance, matrix, cxform, null, ratio, -1, this.frameNumber, true, false, null);
        this.placements.add(placement);
    }

    protected void flushDefinitions(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        Enumeration enum1 = this.placements.elements();
        while (enum1.hasMoreElements()) {
            Placement placement = (Placement)enum1.nextElement();
            placement.flushDefinitions(movie, timelineWriter, definitionWriter);
        }
    }

    protected void write(Movie movie, SWFTagTypes movieTagWriter, SWFTagTypes timelineTagWriter) throws IOException {
        if (this.customTag >= 0) {
            timelineTagWriter.tag(this.customTag, false, this.customTagData);
        }
        if (this.actions != null) {
            SWFActions acts = timelineTagWriter.tagDoAction();
            acts.start(0);
            acts.blob(this.actions.bytes);
            acts.done();
        }
        if (this.stop) {
            SWFActions actions = timelineTagWriter.tagDoAction();
            actions.start(0);
            actions.stop();
            actions.end();
            actions.done();
        }
        if (this.soundHeader != null) {
            this.soundHeader.write(timelineTagWriter);
        }
        if (this.soundData != null) {
            timelineTagWriter.tagSoundStreamBlock(this.soundData);
        }
        if (this.soundToStart != null) {
            timelineTagWriter.tagStartSound(this.soundToStart.define(movie, movieTagWriter, timelineTagWriter), new SoundInfo(true, false, null, -1, -1, 0));
        }
        Enumeration enum1 = this.placements.elements();
        while (enum1.hasMoreElements()) {
            Placement placement = (Placement)enum1.nextElement();
            placement.write(movie, movieTagWriter, timelineTagWriter);
        }
        if (this.label != null) {
            timelineTagWriter.tagFrameLabel(this.label, this.mAnchor);
        }
        timelineTagWriter.tagShowFrame();
    }
}

