/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class WzMemo {
    private SBDTableModel tbl;
    private DefaultListModel bookmarks;
    private static final String desc_checker = "\u25a1\u25a0\u25cb\u25cf\u25ce\u00a7";
    private static final String word_checker = "\u300c\u300e\uff08\uff3b\uff5b([{\uff62";
    private static final String word_checker2 = "\u300d\u300f\uff09\uff3d\uff5d)]}";
    private static final String change_checker = "\u00d7\u203b";
    private static final double WORD_PASE = 0.15;
    private static final int WORD_CUT = 27;

    public WzMemo(SBDTableModel p_tbl, DefaultListModel p_bookmarks) {
        this.tbl = p_tbl;
        this.bookmarks = p_bookmarks;
    }

    public void write(String filename) throws Exception {
        StringBuilder sb = new StringBuilder();
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        int mode = -1;
        mode = filename.indexOf(".snr") > 0 || filename.indexOf(".SNR") > 0 ? 0 : 1;
        if (this.bookmarks == null || this.bookmarks.size() <= 0) {
            int i = this.tbl.getRowCount() - 1;
            while (i >= 0) {
                String desc = this.tbl.getValueAt(i, 2).toString();
                String words = this.tbl.getValueAt(i, 3).toString();
                sb.insert(0, "\r\n");
                sb.insert(0, words);
                sb.insert(0, "\r\n");
                sb.insert(0, desc);
                --i;
            }
            sb.insert(0, "\r\n");
            sb.insert(0, this.tbl.title);
            sb.insert(0, "\u25a0");
            if (mode == 1) {
                sb.insert(0, "\r\n");
                sb.insert(0, this.tbl.title);
                sb.insert(0, ".");
            }
        } else {
            int line = this.tbl.getRowCount() - 1;
            int i = this.bookmarks.getSize() - 1;
            while (i >= 0) {
                BookmarkItem item = (BookmarkItem)this.bookmarks.getElementAt(i);
                String key = this.deleteDot(item.key);
                String point = item.point;
                while (line >= 0) {
                    String cmpkey = this.tbl.getValueAt(line, 6).toString();
                    if (cmpkey.equalsIgnoreCase(point)) break;
                    String desc = this.tbl.getValueAt(line, 2).toString();
                    String words = this.tbl.getValueAt(line, 3).toString();
                    if (words != null && words.length() > 0) {
                        sb.insert(0, "\r\n");
                        sb.insert(0, this.addKakko(this.deleteCRLF(words)));
                    }
                    if (desc != null && desc.length() > 0) {
                        sb.insert(0, "\r\n");
                        sb.insert(0, this.deleteCRLF(desc));
                    }
                    --line;
                }
                sb.insert(0, "\r\n");
                sb.insert(0, key);
                sb.insert(0, "\u25a0");
                if (mode == 1) {
                    sb.insert(0, "\r\n");
                    sb.insert(0, key);
                    sb.insert(0, ".");
                }
                --i;
            }
            while (line >= 0) {
                String desc = this.tbl.getValueAt(line, 2).toString();
                String words = this.tbl.getValueAt(line, 3).toString();
                if (words != null && words.length() > 0) {
                    sb.insert(0, "\r\n");
                    sb.insert(0, this.addKakko(this.deleteCRLF(words)));
                }
                if (desc != null && desc.length() > 0) {
                    sb.insert(0, "\r\n");
                    sb.insert(0, this.deleteCRLF(desc));
                }
                --line;
            }
            sb.insert(0, "\r\n");
            sb.insert(0, this.tbl.title);
            sb.insert(0, "\u25a0");
            if (mode == 1) {
                sb.insert(0, "\r\n");
                sb.insert(0, this.tbl.title);
                sb.insert(0, ".");
            }
        }
        try {
            try {
                writer.write(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            writer.flush();
            writer.close();
            sb = null;
        }
    }

    private String deleteCRLF(String inp) {
        StringBuilder sb = new StringBuilder(inp);
        int i = sb.length() - 1;
        while (i >= 0) {
            char c = sb.charAt(i);
            if (Character.isISOControl(c)) {
                sb.deleteCharAt(i);
            }
            if (c == '\u3000') {
                sb.deleteCharAt(i);
            }
            --i;
        }
        return sb.toString();
    }

    private String addKakko(String inp) {
        StringBuilder sb = new StringBuilder(inp);
        if (sb.indexOf("\u300c") < 0) {
            sb.insert(0, "\u300c");
        }
        if (sb.indexOf("\u300d") < 0) {
            sb.append("\u300d");
        }
        return sb.toString();
    }

    private String deleteDot(String inp) {
        StringBuilder sb = new StringBuilder(inp);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c != '.' && !this.isScene(c)) break;
            sb.deleteCharAt(i);
            ++i;
        }
        return sb.toString();
    }

    public void read(String filename) throws Exception {
        String line;
        BufferedReader bf = new BufferedReader(new FileReader(filename));
        int cutnum = 1;
        int flg = -1;
        StringBuilder sb_words = null;
        StringBuilder sb_desc = null;
        String bmk = null;
        boolean flg_bmk = false;
        int mode = -1;
        mode = filename.indexOf(".snr") > 0 || filename.indexOf(".SNR") > 0 ? 0 : 1;
        while ((line = bf.readLine()) != null) {
            if (line.length() <= 0) continue;
            if (line.charAt(0) == '.') {
                bmk = line;
                flg_bmk = true;
                continue;
            }
            if (this.isScene(line) || this.isChange(line)) {
                bmk = line;
                flg_bmk = true;
                if (sb_desc != null || sb_words != null) {
                    if (flg_bmk) {
                        this.addRow(cutnum, sb_desc, sb_words, null);
                        flg_bmk = false;
                    } else {
                        this.addRow(cutnum, sb_desc, sb_words, bmk);
                        bmk = null;
                    }
                    sb_words = null;
                    ++cutnum;
                }
                sb_desc = new StringBuilder();
                sb_desc.append(line);
                flg = 6;
                continue;
            }
            if (!this.isWords(line)) {
                if (flg != 6) {
                    if (flg_bmk) {
                        this.addRow(cutnum, sb_desc, sb_words, null);
                        flg_bmk = false;
                    } else {
                        this.addRow(cutnum, sb_desc, sb_words, bmk);
                        bmk = null;
                    }
                    sb_words = null;
                    sb_desc = null;
                    ++cutnum;
                } else {
                    if (sb_desc == null) {
                        sb_desc = new StringBuilder();
                    }
                    sb_desc.append("\r\n");
                }
                if (sb_desc == null) {
                    sb_desc = new StringBuilder();
                }
                sb_desc.append(line);
                flg = 2;
                continue;
            }
            if (sb_words != null && sb_words.length() > 27) {
                if (flg_bmk) {
                    this.addRow(cutnum, sb_desc, sb_words, null);
                    flg_bmk = false;
                } else {
                    this.addRow(cutnum, sb_desc, sb_words, bmk);
                    bmk = null;
                }
                sb_words = null;
                ++cutnum;
            }
            if (flg == 2) {
                sb_words = new StringBuilder();
            } else if (flg == 3) {
                if (sb_words == null) {
                    sb_words = new StringBuilder();
                } else {
                    sb_words.append("\r\n");
                }
            } else {
                sb_words = new StringBuilder();
            }
            sb_words.append(line);
            flg = 3;
        }
        this.addRow(cutnum, sb_desc, sb_words, bmk);
    }

    private void addRow(int row, StringBuilder sb_desc, StringBuilder sb_words, String bmk) {
        if (sb_desc == null && sb_words == null) {
            return;
        }
        Object[] rec = new Object[7];
        rec[0] = new Float(row);
        rec[1] = "";
        rec[2] = sb_desc != null ? sb_desc.toString() : "";
        rec[3] = sb_words != null ? sb_words.toString() : "";
        rec[4] = "";
        rec[6] = sbedit.makeKeyUID();
        this.tbl.addRow(rec);
        if (bmk != null) {
            BookmarkItem itm = new BookmarkItem(this.deleteDot(bmk), (String)rec[6]);
            this.bookmarks.addElement(itm);
        }
    }

    private boolean isScene(String line) {
        return desc_checker.indexOf(line.charAt(0)) >= 0;
    }

    private boolean isScene(char c) {
        return desc_checker.indexOf(c) >= 0;
    }

    private boolean isWords(String line) {
        int i = 0;
        while (i < word_checker.length()) {
            if (line.indexOf(word_checker.charAt(i)) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isChange(String line) {
        int i = 0;
        while (i < change_checker.length()) {
            if (line.indexOf(change_checker.charAt(i)) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void calcTimes() {
        int notcut = 0;
        int nolength = 0;
        int i = 0;
        while (i < this.tbl.getRowCount()) {
            Object o = this.tbl.getValueAt(i, 4);
            if (o == null || !o.getClass().getName().equalsIgnoreCase("java.lang.Double")) {
                String words = (String)this.tbl.getValueAt(i, 3);
                if (words != null && words.length() > 2) {
                    this.tbl.setValueAt(this.calcWordTime(words), i, 4);
                } else {
                    String desc = (String)this.tbl.getValueAt(i, 2);
                    if (desc != null) {
                        nolength += desc.length();
                    }
                    ++notcut;
                }
            }
            ++i;
        }
        double totalsec = notcut * 4;
        double charsec = totalsec / (double)nolength;
        System.out.println("notcut=" + notcut + " nolength=" + nolength + " totalsec=" + totalsec + " charsec=" + charsec);
        int i2 = 0;
        while (i2 < this.tbl.getRowCount()) {
            String desc;
            Object o = this.tbl.getValueAt(i2, 4);
            if (!(o != null && o.getClass().getName().equalsIgnoreCase("java.lang.Double") || (desc = (String)this.tbl.getValueAt(i2, 2)) == null || desc.length() <= 0)) {
                double mysec = (int)((double)desc.length() * charsec * 10.0);
                mysec += 0.5;
                this.tbl.setValueAt(new Double(mysec /= 10.0), i2, 4);
            }
            ++i2;
        }
    }

    private Double calcWordTime(StringBuilder sb) {
        return this.calcWordTime(sb.toString());
    }

    private Double calcWordTime(String words) {
        double d = (double)this.countWords(words) * 0.15 * 10.0;
        double iv = (int)(d + 0.5);
        double ret = iv / 10.0;
        int i = 0;
        while ((i = words.indexOf("\u2026", i)) > 0) {
            ret += 1.5;
            System.out.println("i=" + i);
            ++i;
        }
        i = 0;
        while ((i = words.indexOf("\u30fc", i)) > 0) {
            ret += 1.5;
            System.out.println("i=" + i);
            ++i;
        }
        return new Double(ret);
    }

    private int countWords(String words) {
        System.out.println("countWords." + words);
        int ret = 0;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(words.getBytes());
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            String line = lnr.readLine();
            while (line != null) {
                ret += this.countWordsLine(line);
                line = lnr.readLine();
            }
            ((InputStream)is).close();
            lnr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private int countWordsLine(String words) {
        if (words == null) {
            return -1;
        }
        words = this.deleteCRLF(words);
        int ret = words.length();
        int point = 0;
        if (!this.isWords(words)) {
            return ret;
        }
        int i = 0;
        while (i < words.length()) {
            --ret;
            if (this.isKakko(words.charAt(i))) break;
            ++i;
        }
        if (i >= words.length()) {
            return ret;
        }
        point = i + 1;
        String sub = words.substring(point);
        int i2 = 0;
        while (i2 < sub.length()) {
            if (this.isKakko(sub.charAt(i2))) {
                --ret;
            }
            ++i2;
        }
        return ret;
    }

    private boolean isKakko(char c) {
        if (word_checker.indexOf(c) >= 0) {
            return true;
        }
        return word_checker2.indexOf(c) >= 0;
    }

    private boolean isKakko2(char c) {
        return word_checker.indexOf(c) >= 0;
    }

    public ArrayList<Integer> checkWords() {
        CharacterTableModel charList = this.tbl.getCharList();
        Vector<Vector> v = charList.getDataVector();
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int i = 0;
        while (i < this.tbl.getRowCount()) {
            String words = (String)this.tbl.getValueAt(i, 3);
            if (words != null && words.length() > 0) {
                if (!this.isWords(words)) {
                    this.tbl.setValueAt(this.addKakko(words), i, 3);
                    ret.add(i);
                } else {
                    String name = this.getName(words);
                    if (name != null && name.length() > 0) {
                        System.out.println("\u767b\u5834\u4eba\u7269=" + name);
                        boolean newflg = true;
                        Iterator<Vector> it = v.iterator();
                        while (it.hasNext()) {
                            try {
                                Vector vv = it.next();
                                String n = (String)vv.get(0);
                                System.out.println("VV=" + vv + " name=" + n);
                                if (n.equalsIgnoreCase(name)) {
                                    System.out.println("\u91cd\u8907" + name);
                                    newflg = false;
                                    break;
                                }
                                System.out.println("\u521d\u767b\u5834?" + name);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.out.println("\u4f8b\u5916\uff1a" + name);
                            }
                        }
                        if (newflg) {
                            Object[] rec = new Object[7];
                            rec[0] = name;
                            rec[2] = "S";
                            rec[3] = "A";
                            rec[4] = "D";
                            rec[5] = "I";
                            rec[6] = sbedit.makeKeyUID();
                            System.out.println("rec=" + rec.length);
                            charList.addRow(rec);
                        }
                    } else {
                        ret.add(i);
                    }
                }
            }
            ++i;
        }
        System.out.println("\u4eba\u6570\uff1d" + charList.getRowCount());
        return ret;
    }

    private String getName(String words) {
        StringBuilder ret = new StringBuilder();
        boolean flg = false;
        int i = 0;
        while (i < words.length()) {
            if (Character.isISOControl(words.charAt(i))) break;
            if (this.isKakko2(words.charAt(i))) {
                flg = true;
                break;
            }
            ret.append(words.charAt(i));
            ++i;
        }
        if (!flg) {
            return null;
        }
        String ret2 = ret.toString();
        int koe = ret2.indexOf("\u306e\u58f0");
        if (koe > 0) {
            ret2 = ret2.substring(0, koe);
        }
        return ret2.trim();
    }
}

