/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;

public class PrintSBD
implements Printable {
    sbedit parent;
    SBDTableModel model;
    Font m_font = null;
    double gWidth;
    double gHeight;
    double topLine;
    double bottomLine;
    double headLine;
    double[] hlinesY;
    double cutX;
    double picX;
    double expX;
    double wordX;
    double secX;
    double wakuh;
    int Koma;

    PrintSBD(sbedit pp) {
        this.parent = pp;
    }

    public void selectFont(Font font) {
        this.m_font = font;
    }

    public void exec(SBDTableModel p) {
        this.model = p;
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new JobName(this.model.getTitle(), null));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, aset);
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService service = ServiceUI.printDialog(null, 200, 200, services, defaultService, flavor, aset);
        if (service != null) {
            DocPrintJob pj = service.createPrintJob();
            try {
                SimpleDoc doc = new SimpleDoc(this, flavor, null);
                PrintJobAdapter listener = new PrintJobAdapter(){

                    @Override
                    public void printDataTransferCompleted(PrintJobEvent e) {
                        System.out.println("\u5370\u5237\u5b8c\u4e86");
                    }
                };
                pj.addPrintJobListener(listener);
                pj.print(doc, aset);
            }
            catch (PrintException e) {
                System.err.println(e);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            System.out.println("\u6700\u521d\u306e\u30da\u30fc\u30b8");
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            g2d.setColor(Color.black);
            if (this.m_font != null) {
                g2d.setFont(this.m_font);
            }
            this.gWidth = pf.getImageableWidth();
            this.gHeight = pf.getImageableHeight();
            FontMetrics fm = g2d.getFontMetrics();
            int h = fm.getHeight();
            this.wakuh = this.gWidth * 0.25875;
            int bun = (int)(this.gHeight / this.wakuh);
            this.hlinesY = new double[bun];
            this.bottomLine = this.wakuh * (double)bun;
            this.topLine = (this.gHeight - this.bottomLine) / 2.0;
            if (this.topLine < (double)h) {
                this.topLine = h;
            }
            this.headLine = this.topLine + (double)h;
            int i = 0;
            while (i < bun) {
                this.hlinesY[i] = (double)(i + 1) * this.wakuh + this.headLine;
                ++i;
            }
            this.Koma = bun;
            this.bottomLine += this.headLine;
            this.secX = this.gWidth - this.gWidth * 0.051;
            this.wordX = this.gWidth - this.gWidth * 0.102;
            this.cutX = this.gWidth * 0.051;
            this.picX = this.gWidth * 0.396;
            this.expX = this.gWidth * 0.6629999999999999;
            this.printPage(g2d, pageIndex);
            this.printFrame(g2d, pageIndex);
            return 0;
        }
        if (this.Koma * pageIndex <= this.model.getRowCount()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            g2d.setColor(Color.black);
            if (this.m_font != null) {
                g2d.setFont(this.m_font);
            }
            this.printPage(g2d, pageIndex);
            this.printFrame(g2d, pageIndex);
            return 0;
        }
        return 1;
    }

    private void printFrame(Graphics2D g2d, int pageIndex) {
        g2d.setColor(Color.black);
        FontMetrics fm = g2d.getFontMetrics();
        int h = fm.getHeight();
        int fontLine = (int)(this.headLine - (double)(fm.getDescent() + fm.getLeading()));
        g2d.drawString("\u300c" + this.model.getTitle() + "\u300d\u3000" + (pageIndex + 1) + "\u30da\u30fc\u30b8", 0, h);
        g2d.drawLine(0, (int)this.topLine, 0, (int)this.bottomLine);
        g2d.drawLine((int)this.gWidth, (int)this.topLine, (int)this.gWidth, (int)this.bottomLine);
        g2d.drawLine((int)this.secX, (int)this.topLine, (int)this.secX, (int)this.bottomLine);
        g2d.drawString(" \u8a08", (int)this.secX, fontLine);
        g2d.drawLine((int)this.wordX, (int)this.topLine, (int)this.wordX, (int)this.bottomLine);
        g2d.drawString(" \u79d2", (int)this.wordX, fontLine);
        g2d.drawLine((int)this.cutX, (int)this.topLine, (int)this.cutX, (int)this.bottomLine);
        g2d.drawString(" C.", 0, fontLine);
        g2d.drawLine((int)this.picX, (int)this.topLine, (int)this.picX, (int)this.bottomLine);
        g2d.drawString("\u3000\u753b\u3000\u9762", (int)this.cutX, fontLine);
        g2d.drawLine((int)this.expX, (int)this.topLine, (int)this.expX, (int)this.bottomLine);
        g2d.drawString("\u3000\u5185\u3000\u5bb9", (int)this.picX, fontLine);
        g2d.drawString("\u3000\u97f3\u3000\u58f0", (int)this.expX, fontLine);
        g2d.drawLine(0, (int)this.topLine, (int)this.gWidth, (int)this.topLine);
        g2d.drawLine(0, (int)this.headLine, (int)this.gWidth, (int)this.headLine);
        int i = 0;
        while (i < this.hlinesY.length) {
            g2d.drawLine(0, (int)this.hlinesY[i], (int)this.gWidth, (int)this.hlinesY[i]);
            ++i;
        }
        g2d.drawLine(0, (int)this.bottomLine - 1, (int)this.gWidth, (int)this.bottomLine - 1);
    }

    private void printPage(Graphics2D g2d, int pageIndex) {
        int row = pageIndex * this.Koma;
        FontMetrics fm = g2d.getFontMetrics();
        double halfheight = this.wakuh / 2.0 - (double)fm.getHeight();
        if (halfheight < 0.0) {
            halfheight = 0.0;
        }
        if (row >= this.model.getRowCount()) {
            return;
        }
        String text = this.model.getValueAt(row, 0).toString();
        if (text != null && text.length() > 0) {
            this.printTextArea(g2d, (int)(this.headLine + halfheight), 0, (int)this.cutX, (int)(this.wakuh - halfheight), text);
        }
        String fname = this.model.getImgNameAt(row);
        this.printImage(g2d, (int)this.headLine, fname);
        text = (String)this.model.getValueAt(row, 2);
        this.printTextArea(g2d, (int)this.headLine, (int)this.picX, (int)(this.expX - this.picX), (int)this.wakuh, text);
        text = (String)this.model.getValueAt(row, 3);
        this.printTextArea(g2d, (int)this.headLine, (int)this.expX, (int)(this.wordX - this.expX), (int)this.wakuh, text);
        this.printTextArea(g2d, (int)(this.headLine + halfheight), (int)this.wordX, (int)(this.secX - this.wordX), (int)(this.wakuh - halfheight), this.getSecText(row));
        this.printTextArea(g2d, (int)(this.headLine + halfheight), (int)this.secX, (int)(this.gWidth - this.secX), (int)(this.wakuh - halfheight), this.getTotalText(row));
        int i = 0;
        while (i < this.Koma - 1) {
            if (++row >= this.model.getRowCount()) break;
            text = this.model.getValueAt(row, 0).toString();
            if (text != null && text.length() > 0) {
                this.printTextArea(g2d, (int)(this.hlinesY[i] + halfheight), 0, (int)this.cutX, (int)(this.wakuh - halfheight), text);
            }
            fname = this.model.getImgNameAt(row);
            this.printImage(g2d, (int)this.hlinesY[i], fname);
            text = (String)this.model.getValueAt(row, 2);
            this.printTextArea(g2d, (int)this.hlinesY[i], (int)this.picX, (int)(this.expX - this.picX), (int)this.wakuh, text);
            text = (String)this.model.getValueAt(row, 3);
            this.printTextArea(g2d, (int)this.hlinesY[i], (int)this.expX, (int)(this.wordX - this.expX), (int)this.wakuh, text);
            this.printTextArea(g2d, (int)(this.hlinesY[i] + halfheight), (int)this.wordX, (int)(this.secX - this.wordX), (int)(this.wakuh - halfheight), this.getSecText(row));
            this.printTextArea(g2d, (int)(this.hlinesY[i] + halfheight), (int)this.secX, (int)(this.gWidth - this.secX), (int)(this.wakuh - halfheight), this.getTotalText(row));
            ++i;
        }
    }

    private String getSecText(int row) {
        Double dv;
        try {
            dv = new Double(this.model.getValueAt(row, 4).toString());
        }
        catch (Exception e) {
            return null;
        }
        if (dv >= 0.0) {
            int ss;
            double s = dv;
            if (s - (double)(ss = dv.intValue()) <= 0.0) {
                return String.valueOf(ss) + "\u79d2";
            }
            return String.valueOf(dv.toString()) + "\u79d2";
        }
        return null;
    }

    private String getTotalText(int row) {
        String koma;
        String sec;
        String str;
        block9: {
            try {
                str = this.model.getValueAt(row, 5).toString();
                System.out.println("Print \u5408\u8a08=" + str);
                if (str != null && str.length() > 0) break block9;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        int i = str.indexOf(43);
        if (i > 0) {
            sec = str.substring(0, i - 1);
            koma = " + " + str.substring(i + 1) + "\uff7a\uff8f";
        } else {
            sec = str;
            koma = "";
        }
        System.out.println("Print \u79d2=" + sec + " \u3053\u307e\uff1d" + koma);
        Double Fr = new Double(sec);
        if (Fr >= 60.0) {
            int ss;
            int m = Fr.intValue() / 60;
            double s = Fr - (double)(m * 60);
            if (s - (double)(ss = Fr.intValue() - m * 60) <= 0.0) {
                return String.valueOf(m) + "\u5206" + ss + "\u79d2" + koma;
            }
            return String.valueOf(m) + "\u5206" + s + "\u79d2" + koma;
        }
        if (Fr >= 0.0) {
            int ss;
            double s = Fr;
            if (s - (double)(ss = Fr.intValue()) <= 0.0) {
                return String.valueOf(ss) + "\u79d2" + koma;
            }
            return String.valueOf(s) + "\u79d2" + koma;
        }
        return null;
    }

    private void printImage(Graphics2D g2d, int y, String fname) {
        if (fname != null && fname.length() > 0) {
            try {
                File tmp = new File(fname);
                BufferedImage img = ImageIO.read(tmp.getAbsoluteFile());
                int iw = img.getWidth(this.parent);
                int ih = img.getHeight(this.parent);
                int count = 120;
                while ((iw < 0 || ih < 0) && count > 0) {
                    System.out.println("printIcon wait.iw=" + iw + " ih=" + ih);
                    Thread.sleep(500L);
                    iw = img.getWidth(this.parent);
                    ih = img.getHeight(this.parent);
                    --count;
                }
                if (count <= 0) {
                    System.out.println("\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557=" + fname);
                    return;
                }
                int width = (int)(this.picX - this.cutX);
                int height = (int)this.wakuh;
                ImageObserver observer = null;
                g2d.drawImage(img, (int)this.cutX, y, width, height, Color.white, observer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void printTextArea(Graphics2D g2d, int py, int px, int width, int hight, String text) {
        if (text == null) {
            return;
        }
        int len = text.length();
        if (len <= 0) {
            return;
        }
        FontRenderContext fcontext = g2d.getFontRenderContext();
        AttributedCharacterIterator iter = new AttributedString(text).getIterator();
        LineBreakMeasurer lbreak = new LineBreakMeasurer(iter, fcontext);
        g2d.setColor(Color.black);
        float x = px;
        float y = py;
        if (lbreak != null) {
            lbreak.setPosition(0);
            while (lbreak.getPosition() < len) {
                TextLayout layout = lbreak.nextLayout(width);
                if (layout == null) break;
                layout.draw(g2d, x, y += layout.getAscent() + layout.getDescent());
            }
        }
    }
}

