/*
 * Decompiled with CFR 0.152.
 */
import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.SwingUtilities;

public abstract class MakeiTextTemp
extends MakeTemplate {
    Font dfont;
    Font sfont;
    Hashtable<String, ImageReader> imageReaders;

    MakeiTextTemp(String p_filename, String p_path, SBDTableModel p_model, DialogProgress p_dlg, Font p_dfont, Font p_sfont, Hashtable<String, ImageReader> p_imageReaders) {
        super(p_filename, p_path, p_model, p_dlg);
        this.dfont = p_dfont;
        this.sfont = p_sfont;
        this.imageReaders = p_imageReaders;
    }

    /*
     * Loose catch block
     */
    @Override
    void exec() {
        String blankimage = this.getBlankImageFileName();
        float iconhight = this.getBlankY();
        Document document = new Document();
        try {
            try {
                com.lowagie.text.Font fonts;
                com.lowagie.text.Font fontd;
                this.getWriter(document);
                BaseFont minchoF = BaseFont.createFont((String)"HeiseiMin-W3", (String)"UniJIS-UCS2-HW-H", (boolean)false);
                BaseFont gothF = BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)false);
                com.lowagie.text.Font font = new com.lowagie.text.Font(gothF, 12.0f);
                document.addAuthor(this.model.getAuthor());
                document.addTitle(this.model.getTitle());
                document.addCreator("\u7d75\u30b3\u30f3\u30c6\u30a8\u30c7\u30a3\u30bf by nekora");
                HeaderFooter header = new HeaderFooter(new Phrase(String.valueOf(this.model.getTitle()) + "     \u30da\u30fc\u30b8 ", font), new Phrase("."));
                header.setAlignment(0);
                document.setHeader(header);
                document.open();
                com.lowagie.text.Font fontk = new com.lowagie.text.Font(gothF, 10.0f);
                if (this.dfont == null) {
                    fontd = new com.lowagie.text.Font(minchoF, 9.0f);
                } else {
                    this.logger.info("dfont.size=" + this.dfont.getSize());
                    fontd = new com.lowagie.text.Font(minchoF, (float)this.dfont.getSize());
                }
                if (this.sfont == null) {
                    fonts = new com.lowagie.text.Font(minchoF, 9.0f);
                } else {
                    this.logger.info("sfont.size=" + this.sfont.getSize());
                    fonts = new com.lowagie.text.Font(minchoF, (float)this.sfont.getSize());
                }
                Table aTable = new Table(6);
                aTable.setDefaultHorizontalAlignment(1);
                aTable.setDefaultVerticalAlignment(5);
                aTable.setPadding(2.0f);
                this.setTableWidth(aTable);
                Cell[] col = new Cell[]{new Cell((Element)new Phrase("\uff76\uff6f\uff84", font)), new Cell((Element)new Phrase("\u753b\u9762", font)), new Cell((Element)new Phrase("\u8aac\u660e", font)), new Cell((Element)new Phrase("\u53f0\u8a5e", font)), new Cell((Element)new Phrase("\u79d2", font)), new Cell((Element)new Phrase("\u8a08", font))};
                int i = 0;
                while (i < col.length) {
                    aTable.addCell(col[i]);
                    ++i;
                }
                aTable.endHeaders();
                aTable.setCellsFitPage(true);
                i = 0;
                while (i < this.model.getRowCount()) {
                    int koma;
                    if (!this.lock.getState()) {
                        this.logger.warning("\u30e1\u30a4\u30f3\u30b9\u30ec\u30c3\u30c9\u304b\u3089\u306e\u6307\u793a\u3067iText\u51fa\u529b\u4e2d\u65ad");
                        break;
                    }
                    Cell cell = new Cell((Element)new Phrase(this.model.getValueAt(i, 0).toString(), fontk));
                    aTable.addCell(cell);
                    com.lowagie.text.Image img = null;
                    try {
                        String imgname = this.model.getImgNameAt(i);
                        this.logger.info(this.model.getImgNameAt(i));
                        if (imgname == null || imgname.length() <= 0) {
                            img = com.lowagie.text.Image.getInstance((String)blankimage);
                        } else {
                            img = com.lowagie.text.Image.getInstance((String)imgname);
                            this.logger.info("X=" + img.plainWidth() + " Y=" + img.plainHeight());
                            if (img.plainHeight() != iconhight) {
                                img = this.getScaledImage(imgname);
                                this.logger.info("CHANGE X=" + img.plainWidth() + " Y=" + img.plainHeight());
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.warning(e.toString());
                        img = com.lowagie.text.Image.getInstance((String)blankimage);
                    }
                    cell = new Cell((Element)img);
                    aTable.addCell(cell);
                    cell = new Cell((Element)new Phrase((String)this.model.getValueAt(i, 2), fontd));
                    cell.setHorizontalAlignment("Left");
                    cell.setVerticalAlignment("Top");
                    aTable.addCell(cell);
                    cell = new Cell((Element)new Phrase((String)this.model.getValueAt(i, 3), fonts));
                    cell.setHorizontalAlignment("Left");
                    cell.setVerticalAlignment("Top");
                    aTable.addCell(cell);
                    StringBuilder strb = new StringBuilder();
                    double Ir = this.model.getSecond(i, 4);
                    if (Ir >= 0.0) {
                        double s = Ir;
                        int ss = (int)Ir;
                        if (s - (double)ss <= 0.0) {
                            strb.append(ss).append("\u79d2");
                        } else {
                            strb.append(Ir).append("\u79d2");
                        }
                    }
                    if ((koma = this.model.getKoma(i, 4)) > 0) {
                        if ((long)strb.length() <= 0L) {
                            strb.append(koma).append("\uff7a\uff8f");
                        } else {
                            strb.append(" + ").append(koma).append("\uff7a\uff8f");
                        }
                    }
                    cell = new Cell((Element)new Phrase(strb.toString(), fontk));
                    aTable.addCell(cell);
                    double Fr = this.model.getSecond(i, 5);
                    strb = new StringBuilder();
                    if (Fr >= 60.0) {
                        int m = (int)Fr / 60;
                        double s = Fr - (double)(m * 60);
                        int ss = (int)Fr - m * 60;
                        if (s - (double)ss <= 0.0) {
                            strb.append(" ").append(m).append("\u5206").append(ss).append("\u79d2");
                        } else {
                            strb.append(" ").append(m).append("\u5206").append(s).append("\u79d2");
                        }
                    } else if (Fr >= 0.0) {
                        double s = Fr;
                        int ss = (int)Fr;
                        if (s - (double)ss <= 0.0) {
                            strb.append(ss).append("\u79d2");
                        } else {
                            strb.append(s).append("\u79d2");
                        }
                    }
                    koma = this.model.getKoma(i, 5);
                    if (koma > 0) {
                        strb.append(" + ").append(koma).append("\uff7a\uff8f");
                    }
                    cell = new Cell((Element)new Phrase(strb.toString(), fontk));
                    aTable.addCell(cell);
                    try {
                        this.prog = i;
                        SwingUtilities.invokeLater(this.updateAComponent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                document.add((Element)aTable);
            }
            catch (DocumentException de) {
                System.err.println(de.getMessage());
                document.close();
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                document.close();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                document.close();
            }
        }
        finally {
            document.close();
        }
    }

    private com.lowagie.text.Image getScaledImage(String imgName) throws Exception {
        BufferedImage bf;
        String ext;
        com.lowagie.text.Image ret = null;
        File imgfile = new File(imgName);
        String tmpdir = imgfile.getParent();
        String tmpfile = imgfile.getName();
        String pdfdir = String.valueOf(tmpdir) + File.separator + "PDF";
        try {
            File pdfdirfile = new File(pdfdir);
            pdfdirfile.getCanonicalFile().mkdirs();
        }
        catch (Exception e) {
            this.logger.warning("PDF\u51fa\u529b\u7528\u30c7\u30a3\u30ec\u30af\u30c8\u30ea(" + pdfdir + ")\u4f5c\u6210\u5931\u6557\u3000" + e.getLocalizedMessage());
        }
        String newImgName = String.valueOf(pdfdir) + File.separator + tmpfile;
        this.logger.info("PDF File=" + newImgName + " pdfpath=" + pdfdir);
        int x = this.getBlankX();
        int y = this.getBlankY();
        File imgFile = new File(imgName);
        File newImgFile = new File(newImgName);
        if (newImgFile.getAbsoluteFile().exists() && newImgFile.getAbsoluteFile().lastModified() >= imgFile.getAbsoluteFile().lastModified()) {
            try {
                ret = com.lowagie.text.Image.getInstance((String)newImgName);
                if (ret.plainWidth() == (float)x && ret.plainHeight() == (float)y) {
                    this.logger.info("\u7e2e\u5c0f\u51e6\u7406\u5fc5\u8981\u306a\u3057. x=" + x + " plainWidth=" + ret.plainWidth());
                    return ret;
                }
            }
            catch (Exception e) {
                this.logger.warning("\u7e2e\u5c0f\u30a4\u30e1\u30fc\u30b8\u53d6\u5f97\u4f5c\u6210\u5931\u6557:" + newImgName + " " + e.toString());
            }
        }
        if ((ext = imgName.substring(imgName.lastIndexOf(46) + 1)).equalsIgnoreCase("png") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg")) {
            Image img = Toolkit.getDefaultToolkit().getImage(imgFile.getCanonicalPath());
            Point p = this.getImageSize(img);
            bf = new BufferedImage(p.x, p.y, 5);
            Graphics2D g = bf.createGraphics();
            g.drawImage(img, 0, 0, null);
        } else {
            File readImgFile = new File(imgName).getAbsoluteFile();
            ImageReader imgReader = this.imageReaders.get(ext);
            FileInputStream is = new FileInputStream(readImgFile);
            imgReader.setInput(ImageIO.createImageInputStream(is));
            bf = imgReader.read(0);
            ((InputStream)is).close();
        }
        BufferedImage newImg = new BufferedImage(x, y, 1);
        Graphics2D dstgr = newImg.createGraphics();
        dstgr.setColor(Color.WHITE);
        dstgr.fillRect(0, 0, this.getBlankX(), this.getBlankY());
        dstgr.drawImage(bf.getScaledInstance(x, y, 4), 0, 0, null, null);
        ImageIO.write((RenderedImage)newImg, "png", newImgFile.getCanonicalFile());
        dstgr.dispose();
        dstgr = null;
        bf.flush();
        bf = null;
        newImg.flush();
        newImg = null;
        ret = com.lowagie.text.Image.getInstance((String)newImgName);
        return ret;
    }

    private Point getImageSize(Image img) {
        MediaTracker tracker = new MediaTracker(this.dlg);
        tracker.addImage(img, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new Point(img.getWidth(null), img.getHeight(null));
    }

    abstract int getBlankX();

    abstract int getBlankY();

    abstract String getBlankImageFileName();

    abstract void setTableWidth(Table var1) throws Exception;

    abstract void getWriter(Document var1) throws Exception;
}

