/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MakeTMS
extends MakeTemplate {
    public MakeTMS(String p_filename, String p_path, SBDTableModel p_model, DialogProgress p_dlg) {
        super(p_filename, p_path, p_model, p_dlg);
        this.model.removeSpace();
    }

    int getBlankX() {
        return 640;
    }

    int getBlankY() {
        if (this.model.getIconMode() == 1) {
            return 360;
        }
        return 480;
    }

    String getBlankImageFileName() throws Exception {
        this.logger.info("execPath=" + this.execPath);
        String blankimage = this.model.getIconMode() == 1 ? String.valueOf(this.execPath) + "img" + File.separator + "640_360.png" : String.valueOf(this.execPath) + "img" + File.separator + "640_480.png";
        File f = new File(blankimage);
        if (!f.getAbsoluteFile().exists()) {
            throw new Exception("Blank Image Not Fond. file=" + blankimage);
        }
        blankimage = f.getCanonicalPath();
        return blankimage;
    }

    @Override
    void exec() {
        if (this.fileName == null) {
            return;
        }
        if (this.fileName.length() <= 0) {
            return;
        }
        try {
            Element e3;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document retdoc = builder.newDocument();
            Element root = retdoc.createElement("tms");
            root.setAttribute("xmlns", "http://www.mapletown.net/~nekora/tms");
            retdoc.appendChild(root);
            Element e = retdoc.createElement("version");
            e.setAttribute("number", "1.0");
            root.appendChild(e);
            e = retdoc.createElement("context");
            e.setAttribute("sizex", Integer.toString(this.getBlankX()));
            e.setAttribute("sizey", Integer.toString(this.getBlankY()));
            e.setAttribute("framerate", Integer.toString(this.model.frameRate));
            root.appendChild(e);
            e = retdoc.createElement("option");
            e.setAttribute("xmlns", "http://www.mapletown.net/~nekora/tms/option");
            root.appendChild(e);
            e = retdoc.createElement("material");
            e.setAttribute("xmlns", "http://www.mapletown.net/~nekora/tms/material");
            root.appendChild(e);
            Element e2 = retdoc.createElement("layer");
            e2.setAttribute("name", "L1");
            e2.setAttribute("comment", "\u5358\u4e00\u30ec\u30a4\u30e4");
            e.appendChild(e2);
            String save_dst = this.getBlankImageFileName();
            int i = 0;
            while (i < this.model.getRowCount()) {
                e3 = retdoc.createElement("img");
                String imgfilename = this.model.getImgNameAt(i);
                String comment = null;
                if (imgfilename != null && imgfilename.length() > 0) {
                    File f = new File(imgfilename);
                    if (f.getAbsoluteFile().exists()) {
                        if (f.isDirectory()) {
                            imgfilename = save_dst;
                            comment = "\u540c\u4e0a(\u30c7\u30a3\u30ec\u30af\u30c8\u30ea)";
                        } else {
                            imgfilename = f.getCanonicalPath();
                        }
                    } else {
                        imgfilename = this.getBlankImageFileName();
                        comment = "\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u306a\u3057\u3002\u7a7a\u767d\u306b\u7f6e\u63db\uff1d" + imgfilename;
                    }
                    save_dst = imgfilename;
                } else {
                    imgfilename = save_dst;
                    comment = "\u540c\u4e0a(null)";
                }
                this.logger.info("imgfilename=" + imgfilename);
                e3.setAttribute("src", imgfilename);
                if (comment != null) {
                    e3.setAttribute("comment", comment);
                }
                e2.appendChild(e3);
                ++i;
            }
            e = retdoc.createElement("format");
            e.setAttribute("xmlns", "http://www.mapletown.net/~nekora/tms/format");
            root.appendChild(e);
            e2 = retdoc.createElement("peg");
            e2.setAttribute("name", "P1");
            e2.setAttribute("mode", "normal");
            e.appendChild(e2);
            e3 = retdoc.createElement("layer");
            e3.setAttribute("name", "L1");
            e2.appendChild(e3);
            e = retdoc.createElement("script");
            e.setAttribute("bgcolor", "#ffffff");
            e.setAttribute("xmlns", "http://www.mapletown.net/~nekora/tms/script");
            root.appendChild(e);
            i = 0;
            while (i < this.model.getRowCount()) {
                e2 = retdoc.createElement("piece");
                e.appendChild(e2);
                e3 = retdoc.createElement("peg");
                e3.setAttribute("name", "P1");
                e2.appendChild(e3);
                Element e4 = retdoc.createElement("layer");
                e4.setAttribute("name", "L1");
                e4.setAttribute("number", Integer.toString(i));
                e3.appendChild(e4);
                try {
                    this.prog = i;
                    SwingUtilities.invokeLater(this.updateAComponent);
                }
                catch (Exception ex) {
                    this.logger.warning(ex.toString());
                }
                ++i;
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(retdoc);
            File newXML = new File(this.fileName);
            FileOutputStream os = new FileOutputStream(newXML);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            this.logger.warning(e.toString());
            return;
        }
    }
}

