/*
 * Decompiled with CFR 0.152.
 */
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.ImageUtil;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Shape;
import com.anotherbigidea.flash.movie.Symbol;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class MakeSWF
extends MakeTemplate {
    Movie movie;
    int m_framerate;

    MakeSWF(String p_filename, SBDTableModel p_model, DialogProgress p_dlg) {
        super(p_filename, null, p_model, p_dlg);
        this.model.removeSpace();
    }

    @Override
    void exec() {
        if (this.fileName == null) {
            return;
        }
        if (this.fileName.length() <= 0) {
            return;
        }
        int swfFrameRate = this.model.frameRate / 6;
        String imagedir = this.fileName.substring(0, this.fileName.lastIndexOf(46));
        try {
            this.open(this.fileName, swfFrameRate);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        String save_dst = null;
        int i = 0;
        while (i < this.model.getRowCount()) {
            block19: {
                String dst;
                block18: {
                    if (!this.lock.getState()) {
                        this.logger.warning("\u30e1\u30a4\u30f3\u30b9\u30ec\u30c3\u30c9\u304b\u3089\u306e\u6307\u793a\u3067SWF\u51fa\u529b\u4e2d\u65ad");
                        break;
                    }
                    String src = this.model.getImgNameAt(i);
                    dst = null;
                    if (src != null && src.length() > 0) {
                        dst = String.valueOf(imagedir) + "_work.jpg";
                        try {
                            ImageIcon icon = this.model.getIcon(src);
                            Image srcimg = icon.getImage();
                            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
                            Graphics2D dstgr = image.createGraphics();
                            dstgr.drawImage(srcimg, 0, 0, null, null);
                            File dstF = new File(dst);
                            ImageIO.write((RenderedImage)image, "jpg", dstF.getAbsoluteFile());
                            dstgr.dispose();
                            dstgr = null;
                            image.flush();
                            image = null;
                            break block18;
                        }
                        catch (Exception e) {
                            this.logger.warning(e.toString());
                            break block19;
                        }
                    }
                    this.logger.info("\u753b\u50cf\u306a\u3057\u3002");
                    dst = save_dst;
                }
                if (dst != null) {
                    double sec = this.model.getSecond(i, 4);
                    int koma = this.model.getKoma(i, 4);
                    double count = sec * (double)swfFrameRate + (double)koma + 0.5;
                    this.logger.info("Count=" + count);
                    if (count < 0.0) {
                        count = 3 * swfFrameRate;
                    }
                    String word = (String)this.model.getValueAt(i, 3);
                    if (count > 1.0) {
                        try {
                            this.addFrame(dst, word, (int)count);
                        }
                        catch (Exception e) {
                            this.logger.warning(e.toString());
                        }
                    }
                    save_dst = dst;
                }
                try {
                    this.prog = i;
                    SwingUtilities.invokeLater(this.updateAComponent);
                }
                catch (Exception e) {
                    this.logger.warning(e.toString());
                }
            }
            ++i;
        }
        try {
            this.close();
        }
        catch (Exception e) {
            this.logger.warning(e.toString());
        }
    }

    public void open(String outfilename, int framerate) throws Exception {
        this.fileName = outfilename;
        this.m_framerate = framerate;
        this.movie = null;
    }

    public void addFrame(String jpegfilename, String text, int count) throws Exception {
        FileInputStream jpegIn = new FileInputStream(jpegfilename);
        int[] size = new int[2];
        Shape image = ImageUtil.shapeForImage(jpegIn, size);
        int width = size[0];
        int height = size[1];
        jpegIn.close();
        image.defineLineStyle(1.0, null);
        image.setLineStyle(1);
        image.line(width, 0.0);
        image.line(width, height);
        image.line(0.0, height);
        image.line(0.0, 0.0);
        if (this.movie == null) {
            this.movie = new Movie(width + 10, height + 10, this.m_framerate, 5, null);
        }
        int i = 0;
        while (i < count) {
            Frame f = this.movie.appendFrame();
            f.placeSymbol((Symbol)image, 5, 5);
            ++i;
        }
    }

    public void close() throws Exception {
        this.movie.write(this.fileName);
    }
}

