/*
 * Decompiled with CFR 0.152.
 */
import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class MakeRTF
extends MakeiTextTemp {
    static final int normal_width = 250;
    static final int wide_width = 280;

    public MakeRTF(String p_filename, String p_path, SBDTableModel p_model, DialogProgress p_dlg, Font p_dfont, Font p_sfont, Hashtable<String, ImageReader> p_imageReaders) {
        super(p_filename, p_path, p_model, p_dlg, p_dfont, p_sfont, p_imageReaders);
    }

    @Override
    int getBlankX() {
        if (this.model.getIconMode() == 1) {
            return 280;
        }
        return 250;
    }

    @Override
    int getBlankY() {
        if (this.model.getIconMode() == 1) {
            return 157;
        }
        return 187;
    }

    @Override
    String getBlankImageFileName() {
        String blankimage = this.model.getIconMode() == 1 ? String.valueOf(this.execPath) + File.separator + "img" + File.separator + "RTF_WIDE.png" : String.valueOf(this.execPath) + File.separator + "img" + File.separator + "RTF_NORMAL.png";
        File f = new File(blankimage);
        if (f.getAbsoluteFile().exists()) {
            try {
                Image ret = Image.getInstance((String)blankimage);
                if (ret.plainWidth() == (float)this.getBlankX()) {
                    this.logger.info("\u4f5c\u6210\u51e6\u7406\u5fc5\u8981\u306a\u3057");
                    return blankimage;
                }
            }
            catch (Exception e) {
                this.logger.warning("\u7e2e\u5c0f\u30a4\u30e1\u30fc\u30b8\u53d6\u5f97\u4f5c\u6210\u5931\u6557:" + blankimage + " " + e.toString());
            }
        }
        BufferedImage img = new BufferedImage(this.getBlankX(), this.getBlankY(), 1);
        Graphics2D dstgr = img.createGraphics();
        dstgr.setColor(Color.WHITE);
        dstgr.fillRect(0, 0, this.getBlankX(), this.getBlankY());
        try {
            ImageIO.write((RenderedImage)img, "png", f.getAbsoluteFile());
        }
        catch (Exception e) {
            this.logger.warning(e.toString());
        }
        img.flush();
        img = null;
        return blankimage;
    }

    @Override
    void setTableWidth(Table aTable) throws Exception {
        if (this.model.getIconMode() == 1) {
            int[] width = new int[]{5, 40, 23, 22, 5, 5};
            aTable.setWidths(width);
            aTable.setWidth(90.0f);
        } else {
            int[] width = new int[]{5, 37, 24, 24, 5, 5};
            aTable.setWidths(width);
            aTable.setWidth(87.0f);
        }
    }

    @Override
    void getWriter(Document doc) throws Exception {
        RtfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(this.fileName));
    }
}

