/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef RPCFUNC_H_
#define RPCFUNC_H_

typedef enum {
	IPC_FUNC_ID_UNKNOWN = 0x00000000,
	IPC_FUNC_ID_UNICAST = 0x00000000,

	IPC_FUNC_ID_SKELTON = 0x00010000,
	IPC_FUNC_ID_SKELTON_MANAGE,
	IPC_FUNC_ID_SKELTON_MAIN,
	IPC_FUNC_ID_STUB = 0x00020000,
	IPC_FUNC_ID_STUB_MAIN,

	IPC_MLTCST_CNTL_FUNC = 0x00030000,
	IPC_MLTCST_SIGNUP_FUNC,
	IPC_MLTCST_RESIGN_FUNC,
	IPC_MLTCST_FREE_MLCST_FUNC,

	IPC_FUNC_ID_USR_DEF_UNI = 0x03800000,
	/* ... */

	IPC_FUNC_ID_TEST_DEF = 0x0FFF0000,
	IPC_FUNCTION_A_FUNC_ID = 0x0FFF0001,
	IPC_FUNCTION_B_FUNC_ID = 0x0FFF0002,
	IPC_FUNCTION_C_FUNC_ID = 0x0FFF0003,
	IPC_SKEL_FUNC_A_FUNC_ID = 0x0FFF1001,
	IPC_SKEL_FUNC_B_FUNC_ID = 0x0FFF1002,
	IPC_SKEL_FUNC_C_FUNC_ID = 0x0FFF1003,
	IPC_STUB_FUNC_A_FUNC_ID = 0x0FFF2001,
	/* ... */
	
	IPC_FUNC_ID_MULTICAST = 0x10000000,
	IPC_MLTCST_FUNC_BASE = 0x10001000,

	IPC_FUNC_ID_USR_DEF_MLT = 0x18000000,
	
	
	IPC_FUNC_ID_MLTCST_TST_1 = 0x1FFF0001,
	IPC_FUNC_ID_MLTCST_TST_2 = 0x1FFF0002,
	IPC_FUNC_ID_MLTCST_TST_3 = 0x1FFF0003,
	IPC_FUNC_ID_MLTCST_FUNC_1 = 0x0FFF3001,
	IPC_FUNC_ID_MLTCST_FUNC_2 = 0x0FFF3002,
	IPC_FUNC_ID_MLTCST_FUNC_3 = 0x0FFF3003,
	IPC_FUNC_ID_MLTCST_FUNC_4 = 0x0FFF3004,
	IPC_FUNC_ID_MLTCST_FUNC_5 = 0x0FFF3005,
	IPC_FUNC_ID_MLTCST_FUNC_6 = 0x0FFF3006,
	IPC_FUNC_ID_MLTCST_FUNC_7 = 0x0FFF3007,
	/* ... */

	IPC_FUNC_ID_BROADCAST = 0x20000000,
	IPC_FUNC_ID_USR_DEF_BRD = 0x28000000,

	IPC_FUNC_ID_RESERVED = 0x30000000,
	IPC_FUNC_ID_MAX = 0x3FFFFFFF,
	
	IPD_FUNC_ID_UNKNOWN = 0x40000000,
	IPD_FUNC_ID_UNICAST = 0x40000000,
	IPD_FUNC_ID_MULTICAST = 0x50000000,
	IPD_FUNC_ID_BROADCAST = 0x60000000,
	IPD_FUNC_ID_RESERVED = 0x70000000,
	IPD_FUNC_ID_MAX = 0xFFFFFFFF
} RpcFuncId_t;

#endif /* IPCFUNC_H_ */
