/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCQUE_H_
#define IPCQUE_H_

#include	"ipcConf.h"
#include	"ipcType.h"
#include	"ipcSyscall.h"
#include	"rpcMsg.h"
#include	"ipcRendezv.h"

#ifdef	IPC_QUE_MAIN
#define	extern
#endif	/* IPC_QUE_MAIN */

#ifdef	USE_RENDEZVOUS
#define	IPC_SHM_MSG_QUE_GAP_SIZE				(sizeof(IpcQueControl_t)+sizeof(IpcRendezvControl_t))
#else	/* USE_RENDEZVOUS */
#define	IPC_SHM_MSG_QUE_GAP_SIZE				sizeof(IpcQueControl_t)
#endif	/* USE_RENDEZVOUS */

#define	IPC_MSG_QUE_WAIT_FOREVER				(0xFFFFFFFF)

#define	IPC_QUE_ID_UNKNOWN					(0)
#define	IPC_QUE_ID_MAX						(0xFFFFFFFF)

extern RpcResult_t IPC_InitQue(RpcBool_t masterProcess,RpcBool_t IpcFlag);
extern RpcResult_t IPC_CreateQue(RpcBool_t IpcFlag,uint32_t queSize, uint32_t *queId);
extern RpcResult_t IPC_DestroyQue(uint32_t queId);
extern RpcResult_t IPC_EnableQue(uint32_t queId);
extern RpcResult_t IPC_DisableQue(uint32_t queId);
extern RpcResult_t IPC_GetMsgFromQue(uint32_t queId, uint32_t *msgId, RpcMsgParam_t *msgParam, uint32_t timeout);
extern RpcResult_t IPC_SweepMsgFromQue(uint32_t queId, uint32_t *msgId, RpcMsgParam_t *msgParam);
extern RpcResult_t IPC_PutMsgToQue(uint32_t queId, uint32_t msgId, RpcMsgParam_t *msgParam, uint32_t timeout);
extern RpcResult_t IPC_PutMsgToQueUrgent(uint32_t queId, uint32_t msgId, RpcMsgParam_t *msgParam, uint32_t timeout);
extern RpcResult_t IPC_GetNumOfMsg(uint32_t queId, uint32_t *numOfMsg);

extern RpcResult_t IPC_InitExtQue(RpcBool_t masterProcess);
extern RpcResult_t IPC_CreateExtQue(uint32_t queSize, uint32_t *queId);
extern RpcResult_t IPC_DestroyExtQue(uint32_t queId);
extern RpcResult_t IPC_EnableExtQue(uint32_t queId);
extern RpcResult_t IPC_DisableExtQue(uint32_t queId);
extern RpcResult_t IPC_GetMsgFromExtQue(uint32_t queId, uint32_t *msgId, RpcMsgParam_t *msgParam, uint32_t timeout);
extern RpcResult_t IPC_SweepMsgFromExtQue(uint32_t queId, uint32_t *msgId, RpcMsgParam_t *msgParam);
extern RpcResult_t IPC_PutMsgToExtQue(uint32_t queId, uint32_t msgId, RpcMsgParam_t *msgParam, uint32_t timeout);
extern RpcResult_t IPC_PutMsgToExtQueUrgent(uint32_t queId, uint32_t msgId, RpcMsgParam_t *msgParam, uint32_t timeout);
extern RpcResult_t IPC_GetNumOfMsgExt(uint32_t queId, uint32_t *numOfMsg);

#ifdef	USE_RENDEZVOUS
extern IpcRendezvControl_t *IPC_GetRendezvControl(void);
#endif	/* USE_RENDEZVOUS */

extern void IPC_PrintQueData(void);

#endif /* IPCQUE_H_ */
