/*
 * @(#)$Id: DatatypeLibraryImpl.java,v 1.1 2002/11/02 22:30:21 kk122374 Exp $
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.sun.relaxng.javadt;

import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.helpers.ParameterlessDatatypeBuilder;

/**
 * DatatypeLibraryFactory and DatatypeLibrary implementation.
 * 
 * <p>
 * We could have two separate classes for those two interfaces,
 * but it is just slightly simpler to use one class since we only
 * recognize one datatype library.
 * 
 * @author
 * 	Kohsuke Kawaguchi (kohsuke.kawaguchi@sun.com)
 */
public class DatatypeLibraryImpl implements DatatypeLibrary, DatatypeLibraryFactory {
    
    public static final String NAMESPACE_URI =
        "http://java.sun.com/xml/ns/relaxng/java-datatypes";
    
    public DatatypeBuilder createDatatypeBuilder(String name) throws DatatypeException {
        // in this datatype library we don't have any parameter.
        // this helper implementation works in a case like this.
        return new ParameterlessDatatypeBuilder(createDatatype(name));
    }

    public Datatype createDatatype(String name) throws DatatypeException {
        if( "identifier".equals(name) )
            return JavaIdentifierDatatype.theInstance;
        if( "package".equals(name) )
            return JavaPackageDatatype.theInstance;
        
        throw new DatatypeException();
    }

    public DatatypeLibrary createDatatypeLibrary(String namespaceUri) {
        if( NAMESPACE_URI.equals(namespaceUri) )
            return this;
        else
            return null;
    }

}
