/*
 * @(#)$Id: AbstractDatatypeImpl.java,v 1.1 2002/11/02 22:30:21 kk122374 Exp $
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.sun.relaxng.javadt;

import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;
import org.relaxng.datatype.helpers.StreamingValidatorImpl;

/**
 * Base implementation of datatypes.
 * 
 * For detailed description of each method, see:
 * http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/relaxng/datatype/java/src/org/relaxng/datatype/Datatype.java?rev=1.5&content-type=text/vnd.viewcvs-markup
 * 
 * @author
 * 	Kohsuke Kawaguchi (kohsuke.kawaguchi@sun.com)
 */
public abstract class AbstractDatatypeImpl implements Datatype {

    public void checkValid(String name, ValidationContext context) throws DatatypeException {
        // this method is supposed to throw an exception if text is not valid
        if( isValid(name,context) )
            throw new DatatypeException();
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext context) {
        // unless you are very serous, this implementation would be suffice
        return new StreamingValidatorImpl(this,context);
    }

    // if <value>xyz</value> is found in the schema, this method
    // is called with "xyz" and its context.
    public Object createValue(String text, ValidationContext context) {
        if(!isValid(text,context))
            return  null;   // if the value is invalid, we are suppoed to return null.
        
        // in this datatype library we use java.lang.String as the value object.
        // and we also rely on the standard definition of the equality and the hashCode.
        //
        // we'd like our datatypes to treat "byte" and "   byte  " as equivalent
        // (because in XML one often use whitespaces as indentation), so
        //
        // we trim the string so that those two representations will result
        // in the same "canonicalized" form.
        return text.trim();
    }

    public boolean sameValue(Object obj1, Object obj2) {
        // if your datatype defines equality based on the equality of 
        // Java objects, this would be fine.
        //
        // if your notion of equality is not that simple, you have
        // to implement that semantics by using this method and you
        // also need to implement the hashCode method that is consistent
        // with this.
        return obj1.equals(obj2);
    }

    public int valueHashCode(Object obj) {
        return obj.hashCode();
    }

    public int getIdType() {
        return ID_TYPE_NULL;    // no ID semantics
    }

    public boolean isContextDependent() {
        return true;    // this datatype doesn't use ValidationContext
    }

}
