/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

// import java content classes generated by binding compiler
import primer.po.*;

public class Main {
    
    // This sample application demonstrates how to use the ObjectFactory
    // class to create a java content tree from scratch and marshal it
    // to XML data
    
    public static void main( String[] args ) {
        try {
            // create a JAXBContext
            JAXBContext jc = JAXBContext.newInstance( "primer.po" );
            
            // create an ObjectFactory instance.
            // if the JAXBContext had been created with mutiple pacakge names,
            // we would have to explicitly use the correct package name when
            // creating the ObjectFactory.            
            ObjectFactory objFactory = new ObjectFactory();
            
            // create an empty PurchaseOrder
            PurchaseOrder po = objFactory.createPurchaseOrder();
            
            // set the required orderDate attribute
            po.setOrderDate( Calendar.getInstance() );
            
            // create shipTo USAddress object
            USAddress shipTo = createUSAddress( objFactory,
                                                "Alice Smith",
                                                "123 Maple Street",
                                                "Cambridge",
                                                "MA",
                                                "12345" );
                                                
            // set the required shipTo address 
            po.setShipTo( shipTo );
            
            // create billTo USAddress object
            USAddress billTo = createUSAddress( objFactory,
                                                "Robert Smith",
                                                "8 Oak Avenue",
                                                "Cambridge",
                                                "MA",
                                                "12345" );
            
            // set the requred billTo address
            po.setBillTo( billTo );
                                                
            // create an empty Items object
            Items items = objFactory.createItems();
            
            // get a reference to the ItemType list
            List itemList = items.getItem();
            
            // start adding ItemType objects into it
            itemList.add( createItemType( objFactory,
                                          "Nosferatu - Special Edition (1929)", 
                                          new BigInteger( "5" ), 
                                          new BigDecimal( "19.99" ), 
                                          null,
                                          null,
                                          "242-NO" ) );
            itemList.add( createItemType( objFactory,
                                          "The Mummy (1959)", 
                                          new BigInteger( "3" ), 
                                          new BigDecimal( "19.98" ), 
                                          null,
                                          null,
                                          "242-MU" ) );
            itemList.add( createItemType( objFactory,
                                          "Godzilla and Mothra: Battle for Earth/Godzilla vs. King Ghidora", 
                                          new BigInteger( "3" ), 
                                          new BigDecimal( "27.95" ), 
                                          null,
                                          null,
                                          "242-GZ" ) );
            
            // set the required Items list
            po.setItems( items );
            
            // create a Marshaller and marshal to System.out
            Marshaller m = jc.createMarshaller();
            m.setProperty( Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE );
            m.marshal( po, System.out );
            
        } catch( JAXBException je ) {
            je.printStackTrace();
        } 
    }
    
    public static USAddress createUSAddress( ObjectFactory objFactory,
                                               String name, String street,
                                               String city, String state,
                                               String zip ) 
        throws JAXBException {
    
        // create an empty USAddress objects                                             
        USAddress address = objFactory.createUSAddress();
        
        // set properties on it
        address.setName( name );
        address.setStreet( street );
        address.setCity( city );
        address.setState( state );
        address.setZip( new BigDecimal( zip ) );
        
        // return it
        return address;
    }
    
    public static Items.ItemType createItemType( ObjectFactory objFactory,
                                                 String productName,
                                                 BigInteger quantity,
                                                 BigDecimal price,
                                                 String comment,
                                                 Calendar shipDate,
                                                 String partNum ) 
        throws JAXBException {
   
        // create an empty ItemType object
        Items.ItemType itemType = objFactory.createItemsItemType();
        
        // set properties on it
        itemType.setProductName( productName );
        itemType.setQuantity( quantity );
        itemType.setUSPrice( price );
        itemType.setComment( comment );
        itemType.setShipDate( shipDate );
        itemType.setPartNum( partNum );
        
        // return it
        return itemType;
    }
                                           
                                                 
}
