/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.jaxp.DefaultValidationErrorHandler;
import com.sun.org.apache.xerces.internal.jaxp.JAXPConstants;
import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SAXParserImpl
extends SAXParser
implements JAXPConstants {
    private XMLReader xmlReader = new com.sun.org.apache.xerces.internal.parsers.SAXParser();
    private String schemaLanguage = null;

    SAXParserImpl(SAXParserFactory spf, Hashtable features) throws SAXException {
        if (spf.isValidating()) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", spf.isValidating());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", spf.isNamespaceAware());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", !spf.isNamespaceAware());
        this.setFeatures(features);
    }

    private void setFeatures(Hashtable features) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (features != null) {
            Enumeration e = features.keys();
            while (e.hasMoreElements()) {
                String feature = (String)e.nextElement();
                boolean value = (Boolean)features.get(feature);
                this.xmlReader.setFeature(feature, value);
            }
        }
    }

    public Parser getParser() throws SAXException {
        return (Parser)((Object)this.xmlReader);
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException x) {
            throw new IllegalStateException(x.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException x) {
            throw new IllegalStateException(x.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
            if ("http://www.w3.org/2001/XMLSchema".equals(value)) {
                if (!this.isValidating()) return;
                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.xmlReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                return;
            } else {
                if (value != null) throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "schema-not-supported", null));
                this.schemaLanguage = null;
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            }
            return;
        } else if ("http://java.sun.com/xml/jaxp/properties/schemaSource".equals(name)) {
            String val = (String)this.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            if (val == null || !"http://www.w3.org/2001/XMLSchema".equals(val)) throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "jaxp-order-not-supported", new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://java.sun.com/xml/jaxp/properties/schemaSource"}));
            this.xmlReader.setProperty(name, value);
            return;
        } else {
            this.xmlReader.setProperty(name, value);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
            return this.schemaLanguage;
        }
        return this.xmlReader.getProperty(name);
    }
}

