/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.templates;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xalan.internal.templates.ElemTemplateElement;
import com.sun.org.apache.xalan.internal.templates.StylesheetRoot;
import com.sun.org.apache.xml.internal.serializer.OutputPropertiesFactory;
import com.sun.org.apache.xml.internal.serializer.OutputPropertyUtils;
import com.sun.org.apache.xml.internal.utils.FastStringBuffer;
import com.sun.org.apache.xml.internal.utils.QName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class OutputProperties
extends ElemTemplateElement
implements Cloneable {
    private Properties m_properties = null;

    public OutputProperties() {
        this("xml");
    }

    public OutputProperties(Properties defaults) {
        this.m_properties = new Properties(defaults);
    }

    public OutputProperties(String method) {
        this.m_properties = new Properties(OutputPropertiesFactory.getDefaultMethodProperties(method));
    }

    public Object clone() {
        try {
            OutputProperties cloned = (OutputProperties)super.clone();
            cloned.m_properties = (Properties)((Hashtable)cloned.m_properties).clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setProperty(QName key, String value) {
        this.setProperty(key.toNamespacedString(), value);
    }

    public void setProperty(String key, String value) {
        if (key.equals("method")) {
            this.setMethodDefaults(value);
        }
        if (key.startsWith("{http://xml.apache.org/xslt}")) {
            key = "{http://xml.apache.org/xalan}" + key.substring(OutputPropertiesFactory.S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN);
        }
        ((Hashtable)this.m_properties).put(key, value);
    }

    public String getProperty(QName key) {
        return this.m_properties.getProperty(key.toNamespacedString());
    }

    public String getProperty(String key) {
        if (key.startsWith("{http://xml.apache.org/xslt}")) {
            key = "{http://xml.apache.org/xalan}" + key.substring(OutputPropertiesFactory.S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN);
        }
        return this.m_properties.getProperty(key);
    }

    public void setBooleanProperty(QName key, boolean value) {
        ((Hashtable)this.m_properties).put(key.toNamespacedString(), value ? "yes" : "no");
    }

    public void setBooleanProperty(String key, boolean value) {
        ((Hashtable)this.m_properties).put(key, value ? "yes" : "no");
    }

    public boolean getBooleanProperty(QName key) {
        return this.getBooleanProperty(key.toNamespacedString());
    }

    public boolean getBooleanProperty(String key) {
        return OutputPropertyUtils.getBooleanProperty(key, this.m_properties);
    }

    public void setIntProperty(QName key, int value) {
        this.setIntProperty(key.toNamespacedString(), value);
    }

    public void setIntProperty(String key, int value) {
        ((Hashtable)this.m_properties).put(key, Integer.toString(value));
    }

    public int getIntProperty(QName key) {
        return this.getIntProperty(key.toNamespacedString());
    }

    public int getIntProperty(String key) {
        return OutputPropertyUtils.getIntProperty(key, this.m_properties);
    }

    public void setQNameProperty(QName key, QName value) {
        this.setQNameProperty(key.toNamespacedString(), value);
    }

    public void setMethodDefaults(String method) {
        String defaultMethod = this.m_properties.getProperty("method");
        if (null == defaultMethod || !defaultMethod.equals(method) || defaultMethod.equals("xml")) {
            Properties savedProps = this.m_properties;
            Properties newDefaults = OutputPropertiesFactory.getDefaultMethodProperties(method);
            this.m_properties = new Properties(newDefaults);
            this.copyFrom(savedProps, false);
        }
    }

    public void setQNameProperty(String key, QName value) {
        this.setProperty(key, value.toNamespacedString());
    }

    public QName getQNameProperty(QName key) {
        return this.getQNameProperty(key.toNamespacedString());
    }

    public QName getQNameProperty(String key) {
        return OutputProperties.getQNameProperty(key, this.m_properties);
    }

    public static QName getQNameProperty(String key, Properties props) {
        String s = props.getProperty(key);
        if (null != s) {
            return QName.getQNameFromString(s);
        }
        return null;
    }

    public void setQNameProperties(QName key, Vector v) {
        this.setQNameProperties(key.toNamespacedString(), v);
    }

    public void setQNameProperties(String key, Vector v) {
        int s = v.size();
        FastStringBuffer fsb = new FastStringBuffer(9, 9);
        int i = 0;
        while (i < s) {
            QName qname = (QName)v.elementAt(i);
            fsb.append(qname.toNamespacedString());
            if (i < s - 1) {
                fsb.append(' ');
            }
            ++i;
        }
        ((Hashtable)this.m_properties).put(key, fsb.toString());
    }

    public Vector getQNameProperties(QName key) {
        return this.getQNameProperties(key.toNamespacedString());
    }

    public Vector getQNameProperties(String key) {
        return OutputProperties.getQNameProperties(key, this.m_properties);
    }

    public static Vector getQNameProperties(String key, Properties props) {
        block6: {
            String s = props.getProperty(key);
            if (null == s) break block6;
            Vector<QName> v = new Vector<QName>();
            int l = s.length();
            boolean inCurly = false;
            FastStringBuffer buf = new FastStringBuffer();
            int i = 0;
            while (i < l) {
                block9: {
                    char c;
                    block8: {
                        block7: {
                            c = s.charAt(i);
                            if (!Character.isWhitespace(c)) break block7;
                            if (inCurly) break block8;
                            if (buf.length() > 0) {
                                QName qname = QName.getQNameFromString(buf.toString());
                                v.addElement(qname);
                                buf.reset();
                            }
                            break block9;
                        }
                        if ('{' == c) {
                            inCurly = true;
                        } else if ('}' == c) {
                            inCurly = false;
                        }
                    }
                    buf.append(c);
                }
                ++i;
            }
            if (buf.length() > 0) {
                QName qname = QName.getQNameFromString(buf.toString());
                v.addElement(qname);
                buf.reset();
            }
            return v;
        }
        return null;
    }

    public void recompose(StylesheetRoot root) throws TransformerException {
        root.recomposeOutput(this);
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void copyFrom(Properties src) {
        this.copyFrom(src, true);
    }

    public void copyFrom(Properties src, boolean shouldResetDefaults) {
        Enumeration keys = ((Hashtable)src).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!OutputProperties.isLegalPropertyKey(key)) {
                throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{key}));
            }
            Object oldValue = ((Hashtable)this.m_properties).get(key);
            if (null == oldValue) {
                String val = (String)((Hashtable)src).get(key);
                if (shouldResetDefaults && key.equals("method")) {
                    this.setMethodDefaults(val);
                }
                ((Hashtable)this.m_properties).put(key, val);
                continue;
            }
            if (!key.equals("cdata-section-elements")) continue;
            ((Hashtable)this.m_properties).put(key, (String)oldValue + " " + (String)((Hashtable)src).get(key));
        }
    }

    public void copyFrom(OutputProperties opsrc) throws TransformerException {
        this.copyFrom(opsrc.getProperties());
    }

    public static boolean isLegalPropertyKey(String key) {
        return key.equals("cdata-section-elements") || key.equals("doctype-public") || key.equals("doctype-system") || key.equals("encoding") || key.equals("indent") || key.equals("media-type") || key.equals("method") || key.equals("omit-xml-declaration") || key.equals("standalone") || key.equals("version") || key.length() > 0 && key.charAt(0) == '{' && key.lastIndexOf(123) == 0 && key.indexOf(125) > 0 && key.lastIndexOf(125) == key.indexOf(125);
    }

    public static Properties getDefaultMethodProperties(String method) {
        return OutputPropertiesFactory.getDefaultMethodProperties(method);
    }
}

