/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public final class Method
extends FieldOrMethod {
    public Method() {
    }

    public Method(Method c) {
        super(c);
    }

    Method(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatError {
        super(file, constant_pool);
    }

    public Method(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public void accept(Visitor v) {
        v.visitMethod(this);
    }

    public final Code getCode() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof Code) {
                return (Code)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof ExceptionTable) {
                return (ExceptionTable)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLocalVariableTable();
        }
        return null;
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLineNumberTable();
        }
        return null;
    }

    public final String toString() {
        String str;
        String access = Utility.accessToString(this.access_flags);
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuffer buf = new StringBuffer(signature);
        int i = 0;
        while (i < this.attributes_count) {
            Attribute a = this.attributes[i];
            if (!(a instanceof Code) && !(a instanceof ExceptionTable)) {
                buf.append(" [" + a.toString() + "]");
            }
            ++i;
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).equals("")) {
            buf.append("\n\t\tthrows " + str);
        }
        return buf.toString();
    }

    public final Method copy(ConstantPool constant_pool) {
        return (Method)this.copy_(constant_pool);
    }
}

