/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.DataTypeWithLexicalConstraintFacet;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import com.sun.msv.datatype.xsd.regex.ParseException;
import com.sun.msv.datatype.xsd.regex.RegularExpression;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public final class PatternFacet
extends DataTypeWithLexicalConstraintFacet {
    private transient RegularExpression[] exps;
    public final String[] patterns;
    private static final long serialVersionUID = 1L;

    public RegularExpression[] getRegExps() {
        return this.exps;
    }

    public PatternFacet(String nsUri, String typeName, XSDatatypeImpl baseType, TypeIncubator facets) throws DatatypeException {
        super(nsUri, typeName, baseType, "pattern", facets.isFixed("pattern"));
        Vector regExps = facets.getVector("pattern");
        this.patterns = regExps.toArray(new String[regExps.size()]);
        try {
            this.compileRegExps();
        }
        catch (ParseException pe) {
            throw new DatatypeException(PatternFacet.localize("PatternFacet.ParseError", pe.getMessage()));
        }
    }

    private void compileRegExps() throws ParseException {
        this.exps = new RegularExpression[this.patterns.length];
        for (int i = 0; i < this.exps.length; ++i) {
            this.exps[i] = new RegularExpression(this.patterns[i], "X");
        }
    }

    protected void diagnoseByFacet(String content, ValidationContext context) throws DatatypeException {
        if (this.checkLexicalConstraint(content)) {
            return;
        }
        if (this.exps.length == 1) {
            throw new DatatypeException(-1, PatternFacet.localize("DataTypeErrorDiagnosis.Pattern.1", this.patterns[0]));
        }
        throw new DatatypeException(-1, PatternFacet.localize("DataTypeErrorDiagnosis.Pattern.Many"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkLexicalConstraint(String literal) {
        PatternFacet patternFacet = this;
        synchronized (patternFacet) {
            for (int i = 0; i < this.exps.length; ++i) {
                if (!this.exps[i].matches(literal)) continue;
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.compileRegExps();
    }
}

