/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public final class Reflections {
    private Reflections() {
    }

    public static boolean containsAnnotation(Class<?> javaClass, Class<? extends Annotation> requiredAnnotation) {
        for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if ((clazz == javaClass || requiredAnnotation.isAnnotationPresent(Inherited.class)) && Reflections.containsAnnotations(clazz.getAnnotations(), requiredAnnotation)) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!Reflections.containsAnnotations(field.getAnnotations(), requiredAnnotation)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                if (Reflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Constructor)accessibleObject).getParameterAnnotations()) {
                    if (!Reflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (Reflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Method)accessibleObject).getParameterAnnotations()) {
                    if (!Reflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static boolean isClassLoadable(ResourceLoader resourceLoader, String className) {
        return Reflections.loadClass(resourceLoader, className) != null;
    }

    public static <T> Class<T> loadClass(ResourceLoader resourceLoader, String className) {
        try {
            return Reflections.classForName(resourceLoader, className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Class<T> classForName(ResourceLoader resourceLoader, String className) {
        try {
            return (Class)Reflections.cast(resourceLoader.classForName(className));
        }
        catch (Exception e) {
            CommonLogger.LOG.cannotLoadClassUsingResourceLoader(className);
            CommonLogger.LOG.catchingTrace(e);
            try {
                return (Class)Reflections.cast(Class.forName(className));
            }
            catch (Exception e2) {
                throw CommonLogger.LOG.cannotLoadClass(className, e2);
            }
        }
    }

    public static boolean hasBeanDefiningMetaAnnotationSpecified(Annotation[] annotations, Class<? extends Annotation> metaAnnotationType) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAnnotations(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation) {
        return Reflections.containsAnnotation(annotations, requiredAnnotation, true);
    }

    private static boolean containsAnnotation(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (requiredAnnotation.equals(annotationType)) {
                return true;
            }
            if (!checkMetaAnnotations || !Reflections.containsAnnotation(annotationType.getAnnotations(), requiredAnnotation, false)) continue;
            return true;
        }
        return false;
    }
}

