/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CustomColors {
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap[] lightMapsColorsRgb = null;
    private static int lightmapMinDimensionId = 0;
    private static float[][] sunRgbs = new float[16][3];
    private static float[][] torchRgbs = new float[16][3];
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static aui fogColorNether = null;
    private static aui fogColorEnd = null;
    private static aui skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static int[] potionColors = null;
    private static final alz BLOCK_STATE_DIRT = afi.d.Q();
    private static final alz BLOCK_STATE_WATER = afi.j.Q();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new IColorizer(){

        @Override
        public int getColor(adq blockAccess, cj blockPos) {
            ady biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (swampGrassColors != null && biome == ady.v) {
                return swampGrassColors.getColor(biome, blockPos);
            }
            return biome.b(blockPos);
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE = new IColorizer(){

        @Override
        public int getColor(adq blockAccess, cj blockPos) {
            ady biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (swampFoliageColors != null && biome == ady.v) {
                return swampFoliageColors.getColor(biome, blockPos);
            }
            return biome.c(blockPos);
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new IColorizer(){

        @Override
        public int getColor(adq blockAccess, cj blockPos) {
            if (foliagePineColors != null) {
                return foliagePineColors.getColor(blockAccess, blockPos);
            }
            return adj.a();
        }

        @Override
        public boolean isColorConstant() {
            return foliagePineColors == null;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new IColorizer(){

        @Override
        public int getColor(adq blockAccess, cj blockPos) {
            if (foliageBirchColors != null) {
                return foliageBirchColors.getColor(blockAccess, blockPos);
            }
            return adj.b();
        }

        @Override
        public boolean isColorConstant() {
            return foliageBirchColors == null;
        }
    };
    private static final IColorizer COLORIZER_WATER = new IColorizer(){

        @Override
        public int getColor(adq blockAccess, cj blockPos) {
            ady biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (waterColors != null) {
                return waterColors.getColor(biome, blockPos);
            }
            if (Reflector.ForgeBiomeGenBase_getWaterColorMultiplier.exists()) {
                return Reflector.callInt(biome, Reflector.ForgeBiomeGenBase_getWaterColorMultiplier, new Object[0]);
            }
            return biome.ar;
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };

    public static void update() {
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapsColorsRgb = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors(mapColorsOriginal);
        potionColors = null;
        abe.clearPotionColorCache();
        String mcpColormap = "mcpatcher/colormap/";
        String[] waterPaths = new String[]{"water.png", "watercolorX.png"};
        waterColors = CustomColors.getCustomColors(mcpColormap, waterPaths, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColors.getCustomColors(mcpColormap, pinePaths, 256, 256);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColors.getCustomColors(mcpColormap, birchPaths, 256, 256);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColors.getCustomColors(mcpColormap, swampGrassPaths, 256, 256);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColors.getCustomColors(mcpColormap, swampFoliagePaths, 256, 256);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColors.getCustomColors(mcpColormap, sky0Paths, 256, 256);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColors.getCustomColors(mcpColormap, fog0Paths, 256, 256);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColors.getCustomColors(mcpColormap, underwaterPaths, 256, 256);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColors.getCustomColors(mcpColormap, redstonePaths, 16, 1);
        xpOrbColors = CustomColors.getCustomColors(mcpColormap + "xporb.png", -1, -1);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColors.getCustomColors(mcpColormap, stemPaths, 8, 1);
        stemPumpkinColors = CustomColors.getCustomColors(mcpColormap + "pumpkinstem.png", 8, 1);
        stemMelonColors = CustomColors.getCustomColors(mcpColormap + "melonstem.png", 8, 1);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColors.getCustomColors(mcpColormap, myceliumPaths, -1, -1);
        Pair<CustomColormap[], Integer> lightMaps = CustomColors.parseLightmapsRgb();
        lightMapsColorsRgb = (CustomColormap[])lightMaps.getLeft();
        lightmapMinDimensionId = (Integer)lightMaps.getRight();
        CustomColors.readColorProperties("mcpatcher/color.properties");
        blockColormaps = CustomColors.readBlockColormaps(new String[]{mcpColormap + "custom/", mcpColormap + "blocks/"}, colorsBlockColormaps, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
    }

    private static Pair<CustomColormap[], Integer> parseLightmapsRgb() {
        String lightmapPrefix = "mcpatcher/lightmap/world";
        String lightmapSuffix = ".png";
        String[] pathsLightmap = ResUtils.collectFiles(lightmapPrefix, lightmapSuffix);
        HashMap<Integer, String> mapLightmaps = new HashMap<Integer, String>();
        for (int i = 0; i < pathsLightmap.length; ++i) {
            String path = pathsLightmap[i];
            String dimIdStr = StrUtils.removePrefixSuffix(path, lightmapPrefix, lightmapSuffix);
            int dimId = Config.parseInt(dimIdStr, Integer.MIN_VALUE);
            if (dimId == Integer.MIN_VALUE) {
                CustomColors.warn("Invalid dimension ID: " + dimIdStr + ", path: " + path);
                continue;
            }
            mapLightmaps.put(dimId, path);
        }
        Set setDimIds = mapLightmaps.keySet();
        Object[] dimIds = setDimIds.toArray(new Integer[setDimIds.size()]);
        Arrays.sort(dimIds);
        if (dimIds.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int minDimId = (Integer)dimIds[0];
        int maxDimId = (Integer)dimIds[dimIds.length - 1];
        int countDim = maxDimId - minDimId + 1;
        CustomColormap[] colormaps = new CustomColormap[countDim];
        for (int i = 0; i < dimIds.length; ++i) {
            Object dimId = dimIds[i];
            String path = (String)mapLightmaps.get(dimId);
            CustomColormap colors = CustomColors.getCustomColors(path, -1, -1);
            if (colors == null) continue;
            if (colors.getWidth() < 16) {
                CustomColors.warn("Invalid lightmap width: " + colors.getWidth() + ", path: " + path);
                continue;
            }
            int lightmapIndex = (Integer)dimId - minDimId;
            colormaps[lightmapIndex] = colors;
        }
        return new ImmutablePair((Object)colormaps, (Object)minDimId);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream(new jy(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            in.close();
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            jy loc = new jy(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            CustomColors.dbg("Loading " + fileName);
            Properties props = new Properties();
            props.load(in);
            in.close();
            particleWaterColor = CustomColors.readColor(props, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor(props, "particle.portal");
            lilyPadColor = CustomColors.readColor(props, "lilypad");
            expBarTextColor = CustomColors.readColor(props, "text.xpbar");
            bossTextColor = CustomColors.readColor(props, "text.boss");
            signTextColor = CustomColors.readColor(props, "text.sign");
            fogColorNether = CustomColors.readColorVec3(props, "fog.nether");
            fogColorEnd = CustomColors.readColorVec3(props, "fog.end");
            skyColorEnd = CustomColors.readColorVec3(props, "sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps(props, fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors(props, fileName, "egg.shell.", "Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors(props, fileName, "egg.spots.", "Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors(props, fileName, "collar.", "Wolf collar");
            sheepColors = CustomColors.readDyeColors(props, fileName, "sheep.", "Sheep");
            textColors = CustomColors.readTextColors(props, fileName, "text.code.", "Text");
            int[] mapColors = CustomColors.readMapColors(props, fileName, "map.", "Map");
            if (mapColors != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors(mapColors);
            }
            potionColors = CustomColors.readPotionColors(props, fileName, "potion.", "Potion");
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        void var7_9;
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        boolean bl = false;
        while (var7_9 < propNames.length) {
            String name = propNames[var7_9];
            String value = props.getProperty(name);
            CustomColors.dbg("Block palette: " + name + " = " + value);
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath(fileName);
            path = TextureUtils.fixResourcePath(path, basePath);
            CustomColormap colors = CustomColors.getCustomColors(path, 256, 256);
            if (colors == null) {
                CustomColors.warn("Colormap not found: " + path);
            } else {
                ConnectedParser cp = new ConnectedParser("CustomColors");
                MatchBlock[] mbs = cp.parseMatchBlocks(value);
                if (mbs == null || mbs.length <= 0) {
                    CustomColors.warn("Invalid match blocks: " + value);
                } else {
                    for (int m = 0; m < mbs.length; ++m) {
                        MatchBlock mb = mbs[m];
                        colors.addMatchBlock(mb);
                    }
                    list.add(colors);
                }
            }
            ++var7_9;
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] customColormapArray = list.toArray(new CustomColormap[list.size()]);
        return customColormapArray;
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        int i;
        Object[] paths = ResUtils.collectFiles(basePaths, new String[]{".properties"});
        Arrays.sort(paths);
        ArrayList blockList = new ArrayList();
        for (i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            CustomColors.dbg("Block colormap: " + (String)path);
            try {
                jy locFile = new jy("minecraft", (String)path);
                InputStream in = Config.getResourceStream(locFile);
                if (in == null) {
                    CustomColors.warn("File not found: " + (String)path);
                    continue;
                }
                Properties props = new Properties();
                props.load(in);
                CustomColormap cm = new CustomColormap(props, (String)path, width, height);
                if (!cm.isValid((String)path) || !cm.isValidMatchBlocks((String)path)) continue;
                CustomColors.addToBlockList(cm, blockList);
                continue;
            }
            catch (FileNotFoundException e) {
                CustomColors.warn("File not found: " + (String)path);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (basePalettes != null) {
            for (i = 0; i < basePalettes.length; ++i) {
                CustomColormap cm = basePalettes[i];
                CustomColors.addToBlockList(cm, blockList);
            }
        }
        if (blockList.size() <= 0) {
            return null;
        }
        CustomColormap[][] cmArr = CustomColors.blockListToArray(blockList);
        return cmArr;
    }

    private static void addToBlockList(CustomColormap cm, List blockList) {
        int[] ids = cm.getMatchBlockIds();
        if (ids == null || ids.length <= 0) {
            CustomColors.warn("No match blocks: " + Config.arrayToString(ids));
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            int blockId = ids[i];
            if (blockId < 0) {
                CustomColors.warn("Invalid block ID: " + blockId);
                continue;
            }
            CustomColors.addToList(cm, blockList, blockId);
        }
    }

    private static void addToList(CustomColormap cm, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> subList = (ArrayList<CustomColormap>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomColormap>();
            list.set(id, subList);
        }
        subList.add(cm);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] colArr = new CustomColormap[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomColormap[] subArr = subList.toArray(new CustomColormap[subList.size()]);
            colArr[i] = subArr;
        }
        return colArr;
    }

    private static int readColor(Properties props, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int col = CustomColors.readColor(props, name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        int color = CustomColors.parseColor(str = str.trim());
        if (color < 0) {
            CustomColors.warn("Invalid color: " + name + " = " + str);
            return color;
        }
        CustomColors.dbg(name + " = " + str);
        return color;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static aui readColorVec3(Properties props, String name) {
        int col = CustomColors.readColor(props, name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new aui((double)redF, (double)greenF, (double)blueF);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            path = basePath + path;
            CustomColormap cols = CustomColors.getCustomColors(path, width, height);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        try {
            jy loc = new jy(pathImage);
            if (!Config.hasResource(loc)) {
                return null;
            }
            CustomColors.dbg("Colormap " + pathImage);
            Properties props = new Properties();
            String pathProps = StrUtils.replaceSuffix(pathImage, ".png", ".properties");
            jy locProps = new jy(pathProps);
            if (Config.hasResource(locProps)) {
                InputStream in = Config.getResourceStream(locProps);
                props.load(in);
                in.close();
                CustomColors.dbg("Colormap properties: " + pathProps);
            } else {
                props.put("format", "vanilla");
                props.put("source", pathImage);
                pathProps = pathImage;
            }
            CustomColormap cm = new CustomColormap(props, pathProps, width, height);
            if (!cm.isValid(pathProps)) {
                return null;
            }
            return cm;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors() && Config.isSmoothBiomes();
    }

    public static int getColorMultiplier(bgg quad, afh block, adq blockAccess, cj blockPos, RenderEnv renderEnv) {
        IColorizer colorizer;
        if (blockColormaps != null) {
            CustomColormap cm;
            alz bs = renderEnv.getBlockState();
            if (!quad.b()) {
                if (block == afi.c) {
                    bs = BLOCK_STATE_DIRT;
                }
                if (block == afi.af) {
                    return -1;
                }
            }
            if (block == afi.cF && renderEnv.getMetadata() >= 8) {
                blockPos = blockPos.b();
                bs = blockAccess.p(blockPos);
            }
            if ((cm = CustomColors.getBlockColormap(bs)) != null) {
                if (Config.isSmoothBiomes() && !cm.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier(blockAccess, blockPos, cm, renderEnv.getColorizerBlockPosM());
                }
                return cm.getColor(blockAccess, blockPos);
            }
        }
        if (!quad.b()) {
            return -1;
        }
        if (block == afi.bx) {
            return CustomColors.getLilypadColorMultiplier(blockAccess, blockPos);
        }
        if (block == afi.af) {
            return CustomColors.getRedstoneColor(renderEnv.getBlockState());
        }
        if (block instanceof ajx) {
            return CustomColors.getStemColorMultiplier(block, blockAccess, blockPos, renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        int metadata = renderEnv.getMetadata();
        if (block == afi.c || block == afi.H || block == afi.cF) {
            colorizer = COLORIZER_GRASS;
        } else if (block == afi.cF) {
            colorizer = COLORIZER_GRASS;
            if (metadata >= 8) {
                blockPos = blockPos.b();
            }
        } else if (block == afi.t) {
            switch (metadata & 3) {
                case 0: {
                    colorizer = COLORIZER_FOLIAGE;
                    break;
                }
                case 1: {
                    colorizer = COLORIZER_FOLIAGE_PINE;
                    break;
                }
                case 2: {
                    colorizer = COLORIZER_FOLIAGE_BIRCH;
                    break;
                }
                default: {
                    colorizer = COLORIZER_FOLIAGE;
                    break;
                }
            }
        } else if (block == afi.u) {
            colorizer = COLORIZER_FOLIAGE;
        } else if (block == afi.bn) {
            colorizer = COLORIZER_FOLIAGE;
        } else {
            return -1;
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier(blockAccess, blockPos, colorizer, renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockAccess, blockPos);
    }

    protected static ady getColorBiome(adq blockAccess, cj blockPos) {
        ady biome = blockAccess.b(blockPos);
        if (biome == ady.v && !Config.isSwampColors()) {
            biome = ady.q;
        }
        return biome;
    }

    private static CustomColormap getBlockColormap(alz blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof aly)) {
            return null;
        }
        aly bs = (aly)blockState;
        int blockId = bs.getBlockId();
        if (blockId < 0 || blockId >= blockColormaps.length) {
            return null;
        }
        CustomColormap[] cms = blockColormaps[blockId];
        if (cms == null) {
            return null;
        }
        for (int i = 0; i < cms.length; ++i) {
            CustomColormap cm = cms[i];
            if (!cm.matchesBlock(bs)) continue;
            return cm;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(adq blockAccess, cj blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int x = blockPos.n();
        int y = blockPos.o();
        int z = blockPos.p();
        BlockPosM posM = blockPosM;
        for (int ix = x - 1; ix <= x + 1; ++ix) {
            for (int iz = z - 1; iz <= z + 1; ++iz) {
                posM.setXyz(ix, y, iz);
                int col = colorizer.getColor(blockAccess, posM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r = sumRed / 9;
        int g = sumGreen / 9;
        int b2 = sumBlue / 9;
        return r << 16 | g << 8 | b2;
    }

    public static int getFluidColor(adq blockAccess, alz blockState, cj blockPos, RenderEnv renderEnv) {
        afh block = blockState.c();
        IColorizer colorizer = CustomColors.getBlockColormap(blockState);
        if (colorizer == null && block.t() == arm.h) {
            colorizer = COLORIZER_WATER;
        }
        if (colorizer == null) {
            return block.d(blockAccess, blockPos);
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier(blockAccess, blockPos, colorizer, renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockAccess, blockPos);
    }

    public static void updatePortalFX(beb fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.b(redF, greenF, blueF);
    }

    public static void updateMyceliumFX(beb fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors.getColorRandom();
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.b(redF, greenF, blueF);
    }

    private static int getRedstoneColor(alz blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int level = CustomColors.getRedstoneLevel(blockState, 15);
        int col = redstoneColors.getColor(level);
        return col;
    }

    public static void updateReddustFX(beb fx, adq blockAccess, double x, double y, double z) {
        if (redstoneColors == null) {
            return;
        }
        alz state = blockAccess.p(new cj(x, y, z));
        int level = CustomColors.getRedstoneLevel(state, 15);
        int col = redstoneColors.getColor(level);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.b(redF, greenF, blueF);
    }

    private static int getRedstoneLevel(alz state, int def) {
        afh block = state.c();
        if (!(block instanceof ajb)) {
            return def;
        }
        Comparable val = state.b((amo)ajb.P);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int index = (int)((double)((ns.a((float)timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int col = xpOrbColors.getColor(index);
        return col;
    }

    public static void updateWaterFX(beb fx, adq blockAccess, double x, double y, double z) {
        if (waterColors == null && blockColormaps == null) {
            return;
        }
        cj blockPos = new cj(x, y, z);
        RenderEnv renderEnv = RenderEnv.getInstance(blockAccess, BLOCK_STATE_WATER, blockPos);
        int col = CustomColors.getFluidColor(blockAccess, BLOCK_STATE_WATER, blockPos, renderEnv);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.b(redF, greenF, blueF);
    }

    private static int getLilypadColorMultiplier(adq blockAccess, cj blockPos) {
        if (lilyPadColor < 0) {
            return afi.bx.d(blockAccess, blockPos);
        }
        return lilyPadColor;
    }

    private static aui getFogColorNether(aui col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    private static aui getFogColorEnd(aui col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    private static aui getSkyColorEnd(aui col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static aui getSkyColor(aui skyColor3d, adq blockAccess, double x, double y, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = skyColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.a / 0.5f;
        float cGreen = (float)skyColor3d.b / 0.66275f;
        float cBlue = (float)skyColor3d.c;
        aui newCol = skyColorFader.getColor(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
        return newCol;
    }

    private static aui getFogColor(aui fogColor3d, adq blockAccess, double x, double y, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = fogColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.a / 0.753f;
        float cGreen = (float)fogColor3d.b / 0.8471f;
        float cBlue = (float)fogColor3d.c;
        aui newCol = fogColorFader.getColor(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
        return newCol;
    }

    public static aui getUnderwaterColor(adq blockAccess, double x, double y, double z) {
        if (underwaterColors == null) {
            return null;
        }
        int col = underwaterColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        aui newCol = underwaterColorFader.getColor(redF, greenF, blueF);
        return newCol;
    }

    private static int getStemColorMultiplier(afh blockStem, adq blockAccess, cj blockPos, RenderEnv renderEnv) {
        CustomColormap colors = stemColors;
        if (blockStem == afi.bl && stemPumpkinColors != null) {
            colors = stemPumpkinColors;
        }
        if (blockStem == afi.bm && stemMelonColors != null) {
            colors = stemMelonColors;
        }
        if (colors == null) {
            return -1;
        }
        int level = renderEnv.getMetadata();
        return colors.getColor(level);
    }

    public static boolean updateLightmap(adm world, float torchFlickerX, int[] lmColors, boolean nightvision) {
        if (world == null) {
            return false;
        }
        if (lightMapsColorsRgb == null) {
            return false;
        }
        int dimensionId = world.t.q();
        int lightMapIndex = dimensionId - lightmapMinDimensionId;
        if (lightMapIndex < 0 || lightMapIndex >= lightMapsColorsRgb.length) {
            return false;
        }
        CustomColormap lightMapRgb = lightMapsColorsRgb[lightMapIndex];
        if (lightMapRgb == null) {
            return false;
        }
        int height = lightMapRgb.getHeight();
        if (nightvision && height < 64) {
            return false;
        }
        int width = lightMapRgb.getWidth();
        if (width < 16) {
            CustomColors.warn("Invalid lightmap width: " + width + " for dimension: " + dimensionId);
            CustomColors.lightMapsColorsRgb[lightMapIndex] = null;
            return false;
        }
        int startIndex = 0;
        if (nightvision) {
            startIndex = width * 16 * 2;
        }
        float sun = 1.1666666f * (world.b(1.0f) - 0.2f);
        if (world.ac() > 0) {
            sun = 1.0f;
        }
        sun = Config.limitTo1(sun);
        float sunX = sun * (float)(width - 1);
        float torchX = Config.limitTo1(torchFlickerX + 0.5f) * (float)(width - 1);
        float gamma = Config.limitTo1(Config.getGameSettings().aJ);
        boolean hasGamma = gamma > 1.0E-4f;
        float[][] colorsRgb = lightMapRgb.getColorsRgb();
        CustomColors.getLightMapColumn(colorsRgb, sunX, startIndex, width, sunRgbs);
        CustomColors.getLightMapColumn(colorsRgb, torchX, startIndex + 16 * width, width, torchRgbs);
        float[] rgb = new float[3];
        for (int is = 0; is < 16; ++is) {
            for (int it = 0; it < 16; ++it) {
                for (int ic = 0; ic < 3; ++ic) {
                    float comp = Config.limitTo1(sunRgbs[is][ic] + torchRgbs[it][ic]);
                    if (hasGamma) {
                        float cg = 1.0f - comp;
                        cg = 1.0f - cg * cg * cg * cg;
                        comp = gamma * cg + (1.0f - gamma) * comp;
                    }
                    rgb[ic] = comp;
                }
                int r = (int)(rgb[0] * 255.0f);
                int g = (int)(rgb[1] * 255.0f);
                int b2 = (int)(rgb[2] * 255.0f);
                lmColors[is * 16 + it] = 0xFF000000 | r << 16 | g << 8 | b2;
            }
        }
        return true;
    }

    private static void getLightMapColumn(float[][] origMap, float x, int offset, int width, float[][] colRgb) {
        int xHigh;
        int xLow = (int)Math.floor(x);
        if (xLow == (xHigh = (int)Math.ceil(x))) {
            for (int y = 0; y < 16; ++y) {
                float[] rgbLow = origMap[offset + y * width + xLow];
                float[] rgb = colRgb[y];
                for (int i = 0; i < 3; ++i) {
                    rgb[i] = rgbLow[i];
                }
            }
            return;
        }
        float dLow = 1.0f - (x - (float)xLow);
        float dHigh = 1.0f - ((float)xHigh - x);
        for (int y = 0; y < 16; ++y) {
            float[] rgbLow = origMap[offset + y * width + xLow];
            float[] rgbHigh = origMap[offset + y * width + xHigh];
            float[] rgb = colRgb[y];
            for (int i = 0; i < 3; ++i) {
                rgb[i] = rgbLow[i] * dLow + rgbHigh[i] * dHigh;
            }
        }
    }

    public static aui getWorldFogColor(aui fogVec, bdb world, pk renderViewEntity, float partialTicks) {
        int worldType = world.t.q();
        switch (worldType) {
            case -1: {
                fogVec = CustomColors.getFogColorNether(fogVec);
                break;
            }
            case 0: {
                ave mc = ave.A();
                fogVec = CustomColors.getFogColor(fogVec, (adq)mc.f, renderViewEntity.s, renderViewEntity.t + 1.0, renderViewEntity.u);
                break;
            }
            case 1: {
                fogVec = CustomColors.getFogColorEnd(fogVec);
            }
        }
        return fogVec;
    }

    public static aui getWorldSkyColor(aui skyVec, bdb world, pk renderViewEntity, float partialTicks) {
        int worldType = world.t.q();
        switch (worldType) {
            case 0: {
                ave mc = ave.A();
                skyVec = CustomColors.getSkyColor(skyVec, (adq)mc.f, renderViewEntity.s, renderViewEntity.t + 1.0, renderViewEntity.u);
                break;
            }
            case 1: {
                skyVec = CustomColors.getSkyColorEnd(skyVec);
            }
        }
        return skyVec;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        void var8_10;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> keys = props.keySet();
        int countColors = 0;
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int id = CustomColors.getEntityId(name);
            int color = CustomColors.parseColor(value);
            if (id < 0 || color < 0) {
                CustomColors.warn("Invalid spawn egg color: " + string + " = " + value);
                continue;
            }
            while (list.size() <= id) {
                list.add(-1);
            }
            list.set(id, color);
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        int[] colors = new int[list.size()];
        boolean bl = false;
        while (var8_10 < colors.length) {
            colors[var8_10] = (Integer)list.get((int)var8_10);
            ++var8_10;
        }
        return colors;
    }

    private static int getSpawnEggColor(aax item, zx itemStack, int layer, int color) {
        int[] eggColors;
        int id = itemStack.i();
        int[] nArray = eggColors = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (eggColors == null) {
            return color;
        }
        if (id < 0 || id >= eggColors.length) {
            return color;
        }
        int eggColor = eggColors[id];
        if (eggColor < 0) {
            return color;
        }
        return eggColor;
    }

    public static int getColorFromItemStack(zx itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        zw item = itemStack.b();
        if (item == null) {
            return color;
        }
        if (item instanceof aax) {
            return CustomColors.getSpawnEggColor((aax)item, itemStack, layer, color);
        }
        return color;
    }

    private static float[][] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        zd[] dyeValues = zd.values();
        HashMap<String, zd> mapDyes = new HashMap<String, zd>();
        for (int i = 0; i < dyeValues.length; ++i) {
            zd dye = dyeValues[i];
            mapDyes.put(dye.l(), dye);
        }
        float[][] colors = new float[dyeValues.length][];
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            if (name.equals("lightBlue")) {
                name = "light_blue";
            }
            zd dye = (zd)mapDyes.get(name);
            int color = CustomColors.parseColor(value);
            if (dye == null || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            colors[dye.ordinal()] = rgb;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static float[] getDyeColors(zd dye, float[][] dyeColors, float[] colors) {
        if (dyeColors == null) {
            return colors;
        }
        if (dye == null) {
            return colors;
        }
        float[] customColors = dyeColors[dye.ordinal()];
        if (customColors == null) {
            return colors;
        }
        return customColors;
    }

    public static float[] getWolfCollarColors(zd dye, float[] colors) {
        return CustomColors.getDyeColors(dye, wolfCollarColors, colors);
    }

    public static float[] getSheepColors(zd dye, float[] colors) {
        return CustomColors.getDyeColors(dye, sheepColors, colors);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[32];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int code = Config.parseInt(name, -1);
            int color = CustomColors.parseColor(value);
            if (code < 0 || code >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[code] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index < 0 || index >= textColors.length) {
            return color;
        }
        int customColor = textColors[index];
        if (customColor < 0) {
            return color;
        }
        return customColor;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[arn.a.length];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int index = CustomColors.getMapColorIndex(name);
            int color = CustomColors.parseColor(value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[pe.a.length];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = string;
            int index = CustomColors.getPotionId(name);
            int color = CustomColors.parseColor(value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        pe[] potions = pe.a;
        for (int i = 0; i < potions.length; ++i) {
            pe potion = potions[i];
            if (potion == null || !potion.a().equals(name)) continue;
            return potion.d();
        }
        return -1;
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId < 0 || potionId >= potionColors.length) {
            return color;
        }
        int potionColor = potionColors[potionId];
        if (potionColor < 0) {
            return color;
        }
        return potionColor;
    }

    private static int getMapColorIndex(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals("air")) {
            return arn.b.M;
        }
        if (name.equals("grass")) {
            return arn.c.M;
        }
        if (name.equals("sand")) {
            return arn.d.M;
        }
        if (name.equals("cloth")) {
            return arn.e.M;
        }
        if (name.equals("tnt")) {
            return arn.f.M;
        }
        if (name.equals("ice")) {
            return arn.g.M;
        }
        if (name.equals("iron")) {
            return arn.h.M;
        }
        if (name.equals("foliage")) {
            return arn.i.M;
        }
        if (name.equals("snow")) {
            return arn.j.M;
        }
        if (name.equals("clay")) {
            return arn.k.M;
        }
        if (name.equals("dirt")) {
            return arn.l.M;
        }
        if (name.equals("stone")) {
            return arn.m.M;
        }
        if (name.equals("water")) {
            return arn.n.M;
        }
        if (name.equals("wood")) {
            return arn.o.M;
        }
        if (name.equals("quartz")) {
            return arn.p.M;
        }
        if (name.equals("adobe")) {
            return arn.q.M;
        }
        if (name.equals("magenta")) {
            return arn.r.M;
        }
        if (name.equals("lightBlue")) {
            return arn.s.M;
        }
        if (name.equals("light_blue")) {
            return arn.s.M;
        }
        if (name.equals("yellow")) {
            return arn.t.M;
        }
        if (name.equals("lime")) {
            return arn.u.M;
        }
        if (name.equals("pink")) {
            return arn.v.M;
        }
        if (name.equals("gray")) {
            return arn.w.M;
        }
        if (name.equals("silver")) {
            return arn.x.M;
        }
        if (name.equals("cyan")) {
            return arn.y.M;
        }
        if (name.equals("purple")) {
            return arn.z.M;
        }
        if (name.equals("blue")) {
            return arn.A.M;
        }
        if (name.equals("brown")) {
            return arn.B.M;
        }
        if (name.equals("green")) {
            return arn.C.M;
        }
        if (name.equals("red")) {
            return arn.D.M;
        }
        if (name.equals("black")) {
            return arn.E.M;
        }
        if (name.equals("gold")) {
            return arn.F.M;
        }
        if (name.equals("diamond")) {
            return arn.G.M;
        }
        if (name.equals("lapis")) {
            return arn.H.M;
        }
        if (name.equals("emerald")) {
            return arn.I.M;
        }
        if (name.equals("obsidian")) {
            return arn.J.M;
        }
        if (name.equals("netherrack")) {
            return arn.K.M;
        }
        return -1;
    }

    private static int[] getMapColors() {
        arn[] mapColors = arn.a;
        int[] colors = new int[mapColors.length];
        Arrays.fill(colors, -1);
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            arn mapColor = mapColors[i];
            if (mapColor == null) continue;
            colors[i] = mapColor.L;
        }
        return colors;
    }

    private static void setMapColors(int[] colors) {
        if (colors == null) {
            return;
        }
        arn[] mapColors = arn.a;
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            int color;
            arn mapColor = mapColors[i];
            if (mapColor == null || (color = colors[i]) < 0) continue;
            mapColor.L = color;
        }
    }

    private static int getEntityId(String name) {
        if (name == null) {
            return -1;
        }
        int id = pm.a((String)name);
        if (id < 0) {
            return -1;
        }
        String idName = pm.b((int)id);
        if (!Config.equals(name, idName)) {
            return -1;
        }
        return id;
    }

    private static void dbg(String str) {
        Config.dbg("CustomColors: " + str);
    }

    private static void warn(String str) {
        Config.warn("CustomColors: " + str);
    }

    public static int getExpBarTextColor(int color) {
        if (expBarTextColor < 0) {
            return color;
        }
        return expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        if (bossTextColor < 0) {
            return color;
        }
        return bossTextColor;
    }

    public static int getSignTextColor(int color) {
        if (signTextColor < 0) {
            return color;
        }
        return signTextColor;
    }

    public static interface IColorizer {
        public int getColor(adq var1, cj var2);

        public boolean isColorConstant();
    }
}

