// importScripts()での読み込みは、先に定義がないとエラーになるためこのファイルを作成
// (JavaScriptは実行時 型チェックのため定義が前後しても基本的には問題ないが
//  worker thread用 import関数は読み込みと同時に実行も行うため)


// UI thread用 定義
// Worker thead起動， post message
function postToWorker() {
	this.src = "js/worker_thread.js";
	this.workerMain = new Worker(this.src);
	this.workerMain.onmessage = null;
};
postToWorker.prototype.setMessageHandler = function (func) {
	this.workerMain.onmessage = func;
};
postToWorker.prototype.post = function (cmd) {
	if (null == cmd) {
		console.error("postToUI.post() cmd == null.");
		return;
	}
	if (null == this.workerMain.onmessage) {
		console.error("■■ Workerからの Msg handler未設定のまま Workerへ postMessage");
	}
	debuglog("== UI --> Worker =============\ntype=" + cmd.type + ", msgID=" + cmd.msgID + ",\nfrom=" + cmd.from + ", to=" + cmd.to + ",\ncmd=" + cmd.cmd + ", praram1=" + cmd.param1 + ", param2=" + cmd.param2 + ", param3=" + cmd.param3 + "\n=========================");
	this.workerMain.postMessage(cmd);
};


// Worker thread用 定義
// Post to UI thread
function postToUI() {
	self.onmessage = null;
};
postToUI.prototype.setMessageHandler = function (func) {
	self.onmessage = func;
};
postToUI.prototype.post = function (cmd) {
	if (null == cmd) {
		console.log("postToUI.post() cmd == null.");
		return;
	}
	if (undefined == cmd) {
		console.log("★★ postToUI.post() cmd == undefined");
		return;
	}
	if (null == self.onmessage) {
		debuglog("■■ UI threadからの Msg handler未設定のまま UI threadへ postMessage");
	}
	debuglog("__ Worker --> UI ________________" + "\ntype=" + cmd.type + ", msgID=" + cmd.msgID + ",\nfrom=" + cmd.from + ", to=" + cmd.to + ",\ncmd=" + cmd.cmd + ", praram1=" + cmd.param1 + ", param2=" + cmd.param2 + ", param3=" + cmd.param3 + "\n_______________________________");
	self.postMessage(cmd);
};