class CObjIDMgr {
	constructor() {
		this.ObjIDLen = 0;
		this.ObjIDarray = { '0': null };
	}

	debuglog(str) {
		debuglog("【ObjIDMgr】 " + str);
	}


	// DispObj.createから呼び出される
	registerDispObj(DispObj) {
		if (null == DispObj) {
			console.error("RegisterDispObj error. DispObj == null.");
			return -1;
		}
		// 今回作成するDispObjのNumberを保存
		let objNumber = this.ObjIDLen;
		this.ObjIDarray[objNumber] = DispObj;
		// 1件分の登録が完了したら、登録済みObjID数を更新
		this.ObjIDLen++;

		// 返すのは登録されているNumberになる
		return objNumber;
	}

	renderAll() {
		for (let i = 0; i < this.ObjIDLen; i++) {
			this.ObjIDarray[i].render();
		}
	}

	// 指定されたIDの実体(への参照)を返す
	getIDtoDispObj(id) {
		let numId = parseInt(id);
		if (this.ObjIDLen <= numId) {
			console.error("getIDtoDispObj() 指定されたIDが範囲外 id=" + id + ", numId=" + numId + ", this.ObjIDLen=" + this.ObjIDLen);
			return null;
		}
		return this.ObjIDarray[numId];
	}




	// Command処理 ----------------------
	createDispObj(type, rect, opt) {
		this.debuglog("createDispObj");
		var obj = new CDispObj();
		obj.create(type, rect, opt);
	}

	movebox(id, rect) {
		this.debuglog("movebox id=" + id);
		if (id < this.ObjIDLen) {
			this.ObjIDarray[id].movebox(rect.left, rect.top);
		}
	}

	scalebox(id, rect) {
		this.debuglog("scalebox id=" + id);
		if (id < this.ObjIDLen) {
			this.ObjIDarray[id].scalebox(rect);
		}
	}

	rollbox(id, degree) {
		this.debuglog('rollbox id=' + id + ', deg=' + degree);
		if (id < this.ObjIDLen) {
			this.ObjIDarray[id].rollbox(degree);
		}
	}

	deletebox(id) {
		// 要素を画面から隠す。削除はしない。Undoに対応するため。
		// 要素を DOM treeから 切り離すことで表示されないようにする
		if (id < this.ObjIDLen) {
			let displayField = document.getElementById('DispField');
			displayField.removeChild(this.ObjIDarray[id].DOMobject);
		}
	}
}	// class CObjIDMgr
