﻿
(function () {
	"use strict";


	// onLoadイベントも待つ
	document.addEventListener('load', onLoadStartHTML, false);
	function onLoadStartHTML() {
		console.log("onload");
	};

	
	
	// worker_main thread起動
	window.postToWorker = new postToWorker();
	window.postToWorker.setMessageHandler( receiveWorkerMessage );


	// UI thread初期化
	
	// Mgr obj生成
	// Create Mgr---
	var dom = document.getElementById( "DispField" );
	window.displayField = new CDisplayField(dom);
	window.displayField.initialize();
	window.ObjIDMgr = new CObjIDMgr();
	// -------------
	// 選択 itemの focus状態表示用
	// MouseDownで Focus移動
	window.partsFocus = new CPartsFocus();
	
	// 固定設置 palette button ------------------
	let palButtonlist =  document.getElementsByClassName( 'pal' );
	for( let cnt=0; cnt < palButtonlist.length; cnt++ ){
		palButtonlist[cnt].addEventListener( 'click', onClickPalButton, false );
	}
	
	let savelink = document.getElementById('save');
	savelink.addEventListener('click', onClickSaveLink, false);

	window.CSSPalette = new CSSPalette();
	window.CSSPalette.initialize();


	// --- test code -------
	var rect = new rectData( 105, 105, 155, 155 );
	var obj1 = new CCommandObj();
	obj1.createCommand( cmdType.request, cmdAddress.ObjIDMgr, cmdAddress.ObjIDMgr, cmdCmd.createTextbox, rect, null, 1 );
	window.postToWorker.post( obj1 );
	// ----------------------
	rect.setData( 110, 110, 160, 160 );
	var obj3 = new CCommandObj();
	obj3.createCommand( cmdType.request, cmdAddress.ObjIDMgr, cmdAddress.ObjIDMgr, cmdCmd.createTextbox, rect, null, 1 );
	window.postToWorker.post( obj3 );

	// ----------------------
	rect.setData( 150, 150, 0, 0 );
	var obj4 = new CCommandObj();
	obj4.createCommand( cmdType.request, cmdAddress.ObjIDMgr, cmdAddress.ObjIDMgr, cmdCmd.movebox, rect, 0, 2 );
	window.postToWorker.post( obj4 );







	// 画像読み込み等は待たずに実行開始
	window.startTime = window.performance.now();
	window.frameLength = 6.0;
	// 描画用無限ループ
	(function renderLoop () {
		let nowTime = window.performance.now();
//		let frame = Math.floor((nowTime - window.startTime) / (1000.0 / 60.0) % window.frameLength);

		window.displayField.render();
		window.ObjIDMgr.renderAll();
		
		window.partsFocus.render();

		requestAnimationFrame( renderLoop );
	})();




	// worker threadからの Message受信関数
	// UI threadで処理が必要な commandが送られてくる
	function receiveWorkerMessage(evt) {
		debuglog("receiveWorkerMessage() cmdReceive.");
		debuglog(evt.data);

		// commandの宛先ごとにcommand処理関数をテーブル化
		//											DispObj			  GroupObj			 CommandMgr		ObjIDMgr					   DispField						Dialog						InputMgr					 		SaveLoadMgr
		const executeCmdFunc = [executeCmdErr, executeCmdErr, executeCmdErr, executeCmdObjIdMgr, executeCmdDispField, executeCmdDialog, executeCmdInputMgr, executeCmdSaveLoadMgr];
		executeCmdFunc[evt.data.to](evt.data);
	};

	// command宛先の実体が worker thread側にあるにも関わらず、commandが UI threadに送られてきた場合のエラー出力
	function executeCmdErr(cmd) {
		console.log("[UI thread] cmd error.");
		console.log(cmd);
	};
	function executeCmdObjIdMgr(cmd) {
		debuglog("executeCmdObjIdMgr");

		switch (cmd.cmd) {
			case cmdCmd.createTextbox:	// Text box新規作成 (新規作成なので ObjIDは指定しない)
				//								type,  		rect		 text blob
				window.ObjIDMgr.createDispObj("textbox", cmd.param1, cmd.param2);
				break;
			case cmdCmd.createImagebox:	// Image box新規作成 (新規作成なので ObjIDは指定しない)
				//								type,  		rect		  image blob
				window.ObjIDMgr.createDispObj("imagebox", cmd.param1, cmd.param2);
				break;
			case cmdCmd.movebox:			// 移動
				//							objid		rect
				window.ObjIDMgr.movebox(cmd.param2, cmd.param1);
				break;
			case cmdCmd.scalebox:		// 拡大縮小
				//							objid		rect
				window.ObjIDMgr.scalebox(cmd.param1, cmd.param3);
				break;
			case cmdCmd.rollbox:			// 回転
				//							objid		degree
				window.ObjIDMgr.rollbox(cmd.param1, cmd.param2);
				break;
			case cmdCmd.deletebox:      // 要素の削除
				// Focus先が消えるため、focusも解除
				window.partsFocus.setClingingPartner(null);
				//                                                  objid
				window.ObjIDMgr.deletebox(cmd.param1);
				break;
			default:
				console.error('未定義のコマンド cmd=' + cmd.cmd);
				break;
		}
	};
	function executeCmdDispField(cmd) {
		debuglog("executeCmdDispField");
	};
	function executeCmdDialog(cmd) {
		debuglog("executeCmdDialog");
	};
	function executeCmdInputMgr(cmd) {
		debuglog("executeCmdInputMgr");
	};
	function executeCmdSaveLoadMgr(cmd) {
		debuglog("executeCmdSaveLoadMgr");
	};
	
	
    // Save --------------------
	// DisplayField 領域の innerHTMLを Blobとして保存
	function onClickSaveLink(evt) {
		debuglog('onClickSaveLink');

		// 余計な表示情報を消す
		// clear focus
		window.partsFocus.setClingingPartner(null);
		// 表示情報取得
		let displayInfo = window.displayField.DOMobject.innerHTML;
		// 保存先 file name
		let filename = 'savefile.txt';
		let save = new SaveFile();

		// save.saveFileBrowser(filename, displayInfo);
		save.saveFileApp(filename, displayInfo, cmp, err);
		// Anime GIFなどを指定されていると保存に時間がかかる
		// 保存中 dialogが必要
	};
	function cmp() {
		debuglog('cmp');
	};
	function err(arg) {
		console.error('err');
	}

	function onClickPalButton(evt) {
		debuglog('【onClickPalButton' + evt.target.dataset.palid + '】');
		switch (parseInt(evt.target.dataset.palid)) {
			case 0:
				removeFocusedObject();
				break;
			case 1:
			case 2:
			case 3:
			case 4:
			case 5:
				let color = parseInt(evt.target.dataset.value);
				setBkColorFocusedObject(color);
				break;
		}
	};
	
	function removeFocusedObject() {
		let focused = window.partsFocus.getFocusedObjid();
		if (null != focused) {
			// Delete command発行
			var obj1 = new CCommandObj();
			obj1.createCommand(cmdType.request, cmdAddress.ObjIDMgr, cmdAddress.ObjIDMgr, cmdCmd.deletebox, focused, null, 1);
			window.postToWorker.post(obj1);
		}
	};
	function setBkColorFocusedObject(bkColor) {
		let focused = window.partsFocus.getFocusedObjid();
		if (null != focused) {
			let obj = window.ObjIDMgr.getIDtoDispObj(focused);
			obj.DOMobject.style.backgroundColor = 'rgba(' + ((0xff000000 & bkColor) >>> 24) + ', '
														  + ((0x00ff0000 & bkColor) >>> 16) + ', '
														  + ((0x0000ff00 & bkColor) >>> 8) + ', '
														  + ((0x000000ff & bkColor) >>> 0) + ');';
			// 背景色変更 command 発行
		}
	};
	
})();
