const cmdType = {
	request: 0,
	response: 1,
	result: 2,
};
// commandの送信元，送信先オブジェクト
const cmdAddress = {
	DispObj: 0,
	GroupObj: 1,
	CommandMgr: 2,
	ObjIDMgr: 3,
	DisplayField: 4,
	Dialog: 5,
	InputMgr: 6,
	SaveLoadMgr: 7,
	Focus: 8,
};
const cmdCmd = {
	createTextbox: 0,
	createImagebox: 1,
	movebox: 10,
	scalebox: 11,
	rollbox: 12,
	deletebox: 100,
};



// Command本体定義
// Command処理 および postMessageでのデータやり取りに使用
// postMessageでは methodは送れないためここに methodは定義しないこと (必要ならtext変換してparamで渡し、evalで復元すること)
class CCommandObj {
	// constructorでは真偽値を返せないので createCommand関数で作成する
	constructor() {
		const undoList = [];
	}

	// toには最終到達 moduleを指定する。CommandMgrに要求するわけではないため
	createCommand(type, from, to, cmd, param1, param2, param3, msgID) {
		this.type = type;				// 'Request', 'Response', 'Result'
		this.msgID = msgID;			// msgID from postMessage (1～) 2つ以上のsequenceが同時に走るとき、処理が識別できれば(重複IDにならなければ)なんでもOK
		this.from = from;
		this.to = to;
		this.cmd = cmd;
		this.param1 = param1;
		this.param2 = param2;
		this.param3 = param3;

		//		return checkCommandInfo();

		debuglog("createCommand");
		debuglog(this);
		return true;
	}

	outputLog() {
		debuglog("commandObj data ------------\ntype=" + this.type + ", msgID=" + this.msgID + ",\nfrom=" + this.from + ", to=" + this.to + ",\ncmd=" + this.cmd + ", praram1=" + this.param1 + ", param2=" + this.param2 + ", param3=" + this.param3 + "\n---------------------------------");
	}

	// 設定されたコマンド情報の正当性チェック
	// 先に内部変数に値を入れてから呼び出すこと
	checkCommandInfo() {
		let retFrom = checkInfoFrom();
		let retTo = checkInfoTo();
		let retCmd = checkInfoCmd();
		let retParam1 = checkInfoParam1();
		let retParam2 = checkInfoParam2();

		if (true == retFrom
		&& true == retTo
		&& true == retCmd
		&& true == retParam1
		&& true == retParam2) {
			return true;
		}
		else {
			return false;
		}
	}
	checkInfoFrom() {
		let ret = checkCmdFromTo(this.from);
		if (false == ret) {
			// 指定された Command発行元ID誤り
			console.log("Cmd From ID Error.");
			console.log(this);
			return false;
		}
		return true;
	}
	checkInfoTo() {
		let ret = checkCmdFromTo(this.to);
		if (false == ret) {
			// 指定された Command発行元ID誤り
			console.log("Cmd To ID Error.");
			console.log(this);
			return false;
		}
		return true;
	}
	// 送信先，送信元確認用
	checkCmdFromTo(str) {
		let fromto = getFromToStr(str);
		if (null == fromto) {
			console.log("cmdmgr error. fromto=" + str);
			return false;
		}
		// 抽出文字が送信先ごと関数tblに要素として存在するか確認
		if (!fromto in eachDestOfFuncTbl) {
			console.log("cmdmgr error. 要素がFuncTblにない fromto=" + str);
			return false;
		}
		if (null == eachDestOfFuncTbl[fromto]) {
			console.log("cmdmgr error. FuncTblにfunc未登録 fromto=" + str);
			return false;
		}
		return true;
	}
	checkInfoCmd() {
		return true;
	}
	checkInfoParam1() {
		return true;
	}
	checkInfoParam2() {
		return true;
	}
	getFromToStr(str) {
		// 数字部分以外を抽出
		let index = /[^0-9]/.exec(str);
		if (index.index < 1) return null;
		return index;
	}
} // class CCommandObj
