/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package seisekilist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author ishin
 */
public class ReadCSVData {

    private List<ScoreData> csvData;
    
    public ReadCSVData() {
    }

    public List<ScoreData> readScoreData(File csvFile) {
        csvData = new ArrayList<>();
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile))) {
            String line;
            while ((line = br.readLine()) != null) {
                csvData.add(parseScoreData(line));
            }
        } catch (FileNotFoundException ex) {
            Logger.getLogger(ReadCSVData.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(ReadCSVData.class.getName()).log(Level.SEVERE, null, ex);
        }
        return csvData;
    }

    private ScoreData parseScoreData(String value) {
        ScoreData sd = new ScoreData();
        List<String> sdata = new ArrayList<>();

        String[] data = value.split(",");
        
        sd.setID(data[0]);
        sd.setName(data[1]);
        
        for (int i = 2; i < data.length; i++) {
            sdata.add(data[i]);
        }
        sd.setScore(sdata);
        sd.setAverage(Calc.getAverage(sdata));
        sd.setTotal(Calc.getTotal(sdata));
        
        return sd;
    }
}
