use strict;
use warnings qw(all);
use utf8;

use Test;

BEGIN {
	plan(
		tests	=> 21,
	);
}

################
# Test case 1
# Load test for Swatchdog/Actions/exec_command.pl
################
eval { require 'Swatchdog/Actions/exec_command.pl'; return 1;};
ok($@, '');
croak() unless ($@ eq '');

require 'Swatchdog/Actions/exec_command.pl';

my	$result;
my	$code = sub ($$) {
	$result = sprintf "pid: %d, exitCode: 0x%X\n", @_
};
################
# Test case 2 - 4
# set new sigchld handler: name, no priority.
################
Swatchdog::Actions::setSigchldHandler('+name-prio', $code);
ok($Swatchdog::Actions::SigchldHandler[0]->{name}, '+name-prio');
ok($Swatchdog::Actions::SigchldHandler[0]->{code} eq $code);
ok($Swatchdog::Actions::SigchldHandler[0]->{prio}, 0);

################
# Test case 5-7
# set new sigchld handler: name, low priority.
################
Swatchdog::Actions::setSigchldHandler('+name+prio', $code, 1);
ok($Swatchdog::Actions::SigchldHandler[1]->{name}, '+name+prio');
ok($Swatchdog::Actions::SigchldHandler[1]->{code} eq $code);
ok($Swatchdog::Actions::SigchldHandler[1]->{prio}, 1);

################
# Test case 8-10
# set new sigchld handler: no name, hight priority.
################
Swatchdog::Actions::setSigchldHandler(undef, "$code", -1);
ok(!defined $Swatchdog::Actions::SigchldHandler[0]->{name});
ok($Swatchdog::Actions::SigchldHandler[0]->{code} eq $code);
ok($Swatchdog::Actions::SigchldHandler[0]->{prio}, -1);

################
# Test case 11-13
# set new sigchld handler: no name, no priority.
################
Swatchdog::Actions::setSigchldHandler(undef, "$code");
ok(!defined $Swatchdog::Actions::SigchldHandler[1]->{name});
ok($Swatchdog::Actions::SigchldHandler[1]->{code} eq $code);
ok($Swatchdog::Actions::SigchldHandler[1]->{prio}, 0);

################
# Test case 14, 15
# unset named sigchld handler
################
Swatchdog::Actions::setSigchldHandler('+name-prio');
ok(scalar(@Swatchdog::Actions::SigchldHandler), 3);
ok($Swatchdog::Actions::SigchldHandler[2]->{name} ne '+name-prio');

################
# Test case 16, 17
# unset noname sigchld handler
################
Swatchdog::Actions::setSigchldHandler(undef);
ok(scalar(@Swatchdog::Actions::SigchldHandler), 1);
ok($Swatchdog::Actions::SigchldHandler[0]->{name}, '+name+prio');

################
# Test case 18
# not execute sigchld handler
################
system('printf "\npid: %d\n" $$');
sleep 1;
ok(!defined $result);

################
# Test case 19, 20
# execute sigchld handler
################
Swatchdog::Actions::exec_command(COMMAND => 'printf "\npid: %d\n" $$');
sleep 1;
ok(defined $result);
ok($result, qr/^pid: [1-9]\d+, exitCode: 0x[0-9A-F]+$/);

################
# Test case 21
# no sigchld handler
################
Swatchdog::Actions::setSigchldHandler('+name+prio');
undef $result;
Swatchdog::Actions::exec_command(COMMAND => 'printf "\npid: %d\n" $$');
sleep 1;
ok(!defined $result);
