use strict;
use warnings qw(all);
use utf8;

use Test;

use vars qw(
	$OutputDetail
);

BEGIN {
	plan(
		tests	=> 6,
	);
}

$OutputDetail = 0;

package Swatchdog::Actions::Perl::TestAction;
use strict;
use warnings qw(all);
use utf8;

use threads;
use threads::shared;
use Data::Dumper;

use Swatchdog::Actions::Perl;

use vars qw(
	@ISA
	$Dealed
	$Asynchronous
);

@ISA = qw(Swatchdog::Actions::Perl);
$Dealed = 0; share($Dealed);
$Asynchronous = 0; share($Asynchronous);

sub new($@) {
	my $class = shift;
	my $self  = Swatchdog::Actions::Perl->new(@_);

	bless $self, $class;

	return $self;
}

sub mustEventBeDealtWith($) {
	my	$self = shift;
	$self->logTrace('BEGIN %s', (caller 0)[3]);

	$Asynchronous = $self->asynchronous();

	$self->logTrace('END   %s', (caller 0)[3]);
	return $self->{property}->{mustDealWith};
}

sub dealWithEvent($) {
	my $self = shift;
	$self->logDebug('BEGIN %s', (caller 0)[3]);

	$Dealed = 1;

	$self->logDebug('END   %s', (caller 0)[3]);
}
package main;

my	$pa = Swatchdog::Actions::Perl->new(
	asynchronous => 0,
);
################
# Test case 1
# Registrate
################
$pa->registerSubActionClass('Swatchdog::Actions::Perl::TestAction');
ok(exists $pa->{subActionClasses}->{'Swatchdog::Actions::Perl::TestAction'});

################
# Test case 2
# Unregistrate
################
$pa->unregisterSubActionClass('Swatchdog::Actions::Perl::TestAction');
ok(!exists $pa->{subActionClasses}->{'Swatchdog::Actions::Perl::TestAction'});

################
# Test case 3, 4
# not propagate
################
$pa->registerSubActionClass('Swatchdog::Actions::Perl::TestAction');
$pa->asynchronous(1);
$pa->asyncPropagation(0);
$Swatchdog::Actions::Perl::TestAction::Dealed = 0;
{
	local	$Swatchdog::Actions::Perl::Asynchronous = 0;

	$pa->onEventOccurred(mustDealWith => 1);
}
threads->yield();
sleep 1;
ok(!$Swatchdog::Actions::Perl::TestAction::Asynchronous);
ok($Swatchdog::Actions::Perl::TestAction::Dealed);

################
# Test case 5, 6
# propagate
################
$pa->registerSubActionClass('Swatchdog::Actions::Perl::TestAction');
$pa->asynchronous(1);
$pa->asyncPropagation(1);
$Swatchdog::Actions::Perl::TestAction::Dealed = 0;
{
	local	$Swatchdog::Actions::Perl::Asynchronous = 0;

	$pa->onEventOccurred(mustDealWith => 0);
}
threads->yield();
sleep 1;
ok($Swatchdog::Actions::Perl::TestAction::Asynchronous);
ok(!$Swatchdog::Actions::Perl::TestAction::Dealed);
