use strict;
use warnings qw(all);
use utf8;

use Test;

use vars qw(
	$OutputDetail
);

BEGIN {
	plan(
		tests	=> 57,
	);
}

$OutputDetail = 0;

package Swatchdog::Actions::Perl::TestAction;
use strict;
use warnings qw(all);
use utf8;

use threads;
use threads::shared;
use Data::Dumper;

use Swatchdog::Actions::Perl;

use vars qw(
	@ISA
	$Result
);

@ISA = qw(Swatchdog::Actions::Perl);
$Result = 0; share($Result);

sub new($@) {
	my $class = shift;
	my $self  = Swatchdog::Actions::Perl->new(@_);

	bless $self, $class;
	$self->{logHistory} = [];

	return $self;
}

sub log($$$@) {
	my	$self = shift;
	my	$level = shift;
	my	($format, @args) = @_;
	local	$Data::Dumper::Purity = 1;
	local	$Data::Dumper::Terse = 1;
	local	$Data::Dumper::Indent = 0;

	my	$log = {
		level => $level, message => sprintf($format, @args)
	};

	push @{$self->{logHistory}}, $log;
	printf STDERR "\t%s,\n", Dumper($log)	if ($main::OutputDetail);
}

sub logEventOccurred($) {
	my	$self = shift;

	$self->logInfo('A test event has occurred.');
}

sub mustEventBeDealtWith($) {
	my	$self = shift;
	$self->logTrace('BEGIN %s', (caller 0)[3]);

	$self->logTrace('END   %s', (caller 0)[3]);
	return $self->{property}->{mustDealWith};
}

sub dealWithEvent($) {
	my $self = shift;
	$self->logDebug('BEGIN %s', (caller 0)[3]);

	$Result = 1;

	$self->logDebug('END   %s', (caller 0)[3]);
}
package main;

sub testLogHistory($@) {
	my $pa = shift;
	my @expected = @_;

	ok(scalar(@{$pa->{logHistory}}), scalar(@expected));
	for (my $i = 0; $i < scalar(@expected); $i++) {
		ok(
			ref($expected[$i]->{level}) eq 'Regexp'
				? $pa->{logHistory}->[$i]->{level} =~ $expected[$i]->{level}
				: $pa->{logHistory}->[$i]->{level} eq $expected[$i]->{level}
				and
			ref($expected[$i]->{message}) eq 'Regexp'
				? $pa->{logHistory}->[$i]->{message} =~ $expected[$i]->{message}
				: $pa->{logHistory}->[$i]->{message} eq $expected[$i]->{message}
		);
	}
}

my	$pa = Swatchdog::Actions::Perl::TestAction->new(
	asynchronous => 0,
);
################
# Test case 1-2
# Event properties
################
$pa->asynchronous(0);
$pa->useThread(1);
$Swatchdog::Actions::Perl::TestAction::Result = 0;
$pa->{logHistory} = [];
print STDERR "\n"	if ($OutputDetail);
$pa->onEventOccurred(mustDealWith => 0);
ok(defined $pa->{property}->{mustDealWith});
croak() unless (defined $pa->{property}->{mustDealWith});
ok($pa->{property}->{mustDealWith}, 0);
croak() unless ($pa->{property}->{mustDealWith} == 0);

################
# Test case 3-14
# sync, useThread, no deal
################
ok(!$Swatchdog::Actions::Perl::TestAction::Result);
testLogHistory($pa,
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::onEventOccurred'},
	{'level' => 'info','message' => 'A test event has occurred.'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::doit'},
	{'message' => 'BEGIN Swatchdog::Actions::Perl::TestAction::mustEventBeDealtWith','level' => 'trace'},
	{'message' => 'END   Swatchdog::Actions::Perl::TestAction::mustEventBeDealtWith','level' => 'trace'},
	{'level' => 'info','message' => 'It is not necessary to deal.'},
	{'message' => 'END   Swatchdog::Actions::Perl::doit','level' => 'trace'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::_subActions'},
	{'message' => 'END   Swatchdog::Actions::Perl::_subActions','level' => 'trace'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::onEventOccurred'},
);

################
# Test case 15-27
# sync, useThread, deal
################
$pa->asynchronous(0);
$pa->useThread(1);
$Swatchdog::Actions::Perl::TestAction::Result = 0;
$pa->{logHistory} = [];
print STDERR "\n"	if ($OutputDetail);
$pa->onEventOccurred(mustDealWith => 1);
ok($Swatchdog::Actions::Perl::TestAction::Result);
testLogHistory($pa,
	{'message' => 'BEGIN Swatchdog::Actions::Perl::onEventOccurred','level' => 'trace'},
	{'level' => 'info','message' => 'A test event has occurred.'},
	{'message' => 'BEGIN Swatchdog::Actions::Perl::doit','level' => 'trace'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::TestAction::mustEventBeDealtWith'},
	{'message' => 'END   Swatchdog::Actions::Perl::TestAction::mustEventBeDealtWith','level' => 'trace'},
	{'level' => 'debug','message' => 'BEGIN Swatchdog::Actions::Perl::TestAction::dealWithEvent'},
	{'message' => 'END   Swatchdog::Actions::Perl::TestAction::dealWithEvent','level' => 'debug'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::doit'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::onEventOccurred'},
);

################
# Test case 28-35
# async, useThread, no deal
################
$pa->asynchronous(1);
$pa->useThread(1);
$Swatchdog::Actions::Perl::TestAction::Result = 0;
$pa->{logHistory} = [];
print STDERR "\n"	if ($OutputDetail);
$pa->onEventOccurred(mustDealWith => 0);
threads->yield();
sleep 1;
ok(!$Swatchdog::Actions::Perl::TestAction::Result);
testLogHistory($pa,
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::onEventOccurred'},
	{'message' => 'A test event has occurred.','level' => 'info'},
	{'message' => qr/^create a thread #\d+$/,'level' => 'debug'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::onEventOccurred'},
);

################
# Test case 36-43
# async, useThread, deal
################
$pa->asynchronous(1);
$pa->useThread(1);
$Swatchdog::Actions::Perl::TestAction::Result = 0;
$pa->{logHistory} = [];
print STDERR "\n"	if ($OutputDetail);
$pa->onEventOccurred(mustDealWith => 1);
threads->yield();
sleep 1;
ok($Swatchdog::Actions::Perl::TestAction::Result);
testLogHistory($pa,
	{'message' => 'BEGIN Swatchdog::Actions::Perl::onEventOccurred','level' => 'trace'},
	{'level' => 'info','message' => 'A test event has occurred.'},
	{'message' => qr/^create a thread #\d+$/,'level' => 'debug'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::onEventOccurred'},
);

################
# Test case 44-50 
# async, no useThread, no deal
################
$pa->asynchronous(1);
$pa->useThread(0);
$Swatchdog::Actions::Perl::TestAction::Result = 0;
$pa->{logHistory} = [];
print STDERR "\n"	if ($OutputDetail);
$pa->onEventOccurred(mustDealWith => 0);
sleep 1;
testLogHistory($pa,
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::onEventOccurred'},
	{'message' => 'A test event has occurred.','level' => 'info'},
	{'message' => qr/^create sub process #\d+$/,'level' => 'debug'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::onEventOccurred'},
);

################
# Test case 51-57
# async, no useThread, deal
################
$pa->asynchronous(1);
$pa->useThread(0);
$Swatchdog::Actions::Perl::TestAction::Result = 0;
$pa->{logHistory} = [];
print STDERR "\n"	if ($OutputDetail);
$pa->onEventOccurred(mustDealWith => 1);
sleep 1;
testLogHistory($pa,
	{'message' => 'BEGIN Swatchdog::Actions::Perl::onEventOccurred','level' => 'trace'},
	{'level' => 'info','message' => 'A test event has occurred.'},
	{'message' => qr/^create sub process #\d+$/,'level' => 'debug'},
	{'level' => 'trace','message' => 'BEGIN Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::_subActions'},
	{'level' => 'trace','message' => 'END   Swatchdog::Actions::Perl::onEventOccurred'},
);
