use strict;
use warnings qw(all);
use utf8;

use Test;

BEGIN {
	plan(
		tests	=> 16,
	);
}

package Swatchdog::Actions::Perl::TestAction;
use strict;
use warnings qw(all);
use utf8;

use Swatchdog::Actions::Perl;

use vars qw(
	@ISA
);

@ISA = qw(Swatchdog::Actions::Perl);

sub new($@) {
	my $class = shift;
	my $self  = Swatchdog::Actions::Perl->new(
		lastLogLevel => undef,
		lastLogMessage => undef,
		@_
	);

	bless $self, $class;

	return $self;
}

sub lastLogLevel($;$) {
	return $_[0]->attribute('lastLogLevel', @_[1 .. $#_]);
}
sub lastLogMessage($;$) {
	return $_[0]->attribute('lastLogMessage', @_[1 .. $#_]);
}

sub log($$$@) {
	my	$self = shift;
	my	$level = shift;
	my	($format, @args) = @_;

	$self->lastLogLevel($level);
	$self->lastLogMessage(sprintf($format, @args));
}
package main;

my	$pa = Swatchdog::Actions::Perl::TestAction->new();

################
# Test case 1 .. 12
# General logging methdos
################
my	$format = 'The level of this log message is "%s".';

foreach my $level (qw(trace debug info warn error fatal)) {
	my	$code = sprintf('$pa->log%s%s($format, $level)',
		uc(substr($level, 0, 1)), substr($level, 1)
	);

	eval $code;
	ok($pa->lastLogLevel, $level);
	ok($pa->lastLogMessage, sprintf($format, $level));
}

################
# Test case 13, 14
# logEventOccurred method
################
$pa->logEventOccurred();
ok($pa->lastLogLevel, 'info');
ok($pa->lastLogMessage, 'Something has occurred.');

################
# Test case 15, 16
# logSkipOverDealing method
################
$pa->logSkipOverDealing();
ok($pa->lastLogLevel, 'info');
ok($pa->lastLogMessage, 'It is not necessary to deal.');
