use strict;
use warnings qw(all);
use utf8;

use Test;

BEGIN {
	plan(
		tests	=> 13,
	);
}

################
# Test case 1
# Load test for Swatchdog::Actions::Perl
################
eval { require Swatchdog::Actions::Perl; return 1;};
ok($@, '');
croak() unless ($@ eq '');

my	$pa = Swatchdog::Actions::Perl->new(a1 => 'OK');

################
# Test case 2, 3
# Default value of the attribute asynchronous
################
ok($pa->asynchronous, $Swatchdog::Actions::Perl::Asynchronous);
$pa->asynchronous(!$Swatchdog::Actions::Perl::Asynchronous);
ok(!$pa->asynchronous);
$pa->asynchronous($Swatchdog::Actions::Perl::Asynchronous);

################
# Test case 4, 5
# Default value of the attribute asyncPropagation
################
ok($pa->asyncPropagation, $Swatchdog::Actions::Perl::AsyncPropagation);
$pa->asyncPropagation(!$Swatchdog::Actions::Perl::AsyncPropagation);
ok(!$pa->asyncPropagation);
$pa->asyncPropagation($Swatchdog::Actions::Perl::AsyncPropagation);

################
# Test case 6, 7
# Default value of the attribute useThread
################
ok($pa->useThread, $Swatchdog::Actions::Perl::UseThread);
$pa->useThread(!$Swatchdog::Actions::Perl::UseThread);
ok(!$pa->useThread);
$pa->useThread($Swatchdog::Actions::Perl::UseThread);

################
# Test case 8, 9
# Default value of the attribute maxForkRetryCount
################
ok($pa->maxForkRetryCount, $Swatchdog::Actions::Perl::MaxForkRetryCount);
$pa->maxForkRetryCount($Swatchdog::Actions::Perl::MaxForkRetryCount + 1);
ok($pa->maxForkRetryCount, $Swatchdog::Actions::Perl::MaxForkRetryCount + 1);
$pa->maxForkRetryCount($Swatchdog::Actions::Perl::MaxForkRetryCount);

################
# Test case 10, 11
# Default value of the attribute forkRetryInterval
################
ok($pa->forkRetryInterval, $Swatchdog::Actions::Perl::ForkRetryInterval);
$pa->forkRetryInterval($Swatchdog::Actions::Perl::ForkRetryInterval + 1);
ok($pa->forkRetryInterval, $Swatchdog::Actions::Perl::ForkRetryInterval + 1);
$pa->forkRetryInterval($Swatchdog::Actions::Perl::ForkRetryInterval);

################
# Test case 12, 13
# Value of custom attribute
################
ok($pa->attribute('a1'), 'OK');
$pa->attribute('a1', 'NG');
ok($pa->attribute('a1'), 'NG');
$pa->attribute('a1', 'OK');
