/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardOnlyTable
implements ITable {
    private static final Logger logger = LoggerFactory.getLogger((Class)ForwardOnlyTable.class);
    private final ITable _table;
    private int _lastRow = -1;

    public ForwardOnlyTable(ITable table) {
        this._table = table;
    }

    public ITableMetaData getTableMetaData() {
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        throw new UnsupportedOperationException();
    }

    public Object getValue(int row, String column) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        if (row < this._lastRow) {
            throw new UnsupportedOperationException("Cannot go backward!");
        }
        this._lastRow = row;
        return this._table.getValue(row, column);
    }
}

