/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTable
implements ITable {
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractTable.class);

    protected void assertValidRowIndex(int row) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("assertValidRowIndex(row={}) - start", (Object)Integer.toString(row));
        }
        this.assertValidRowIndex(row, this.getRowCount());
    }

    protected void assertValidRowIndex(int row, int rowCount) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("assertValidRowIndex(row={}, rowCount={}) - start", (Object)Integer.toString(row), (Object)Integer.toString(rowCount));
        }
        if (row < 0) {
            throw new RowOutOfBoundsException(row + " < 0");
        }
        if (row >= rowCount) {
            throw new RowOutOfBoundsException(row + " >= " + rowCount);
        }
    }

    protected void assertValidColumn(String columnName) throws DataSetException {
        logger.debug("assertValidColumn(columnName={}) - start", (Object)columnName);
        ITableMetaData metaData = this.getTableMetaData();
        Columns.getColumnValidated(columnName, metaData.getColumns(), metaData.getTableName());
    }

    protected int getColumnIndex(String columnName) throws DataSetException {
        logger.debug("getColumnIndex(columnName={}) - start", (Object)columnName);
        ITableMetaData metaData = this.getTableMetaData();
        return metaData.getColumnIndex(columnName);
    }
}

