#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

#atode, 詳細設定の保存
#atode, 自動ノーマライズ→息.wavなど音が小さい雑音収録のときに耳が壊れるかも
#atode, 音名、タイプのリストをマルチカラムリストにする
#atode, 録音済みの音を色分けするとか
#atode, 録音済みのファイル数をカウントして表示（あと少し!と思えるかも??）

# - 音名リストでSHIFT+ホイールスクロールしてリストを短くする場合、
#   最小３行まで縮小できるようにした。

# 2.0-b091205
# - アイコンにD&Dしたときに自動でそのフォルダを保存フォルダにして起動する。

# 2.0-b090803
# - 音名、発声タイプリストボックスの横幅をctrl+wheelで変更可にした。
#   (ただし、現状では動作が若干よろしくない)

# 2.0-b090724
# - ガイドBGMの設定読み込み部分のバグ修正。

# 2.0-b090720
# - 自動収録モードを追加。
#   - オプション→収録方法の設定窓を作成。
#   - rキーで自動収録開始/停止するように変更。
#   - Rキーで自動収録終了のバインドを追加。
# - 「m」キーを押してもメトロノームの再生が止まらないのを訂正。

# 2.0-b090709
# - 収録関係をoremoに、原音パラメータ設定関係をsetParamに分離した
# - サブルーチンは proc.tcl に、大域変数はglobalVar.tclにまとめた
#   (exe化の際には:rで一ファイルに結合)
# - 「動作切替」メニューを削除した。
#   - オプション→録音機能で録音機能ON/OFF切り替え
#   - ファイル→保存フォルダのwavファイルから～ でreclist.txt生成
# - メトロノーム機能を追加。
# - setParamに原音パラメータ一覧を実装。数値入力、copy&pasteなど。
# - setParamから自動原音設定ツール(外部ツール、utau_lib_analyze110）を呼ぶようにした。
# - reclist.txtに「とぅ」「どぅ」を追加。
# - アイコン埋め込み。(exe化時にicoファイルを*.vfs/tclkit.icoにコピーする)
# - oremo.exe と同じフォルダに oremo-init.tclがあれば自動的に読み込む

# 2.0-b090613
# - 原音パラメータの読み込み/保存：上書き確認。ファイル名指定可にした
# - 原音パラメータを読み込んだら表示中の画面に即反映させるようにした
# - ファイルメニューの文を変更("oto.ini"→"原音パラメータ")

# 2.0-b090611
# - ファイルメニュー追加：音名リストの読み込み/保存、発声タイプの読み込み
# - 起動時にreclist.txt、typelist.txtが無い場合にダイアログを表示
# - コマンドラインからの起動時の第一引数で保存フォルダを指定
# - 波形再読み込み(cにキーバインド)

# 2.0-b090506
# oto.iniの読み込み

# 2.0-b090213
# - 音叉機能の機能向上(リピート再生、キーバインド割り当て)
# - 原音設定（手動設定(F1-F6にキーバインド)）
# - 原音設定（自動設定。左右ブランクのみ）
# - 原音設定（ファイル保存。oto.iniにパラメータを保存）
# - 動作モード切替（録音機能ON/OFF、原音設定機能ON/OFF）
# - 音名リスト取得（保存フォルダにあるwavファイルから音名リストを構成可能）
# - 画面構成変更（収録音がそこそこ長い文字列になっても表示可能に）
# - その他

package require -exact snack 2.2
#if {$::tcl_platform(platform) == "windows"} {
#  ttk::style theme use clam ;#xpnative
#}

package require Tktable
#package require tkdnd

# macos
source [file join [file dirname [info script]] proc.tcl]         ;# サブルーチン読み込み
source [file join [file dirname [info script]] globalVar.tcl]    ;# 大域変数読み込み

#---------------------------------------------------
# main - メインルーチン (初期化)

set v(appname) OREMO
set v(version) 2.0-b110812         ;# ソフトのバージョン番号
set v(showParam) 0
set startup(readTypeList) 1
set startup(readRecList) 1
set startup(makeRecListFromDir) 0
set startup(choosesaveDir) 0
set startup(initFile)     $topdir/oremo-init.tcl
set startup(textFile)     $scriptDir/message/oremo-text.tcl
set startup(procTextFile) $scriptDir/message/proc-text.tcl

#---------------------------------------------------
# 引数チェック
# memo: oremo.tcl -- -option とするのが無難。--がないとwishのオプションと思われる様子
if {$::tcl_platform(platform) == "windows"} {
  set i 0
  while {$i < $argc} {
    set opt [lindex $argv $i]

    switch $opt {
      "-saveDir" {
        incr i
        set v(saveDir) [lindex $argv $i]
      }
      "-script" {
        incr i
        set startup(initFile) [lindex $argv $i]
      }
      default {
        ;# アイコンにD&Dされたときの対応
        set opt [encoding convertfrom $opt]  ;# tcl/tk内部コード(utf-8)にする
        set opt [file normalize $opt]
        if [file isdirectory $opt] {            ;# フォルダのD&D
          set v(saveDir) $opt
          set startup(choosesaveDir) 0
        } elseif [file isdirectory [file dirname $opt]] { ;# それ以外のファイル
          set v(saveDir) [file dirname $opt]
          set startup(choosesaveDir) 0
        } else {
          puts "error: invalid option: $opt"
          usage
        }
      }
    }
    incr i
  }
}

foreach fn [list $startup(textFile) $startup(procTextFile)] {
  if {[file exists $fn]} {
    source $fn
  } else {
    tk_messageBox -message "can not find textFile ($fn)" \
      -title "Error" -icon error
    exit
  }
}
if {[file exists $startup(initFile)]} {
  source $startup(initFile)
}

audioSettings ;# オーディオデバイス関連の初期化
fontSetting   ;# 日本語フォントを設定する
setSinScale   ;# 平均律の各音階の周波数を求める


#---------------------------------------------------
#
# メニューの設定
#
snack::menuInit

snack::menuPane    $t(file)
snack::menuCommand $t(file) $t(file,choosesaveDir) {
  choosesaveDir
  resetDisplay
}
snack::menuCommand $t(file) $t(file,readRecList)   {readRecList; resetDisplay}
snack::menuCommand $t(file) $t(file,saveRecList)   saveRecList
snack::menuCommand $t(file) $t(file,readTypeList)  {readTypeList; resetDisplay}
snack::menuCommand $t(file) $t(file,makeRecList)   {
  makeRecListFromDir
  resetDisplay
  set v(msg) $t(file,makeRecList,msg)
}
snack::menuCommand $t(file) $t(file,makeRecListFromUst)   {
  makeRecListFromUst
  resetDisplay
  set v(msg) $t(file,makeRecListFromUst,msg)
}
snack::menuCommand $t(file) $t(file,saveSettings) saveSettings
snack::menuCommand $t(file) $t(file,Exit)         Exit

snack::menuPane    $t(show)
snack::menuCheck   $t(show)   $t(show,showWave)     v(showWave) toggleWave
snack::menuCheck   $t(show)   $t(show,showSpec)     v(showSpec) toggleSpec
snack::menuCheck   $t(show)   $t(show,showpow)      v(showpow)  togglePow
snack::menuCheck   $t(show)   $t(show,showf0)       v(showf0)   toggleF0
snack::menuCommand $t(show)   $t(show,pitchGuide)   pitchGuide
snack::menuCommand $t(show)   $t(show,tempoGuide)   tempoGuide

snack::menuPane    $t(option)
snack::menuCheck   $t(option) $t(option,removeDC)   v(removeDC) {}
snack::menuCommand $t(option) $t(option,bgmGuide)   bgmGuide
if {$::tcl_platform(os) != "Darwin"} {
  snack::menuCommand $t(option) $t(option,ioSettings) ioSettings
} else {
  snack::menuCommand $t(option) $t(option,ioSettings) {
    tk_messageBox -message $t(option,ioSettingsMsg) -title "info" -icon info
  }
}
snack::menuCommand $t(option) $t(option,settings)   settings

snack::menuPane    $t(oto)
snack::menuCascade $t(oto)     $t(oto,auto)
snack::menuCommand $t(oto,auto) $t(oto,auto,tandoku)   estimateParam
snack::menuCommand $t(oto,auto) $t(oto,auto,renzoku)   genParam

snack::menuPane    $t(help)
if {$::tcl_platform(os) == "Darwin"} {
  snack::menuCommand $t(help) $t(help,offlineHelp) {onlineHelp $topdir/manual/tutorial.html}
} else {
  snack::menuCommand $t(help) $t(help,onlineHelp) {onlineHelp http://freett.com/nwp8861/soft/oremo/manual/tutorial.html}
}
snack::menuCommand $t(help) $t(help,Version)    Version

set rclickMenu  [menu .popmenu   -tearoff false]

#---------------------------------------------------
#
# 窓の設定
#
snack::createIcons    ;# アイコンを使用する

# 0. 収録中の音名を表示するフレーム
frame .recinfo
grid  .recinfo -row 0 -columnspan 2 -sticky nw

# 0-1. 収録中の音を表示するフレーム
# mac
frame .recinfo.b
button .recinfo.b.rec  -image snackRecord -command {}
button .recinfo.b.play -image snackPlay   -command togglePlay
grid .recinfo.b.rec .recinfo.b.play -sticky news
bind .recinfo.b.rec  <ButtonPress-1>   {
  if {$v(rec) < 2 && $v(recNow) == 0} {
    recStart ;# 手動収録の場合
  } else {
    if $v(recNow) {  ;# 自動収録の場合
      recStop
    } else {
      recStart
    }
  }
}
bind .recinfo.b.rec  <ButtonRelease-1> { if {$v(rec) < 2} recStop }
bind .recinfo.b.rec  <MouseWheel>      { if {%D > 0} prevRec else nextRec }
bind .recinfo.b.play <MouseWheel>      { if {%D > 0} prevRec else nextRec }
bind .recinfo.b.rec  <Shift-MouseWheel> {
  if {%D > 0} {prevRec -save 0} else {nextRec -save 0}
}
bind .recinfo.b.play <Shift-MouseWheel> {
  if {%D > 0} {prevRec -save 0} else {nextRec -save 0}
}

frame .recinfo.showCurrent
grid  .recinfo.b .recinfo.showCurrent -sticky nw

label .recinfo.showCurrent.lr -textvar v(recLab)  \
  -font bigkfont -fg black -bg white
label .recinfo.showCurrent.lt -textvar v(typeLab) \
  -font bigkfont -fg black -bg white
pack .recinfo.showCurrent.lr .recinfo.showCurrent.lt \
  -side left -fill x -expand 1 -anchor center
bind .recinfo.showCurrent.lr <MouseWheel>      { if {%D > 0} prevRec else nextRec }
bind .recinfo.showCurrent.lt <MouseWheel>      { if {%D > 0} prevRec else nextRec }
bind .recinfo.showCurrent.lr <Shift-MouseWheel> {
  if {%D > 0} {prevRec -save 0} else {nextRec -save 0}
}
bind .recinfo.showCurrent.lt <Shift-MouseWheel> {
  if {%D > 0} {prevRec -save 0} else {nextRec -save 0}
}

# 1. 設定関係のフレーム
frame .s
grid  .s -row 1 -column 0 -sticky nw

# 1-1. 音名のリストボックス
frame .s.listboxes
grid  .s.listboxes -sticky nw
set rec [listbox .s.listboxes.rec -listvar v(recList) -height 10 -width 5 \
  -bg $v(bg) -fg $v(fg) \
  -font kfont \
  -yscrollcommand {$srec set} \
  -selectmode single -exportselection 0]
set srec [scrollbar .s.listboxes.srec -command {$rec yview}]
pack $rec $srec -side left -fill both -expand 1
$rec selection set $v(recSeq)

# 1-2. 発声タイプのリストボックス
set type [listbox .s.listboxes.type -listvar v(typeList) -height 10 -width 4 \
  -bg $v(bg) -fg $v(fg) \
  -font kfont \
  -yscrollcommand {$stype set} \
  -selectmode single -exportselection 0]
set stype [scrollbar .s.listboxes.stype -command {$type yview}]
pack $type $stype -side left -fill both -expand 1
$type selection set $v(typeSeq)

# 2. 波形やスペクトルなどの図、保存フォルダなどを表示するフレーム
frame .fig
grid  .fig -row 1 -column 1 -sticky news

# 2-1. 波形などを表示するフレーム
set v(cWidth)  [expr $v(winWidth) - [winfo width .s]]
set v(cHeight) [expr $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh)]
set c [canvas .fig.c -width $v(cWidth) -height $v(cHeight) -bg $v(bg)]
set cYaxis [canvas .fig.cYaxis -width $v(yaxisw) -height $v(cHeight) \
  -bg $v(bg) \
]
grid $c      -row 0 -column 1 -sticky news
grid $cYaxis -row 0 -column 0 -sticky news

# 3. 収録中の音を保存するディレクトリを表示するフレーム
frame .saveDir
grid  .saveDir -row 2 -columnspan 2 -sticky ews
label .saveDir.midashi -text $t(.saveDir.midashi) -fg $v(fg) -bg $v(bg)
button .saveDir.dir -textvar v(saveDir)  \
  -fg $v(fg) -bg $v(bg) -relief solid \
  -command {
    choosesaveDir
    resetDisplay
  }
button .saveDir.sel -image snackOpen -highlightthickness 0 -bg $v(bg) \
  -command {
    choosesaveDir
    resetDisplay
  }
pack .saveDir.midashi -side left
pack .saveDir.dir -side left -fill x -expand 1
pack .saveDir.sel -side left

# 4. メッセージを表示するフレーム
frame .msg
grid  .msg -row 3 -columnspan 2 -sticky ews
pack [label .msg.msg -textvar v(msg) -relief sunken -anchor nw] -fill x -expand 1

# 5. 詳細設定用などの窓
set swindow .settings
set cmwindow .changeMode
set epwindow .epwindow
set entpwindow .entpwindow
set genWindow  .genParam
set prgWindow  .progress

# 6. audio I/O 設定用の窓
set ioswindow .iosettings

wm protocol . WM_DELETE_WINDOW Exit
wm title . "$v(appname) $v(version)"
if {$::tcl_platform(platform) == "windows"} {
  wm minsize . 300 100
  wm resizable . 0 0
} else {
  wm minsize . 300 285
  wm resizable . 1 1
  bind . <Configure> {
    set v(cWidth) [expr [winfo width .] - [winfo width .s] - [winfo width $cYaxis] - 6]
    Redraw scale
  ;#koko 何度も呼ばれるため処理が重たい

  }
  grid columnconfigure . 0 -weight 1   ;# 横方向のリサイズに対応させる
  grid columnconfigure . 1 -weight 1   ;# 横方向のリサイズに対応させる
  grid columnconfigure .fig 1 -weight 1   ;# 横方向のリサイズに対応させる
  grid rowconfigure . 2 -weight 1        ;# 縦方向のリサイズに対応させる
}

#---------------------------------------------------
#
# バインド
#
#puts [array get ::tcl_platform]
#bind . <KeyPress> {puts %K}
if {$::tcl_platform(platform) == "windows"} {
  bind . <KeyPress-r>      recStart
  bind . <KeyPress-0>      recStart
  bind . <KeyPress-R>      autoRecStop
  bind . <KeyRelease-r>    recStop
  bind . <KeyRelease-0>    recStop
} elseif {$::tcl_platform(os) == "Darwin"} {
  bind . <KeyPress-.>      recStart
  bind . <KeyPress-1>      recStart
  bind . <KeyPress-/>      recStop
  bind . <KeyPress-3>      recStop
}
bind . <Down>            nextRec
bind . <KeyPress-2>      nextRec
bind . <Up>              prevRec
bind . <KeyPress-8>      prevRec
bind . <Right>           nextType
bind . <KeyPress-6>      nextType
bind . <Left>            prevType
bind . <KeyPress-4>      prevType
bind . <Control-Down>        { nextRec  -save 0 }
bind . <Control-KeyPress-2>  { nextRec  -save 0 }
bind . <Control-Up>          { prevRec  -save 0 }
bind . <Control-KeyPress-8>  { prevRec  -save 0 }
bind . <Control-Right>       { nextType -save 0 }
bind . <Control-KeyPress-6>  { nextType -save 0 }
bind . <Control-Left>        { prevType -save 0 }
bind . <Control-KeyPress-4>  { prevType -save 0 }
#mac
bind . <Shift-Down>        { nextRec  -save 0 }
bind . <Shift-KeyPress-2>  { nextRec  -save 0 }
bind . <Shift-Up>          { prevRec  -save 0 }
bind . <Shift-KeyPress-8>  { prevRec  -save 0 }
bind . <Shift-Right>       { nextType -save 0 }
bind . <Shift-KeyPress-6>  { nextType -save 0 }
bind . <Shift-Left>        { prevType -save 0 }
bind . <Shift-KeyPress-4>  { prevType -save 0 }

bind . <space>               togglePlay
#bind . <Control-space>       playFromStoE
bind . <Control-p>           togglePlay
#bind . <Control-Alt-p>       playFromStoE
bind . <KeyPress-5>          togglePlay
bind . <KeyPress-o>          toggleOnsaPlay
bind . <KeyPress-O>          toggleOnsaPlay
bind . <KeyPress-c>          {readWavFile; Redraw all}  ;# 波形再読み込み
bind . <KeyPress-m>          toggleMetroPlay
bind . <KeyPress-M>          toggleMetroPlay

bind . <KeyPress-F6> nextRec
bind . <KeyPress-F7> prevRec
bind . <Control-KeyPress-F6> {nextRec -save 0}
bind . <Control-KeyPress-F7> {prevRec -save 0}

if {$::tcl_platform(platform) == "windows"} {
  bind . <Alt-F4>  Exit
} elseif {$::tcl_platform(os) == "Darwin"} {
  ;# bind . <M1-q>  Exit   ;# これは実行してもM1-qを奪う事が出来なかったのでボツ
}

# atode マウスホイールを上下矢印に対応づける？

# リストボックスのマウス操作
bind $rec  <<ListboxSelect>> { jumpRec  [$rec  curselection] }
bind $type <<ListboxSelect>> { jumpType [$type curselection] }
bind $rec  <Control-1>       { jumpRec  [$rec  nearest %y] -save 0}
bind $type <Control-1>       { jumpType [$type nearest %y] -save 0}
bind $rec  <Shift-1>         { jumpRec  [$rec  nearest %y] -save 0}
bind $type <Shift-1>         { jumpType [$type nearest %y] -save 0}

# コンソールの表示
bind . <Control-Alt-d> {
  if {$conState} {
    console hide
    set conState 0
  } else {
    console show
    set conState 1
  }
}

# リストボックスでのホイールスクロール
bind $rec <Enter>   {+set scrollWidget %W}
bind $rec <Leave>   {+set scrollWidget ""}
bind $srec <Enter>  {+set scrollWidget $rec}
bind $srec <Leave>  {+set scrollWidget ""}
bind $type <Enter>  {+set scrollWidget %W}
bind $type <Leave>  {+set scrollWidget ""}
bind $stype <Enter> {+set scrollWidget $type}
bind $stype <Leave> {+set scrollWidget ""}
bind . <MouseWheel> {listboxScroll $scrollWidget %D}

# koko, リストを選択後にctrl+wheelすると、リストの縦スクロールも
# 同時に効いてしまう。今のところ解決法が見つからない。
#
# 横方向拡大縮小 
proc changeSizeX {x y D} {
  global rec
  if {$y > [winfo height .recinfo]} {
    if {$x > [winfo width .s]} {
      # 波形横方向拡大縮小 
      if {$D > 0} {
        changeWidth 0  ;# 縮小
      } else {
        changeWidth 1  ;# 拡大
      }
    } elseif {$::tcl_platform(os) != "Darwin"} {
      if {$x <= [winfo width $rec]} {
        # 音名リスト横方向拡大縮小 
        if {$D > 0} {
          changeRecListWidth 0  ;# 縮小
        } else {
          changeRecListWidth 1  ;# 拡大
        }
      } else {
        # 発声タイプリスト横方向拡大縮小 
        if {$D > 0} {
          changeTypeListWidth 0  ;# 縮小
        } else {
          changeTypeListWidth 1  ;# 拡大
        }
      }
    }
  }
}
proc changeSizeXRec {x y D} {
  global rec
  if {$D > 0} {
    changeRecListWidth 0  ;# 縮小
  } else {
    changeRecListWidth 1  ;# 拡大
  }
}
proc changeSizeXType {x y D} {
  global rec type
  if {$D > 0} {
    changeTypeListWidth 0  ;# 縮小
  } else {
    changeTypeListWidth 1  ;# 拡大
  }
}
if {$::tcl_platform(os) != "Darwin"} {
  bind .     <Control-MouseWheel> {changeSizeX     %x %y %D}
  bind $rec  <Control-MouseWheel> {changeSizeXRec  %x %y %D}
  bind $type <Control-MouseWheel> {changeSizeXType %x %y %D}
} else {
  bind .     <Command-MouseWheel> {changeSizeX     %x %y %D}
  bind $rec  <Command-MouseWheel> {changeSizeXRec  %x %y %D}
  bind $type <Command-MouseWheel> {changeSizeXType %x %y %D}
}

bind . <F11> { changeWidth 0 }  ;# 縮小
bind . <F12> { changeWidth 1 }  ;# 拡大

# 波形拡大縮小(縦方向, Shift+マウスホイール)
bind . <Shift-MouseWheel> {
  if {%y > [winfo height .recinfo]} {
    if {%x > [winfo width .s]} {
      # マウスが波形画面上にある場合
      if {%D > 0} {
        set inc -20    ;# 上向き回転
      } else {
        set inc +20    ;# 下向き回転
      }
      set my [expr %y - [winfo height .recinfo]]
      if {$my <= $v(waveh)} {
        # 波形を拡大・縮小
        incr v(waveh) $inc
        if {$v(waveh) < $v(wavehmin)} {
          set v(waveh) $v(wavehmin)
        }
      } elseif {$my <= [expr $v(waveh) + $v(spech)]} {
        # スペクトルを拡大・縮小
        incr v(spech) $inc
        if {$v(spech) < $v(spechmin)} {
          set v(spech) $v(spechmin)
        }
      } elseif {$my <= [expr $v(waveh) + $v(spech) + $v(powh)]} {
        # パワーを拡大・縮小
        incr v(powh) $inc
        if {$v(powh) < $v(powhmin)} {
          set v(powh) $v(powhmin)       ;# 縮小の最小値
        }
      } elseif {$my <= [expr $v(waveh) + $v(spech) + $v(powh) + $v(f0h)]} {
        # F0を拡大・縮小
        incr v(f0h) $inc
        if {$v(f0h) < $v(f0hmin)} {
          set v(f0h) $v(f0hmin)       ;# 縮小の最小値
        }
      }
      Redraw scale
    } else {
      # マウスが音名リストにある場合
      set rech [$rec cget -height]
      if {%D > 0} {
        ;# 上向き回転
        if {$rech > 3} { incr rech -1 }
        $rec configure -height $rech
        $type configure -height $rech
      } else {
        ;# 下向き回転
        incr rech
        $rec configure -height $rech
        $type configure -height $rech
      }
    }
  }
}

;# 右クリックメニュー
if {$::tcl_platform(os) == "Darwin"} {
  bind $c <Button-2> { PopUpMenu %X %Y %x %y }
} else {
  bind $c <Button-3> { PopUpMenu %X %Y %x %y }
}

#---------------------------------------------------
# 初期化
if {$startup(readRecList)}        { readRecList $v(recListFile) }
if {$startup(readTypeList)}       { readTypeList $v(typeListFile) }
if {$startup(choosesaveDir)}      { choosesaveDir }
if {$startup(makeRecListFromDir)} { makeRecListFromDir }
set f0(showMax) [tone2freq "$f0(showMaxTone)$f0(showMaxOctave)"]
set f0(showMin) [tone2freq "$f0(showMinTone)$f0(showMinOctave)"]
set f0(tgtFreq) [tone2freq "$f0(tgtTone)$f0(tgtOctave)"]
set f0(guideFreqTmp) [tone2freq "$f0(guideTone)$f0(guideOctave)"]
initGenParam
resetDisplay
